// -*- Mode:C++ -*-
//Header:
//File: MapT.h
//Author: NODA, Itsuki
//Date: 2001/11/30
//

//ModifyHistory:
// 2001/11/30: Start to create this file
//EndModifyHistory:

/*
 * Copyright (C) 2001 NODA, Itsuki, CARC, AIST, JAPAN
 */

#ifndef _itk_MapT_h_
#define _itk_MapT_h_
////////////////////////////////////////////////////////////////////////

#include <map>
#include "itk/btype.h"
#include "itk/Exception.h"
#include "itk/WithDescriber.h"

namespace Itk {

   //======================================================================
   // class MapT

   /*--------------------*/
   /**
    * 
    *   \begin{description}
    *     \item[Ex.] To access the value:
    *       \begin{verbatim}
    *  MapT<Foo> foomap ;
    *  foomap[index] = foo0 ;
    *  Foo foo = foomap[index] ;
    *       \end{verbatim}
    *     \item[Ex.] To find the entry:
    *       \begin{verbatim}
    *  MapT<Foo> foomap ;
    *  foomap[index] = foo0 ;
    *  MapT<Foo>::Itr fooitr = foomap.find(index) ;
    *  if(fooitr != foomap.end()) { Foo foo = value(fooirt) ; }
    *       \end{verbatim}
    *   \end{description}
    */

   template <class Key, class Content> 
   class MapT : public WithDescriber, public map< Key, Content > {
      public:
	 virtual const char * className() const { return "Map" ; } ;
	 
	 //--------------------------------------------------
	 //	: MapT<Content> :
	 // local type def
      public:
	 typedef MapT< Key, Content > Map ;

	 typedef Map::iterator Itr ;
	 typedef Map::const_iterator C_Itr ;
	 //typedef reverse_iterator RevItr ;
	 //typedef const_reverse_iterator C_RevItr ;

	 //--------------------------------------------------
	 //	: MapT<Content> :
	 // key and value
	 /*--------------------*/
	 /**
	  * 
	  * Get key for the iterator.
	  */
      public:
	 static       Key & key(Itr & e) { return e->first ; } ;

	 /*--------------------*/
	 /**
	  *
	  * Get constant key for the iterator.
	  */
      public:
	 static const Key & key(C_Itr & e) { return e->first ; } ;

	 //static       Key & key(RevItr & e) { return e->first ; } ;
	 //static const Key & key(C_RevItr & e) { return e->first ; } ;

	 /*--------------------*/
	 /**
	  *
	  * Get value for the iterator.
	  */
      public:
	 static       Content & value(Itr & e) { return e->second ; } ;

	 /*--------------------*/
	 /**
	  *
	  * Get constant value for the iterator.
	  */
      public:
	 static const Content & value(C_Itr & e) { return e->second ; } ;

	 //static       Content & value(RevItr & e) { return e->second ; } ;
	 //static const Content & value(C_RevItr & e) { return e->second ; } ;

	 //--------------------------------------------------
	 //	: MapT<Content> :
	 // describe
	 /*--------------------*/
	 /**
	  *
	  */
      public:
	 virtual void 
	 describe(ostream& ostr, const Bool detailp = True) const {
	    ostr << "#" << className() << "[" << Ptr(this) << "]" ;
	    if(detailp) {
	       ostr << endl ;
	       ostr << "\t[contents]" << endl ;
	       for(C_Itr e = begin() ; e != end() ; e++) {
		  ostr << "\t\t" << key(e)
		       << " : " << value(e) << endl ;
	       }
	    }
	 } ;
   } ;
} ;

////////////////////////////////////////////////////////////////////////
#endif
