// -*- Mode: c++ -*-
//Header:
//File: Mutex.h
//Author: NODA, Itsuki
//Date: 1999/05/18
//

//ModifyHistory:
// 1999/05/18: Start to create this file
// 1999/11/07: introduce Itk namespace
// 1999/11/07: Divide each class to separate file
//EndModifyHistory:

/*
 * Copyright (C) 2001 NODA, Itsuki, CARC, AIST, JAPAN
 * Copyright (C) 1999, 2000 Itsuki Noda, Electrotechnical Laboratory, Japan
 */

#ifndef _itk_Mutex_h_
#define _itk_Mutex_h_
//////////////////////////////////////////////////////////////////////

//======================================================================
// includes

extern "C" {
#ifdef THREADED
#include <pthread.h>
#endif
}


#include "itk/btype.h"
#include "itk/WithDescriber.h"
#include "itk/TimeVal.h"

namespace Itk {
   
//======================================================================
// Mutex

   /*--------------------*/
   /**
    *
    */

   class Mutex {
      public:
#ifdef THREADED
	 pthread_mutex_t entity ;
#endif	 
	 
	 /*--------------------*/
	 /**
	  *
	  */
      public:
	 Mutex() { init() ; } ;
	 //~Mutex() { destroy() ; } ;

      private:
	 void init() {
#ifdef THREADED
	    pthread_mutex_init(&entity,ITK_NULLPTR) ;
#endif	 
	 } ;

      private:
	 void destroy() {
#ifdef THREADED
	    pthread_mutex_destroy(&entity) ;
#endif	 
	 } ;

	 /*--------------------*/
	 /**
	  *
	  */
      public:
	 void lock() {
#ifdef THREADED
	    pthread_mutex_lock(&entity) ;
#endif	 
	 } ;

	 /*--------------------*/
	 /**
	  *
	  */
      public:
	 void unlock() {
#ifdef THREADED
	    pthread_mutex_unlock(&entity) ;
#endif	 
	 } ;

   } ;

}

//////////////////////////////////////////////////////////////////////
#endif
