// -*- Mode: c++ -*-
//Header:
//File: MutexCondVar.h
//Author: NODA, Itsuki
//Date: 1999/05/18
//

//ModifyHistory:
// 1999/05/18: Start to create this file
// 1999/11/07: introduce Itk namespace
// 1999/11/07: Divide each class to separate file
//EndModifyHistory:

/*
 * Copyright (C) 2001 NODA, Itsuki, CARC, AIST, JAPAN
 * Copyright (C) 1999, 2000 Itsuki Noda, Electrotechnical Laboratory, Japan
 */

#ifndef _itk_MutexCondVar_h_
#define _itk_MutexCondVar_h_
//////////////////////////////////////////////////////////////////////

//======================================================================
// includes

extern "C" {
#ifdef THREADED
#include <pthread.h>
#endif
}


#include "itk/btype.h"
#include "itk/WithDescriber.h"
#include "itk/TimeVal.h"
#include "itk/Mutex.h"
#include "itk/CondVar.h"

namespace Itk {
   
//======================================================================
// Mutex

   /*--------------------*/
   /**
    *
    */

   class MutexCondVar {
      public:
	 Mutex mutex ;
	 CondVar cond ;

	 //--------------------------------------------------
	 // constructor / destructor 
	 /*--------------------*/
	 /**
	  *
	  */
      public:
	 MutexCondVar() : mutex() , cond() { init() ; } ;
	 ~MutexCondVar() { destroy() ; } ;

	 /*--------------------*/
	 /**
	  *
	  */
      private:
	 void init() {} ;

	 /*--------------------*/
	 /**
	  *
	  */
      private:
	 void destroy() {} ;

	 //--------------------------------------------------
	 // lock / unlock
	 /*--------------------*/
	 /**
	  *
	  */
      public:
	 void lock() { mutex.lock() ; } ;

	 /*--------------------*/
	 /**
	  *
	  */
      public:
	 void unlock() { mutex.unlock() ; } ;

	 //--------------------------------------------------
	 // signal / broadcast
	 /*--------------------*/
	 /**
	  *
	  */
      public:
	 void signal() { cond.signal() ; } ;

	 /*--------------------*/
	 /**
	  *
	  */
      public:
	 void broadcast() { cond.broadcast() ; } ;

	 //--------------------------------------------------
	 // lockSignal / lockBroadcast
	 /*--------------------*/
	 /**
	  *
	  */
      public:
	 void lockSignal() { lock() ; signal() ; unlock() ; } ;

	 /*--------------------*/
	 /**
	  *
	  */
      public:
	 void lockBroadcast() { lock() ; broadcast() ; unlock() ;} ;

	 //--------------------------------------------------
	 // wait / waitUntil / waitFor
	 /*--------------------*/
	 /**
	  *
	  */
      public:
	 Int wait() { return cond.wait(mutex) ; } ;

	 /*--------------------*/
	 /**
	  *
	  */
      public:
	 Bool waitUntil(TimeVal& expire) {
	    return cond.waitUntil(mutex, expire) ;
	 } ;

	 /*--------------------*/
	 /**
	  *
	  */
      public:
	 Bool waitFor(TimeVal& interval) {
	    return cond.waitFor(mutex, interval) ;
	 } ;

	 /*--------------------*/
	 /**
	  *
	  */
      public:
	 Bool timedWait(TimeVal& expire) {
	    return waitUntil(expire) ;
	 } ;

	 //--------------------------------------------------
	 // lockwait / lockwaitUntil / lockwaitFor
	 /*--------------------*/
	 /**
	  *
	  */
      public:
	 Int lockWait() { 
	    mutex.lock() ;
	    Int r = cond.wait(mutex) ;
	    mutex.unlock() ;
	    return r ; 
	 } ;

	 /*--------------------*/
	 /**
	  *
	  */
      public:
	 Bool lockWaitUntil(TimeVal& expire) {
	    mutex.lock() ;
	    Bool r = cond.waitUntil(mutex, expire) ;
	    mutex.unlock() ;
	    return r ;
	 } ;

	 /*--------------------*/
	 /**
	  *
	  */
      public:
	 Bool lockWaitFor(TimeVal& interval) {
	    mutex.lock() ;
	    Bool r = cond.waitFor(mutex, interval) ;
	    mutex.unlock() ;
	    return r ;
	 } ;

	 /*--------------------*/
	 /**
	  *
	  */
      public:
	 Bool timedLockWait(TimeVal& expire) {
	    return lockWaitUntil(expire) ;
	 } ;

   } ;
};

//////////////////////////////////////////////////////////////////////
#endif
