/* -*- mode: C++ -*- */

/*======================================================================
 * Definition & Initial C Code
 */

/*------------------------------------------------------------
 * options
 */

%option yylineno
%option noyywrap
%option c++
%option prefix="Sexp"
%option 8bit

/*------------------------------------------------------------
 *  C++ codes
 */

%{

#include <stdio.h>

#include "itk/SimpleSexp2.h"

   using namespace Itk ;


/*--------------------------------------------------
 *  define Token Type
 */

#include "itk/SimpleSexp2Token.h"

/*--------------------------------------------------
 *  for debug
 */ 

#define xxx_YY_USER_ACTION {\
	printf("action[%d] : lineno=%d , len=%d, text=\"%s\"\n",\
	       yy_act,yylineno,yyleng,yytext) ;\
	}

%}

/*------------------------------------------------------------
 * Char Definitions
 */

OpenBlock	"("
CloseBlock	")"

BeginComment	";"
EndComment	\n

PairOp		"."

BeginString	\"
EndString	\"


Sign		("+"|"-"|"")

IntNumber	{Sign}[0-9]+

FltNumber1	{Sign}([0-9]+\.|[0-9]*\.[0-9]+)

FltNumber2	({IntNumber}|{FltNumber1})[eE]{IntNumber}

Spaces		[[:space:]]+

/*Symbol		[^{OpenBlock}{CloseBlock}{Spaces}]+ */
Symbol		[^\(\)\;[:space:]]+

String		\"[^"]+\"
IllString	\"[^"]+

/*------------------------------------------------------------
 * Define Mode (start condition)
 */

%x StringMode
%x CommentMode

/*======================================================================
 * Rules
 */
%%

<*><<EOF>>	return Tkn(Eof) ;

{BeginComment}			BEGIN(CommentMode) ;
<CommentMode>{EndComment}	BEGIN(INITIAL) ;
<CommentMode>.

{String}	return Tkn(String) ;

{IllString}	{ ITK_WRN("SimpleSexp2Lexer: eof is detected during string."); 
		  return Tkn(Error) ; }

{OpenBlock}	return Tkn(OpenBlock) ;

{CloseBlock}	return Tkn(CloseBlock) ;

{PairOp}	return Tkn(PairOp) ;

{IntNumber}	return Tkn(IntNumber) ;

{FltNumber1}	|
{FltNumber2}	return Tkn(FltNumber) ;

{Symbol}	return Tkn(Symbol) ;

{Spaces}	

<*>(.|\\n)	{ ITK_WRN("SimpleSexp2Lexer: something wrong.") ; 
		  return Tkn(Error) ; }
		  

%%
/*======================================================================
 * Other C Code
 */

/*------------------------------------------------------------
 * class MySexpFlexLexer
 */

namespace Itk {

   //============================================================
   // class SimpleSexp2Lexer

   class SimpleSexp2Lexer : public SexpFlexLexer {
      public:
	 SimpleSexp2::Scanner * scanner ;

      protected:
	 virtual int LexerInput(char * buf, int max_size) ;
   } ;

   /*--------------------------------------------------
    * input function
    */

   int SimpleSexp2Lexer::LexerInput(char * buf, int max_size) {

      //;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
      // check scanner 

      if(isNull(scanner)) {
	 ITK_ERR("Scanner is not assigned in Lexer.") ;
	 throw 1 ;
      } 
      
      //;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
      // check istream
      
      if(isNull(scanner->istr)) {
	 ITK_ERR("Scanner has not suitable istream.") ;
	 throw 1 ;
      }
	 
      //;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
      // main
      
      istream & istr = *(scanner->istr) ;
      if(max_size > 0 && istr.good()) {
	 int c = istr.get() ;

	 if(c != EOF) {		// check again the char is not EOF
	    *buf = c ;
	    return 1 ;
	 } else {		// else (case EOF), then no more input
	    return 0 ;
	 }
      } else {
	 return 0 ;		// EOF or no buffer
      }
   } ;
   
   /*--------------------------------------------------
    * interface to SimpleSexp2 class
    */

   SimpleSexp2Lexer * newSimpleSexp2Lexer() {
      return new SimpleSexp2Lexer ;
   }

   void deleteSimpleSexp2Lexer(SimpleSexp2Lexer * lexer) {
      delete lexer ;
   }

   void assignSimpleSexp2LexerScanner(SimpleSexp2Lexer * lexer,
				      void * scanner) {
      lexer->scanner = (SimpleSexp2::Scanner *)scanner ;
   } ;

}

/*------------------------------------------------------------
 * interface to bison
 */


//----------------------------------------
// private yylex definition

int SimpleSexp2yylex(YYSTYPE * lvalp, void * scanner) { 
   SimpleSexp2::Scanner * s = 
      static_cast<SimpleSexp2::Scanner *>(scanner) ;
   SimpleSexp2Lexer * lex = s->lexer ;

   TokenType r = TokenType(lex->yylex()) ;

#if 0
   printf("[%d]  type = %s(%d) : value = '%s'\n",
	  lex->lineno(),tokenTypeName(r),r,lex->YYText()) ;
#endif
   
   return r ;
} ;

//----------------------------------------
// private yyerror definition

int SimpleSexp2yyerror(char * s) { 
   cerr << "DBG::SimpleSexp2yyerror(" << s << ")" << endl ;
   return 0 ;
} ;

//----------------------------------------
// pass yytext to bison

const char * SimpleSexp2yytext(SimpleSexp2::Scanner * scanner) {
   return scanner->lexer->YYText() ;
} ;


/*------------------------------------------------------------
 * for debug
 */

#if 0
int main() {
   MySexpFlexLexer lex ;
   while(1) {
      TokenType r = TokenType(lex.yylex()) ;
      if(r == Tkn(Eof)) break ;
      printf("[%d]  type = %s(%d) : value = '%s'\n",
	     lex.lineno(),tokenTypeName(r),r,lex.YYText()) ;
   }
   printf("exit\n") ;
   return 0 ;
}
#endif   

#if 0

extern int SimpleSexp2yyparse(void * lex) ;

int main() {
   SimpleSexp2Lexer MyLex ;
   SimpleSexp2yyparse(&MyLex) ;
}
#endif


