/* -*- mode: C++ -*- */

/*======================================================================
 * Definition & Initial C Code
 */


/*------------------------------------------------------------
 * C codes
 */
%{ 

#include <ctype.h>
#include <stdlib.h>

#include "itk/SimpleSexp2.h"

   using namespace Itk ;

#define YYPARSE_PARAM scanner
#define YYLEX_PARAM scanner
#define MY_SCANNER 	((SimpleSexp2::Scanner *)scanner)
#define MY_LEXER 	MY_SCANNER->lexer
#define MY_YYTEXT 	SimpleSexp2yytext(MY_SCANNER)

   typedef SimpleSexp2::Scanner Scanner ;

   extern int SimpleSexp2yylex(YYSTYPE *lvalp, void * scanner) ;
   extern int SimpleSexp2yyerror(char * s) ;
   extern const char * SimpleSexp2yytext(SimpleSexp2::Scanner * scanner) ;

   static SimpleSexp2 * newAtom(int tokentype, const char * text,
				SimpleSexp2::Scanner * scanner) ;
   static SimpleSexp2 * newCons(SimpleSexp2 * car, SimpleSexp2 * cdr,
				SimpleSexp2::Scanner * scanner) ;
   static SimpleSexp2 * nil = SimpleSexp2::Nil ;
   static SimpleSexp2 * errsym = SimpleSexp2::Error ;
   static SimpleSexp2 * eofsym = SimpleSexp2::Eof ;
				
%}

/*------------------------------------------------------------
 * Bison part
 */

%token SxTm_OpenBlock
%token SxTm_CloseBlock
%token SxTm_PairOp
%token SxTm_IntNumber
%token SxTm_FltNumber
%token SxTm_Symbol
%token SxTm_String
%token SxTm_Other
%token SxTm_Error
%token SxTm_Eof

%start Input

%pure_parser

/*======================================================================
 * Rules
 */
%%

Input : Sexp { MY_SCANNER->result = $$ ; YYACCEPT ; }  
      | SxTm_Eof { MY_SCANNER->result = eofsym ; YYABORT ; } 
      ;

Sexp : Atom { $$ = $1 ; }
     | List { $$ = $1 ; }
     ;

Atom : SxTm_IntNumber { $$ = newAtom(SxTm_IntNumber,MY_YYTEXT,MY_SCANNER) ; }
     | SxTm_FltNumber { $$ = newAtom(SxTm_FltNumber,MY_YYTEXT,MY_SCANNER) ; }
     | SxTm_Symbol    { $$ = newAtom(SxTm_Symbol,MY_YYTEXT,MY_SCANNER) ; }
     | SxTm_String    { $$ = newAtom(SxTm_String,MY_YYTEXT,MY_SCANNER) ; }
     ;

List : SxTm_OpenBlock ListBody { $$ = $2 ; }
     ;

ListBody : SxTm_CloseBlock { $$ = nil ; }
         | Sexp ListTail   { $$ = newCons($1,$2,MY_SCANNER) ; }
	 | SxTm_Eof { ITK_WRN("SimpleSexp2Scanner: eof is detected during list.") ;
		      MY_SCANNER->result = errsym ; YYABORT ; }
         ;

ListTail : SxTm_PairOp Sexp SxTm_CloseBlock { $$ = $2 ; }
         | ListBody                         { $$ = $1 ; }
         ;

%%
/*======================================================================
 * Other C Code
 */

static SimpleSexp2 * newAtom(int tokentype, const char * text,
			     SimpleSexp2::Scanner * scanner) {
   switch(tokentype) {
      case SxTm_IntNumber : 
      case SxTm_FltNumber :
      case SxTm_Symbol :
      case SxTm_String :
	 return scanner->newAtom(text) ;
      default:
	 ITK_ERR("illegal token type for atom : type=" << tokentype
		 << ", text=" << text) ;
	 throw 0 ;
   }

}

static SimpleSexp2 * newCons(SimpleSexp2 * car, SimpleSexp2 * cdr,
			     SimpleSexp2::Scanner * scanner) {
   return scanner->cons(car,cdr) ;
} ;
