// -*- Mode:C++ -*-
//Header:
//File: Thread.cc
//Author: NODA, Itsuki
//Date: 1999/05/18
//

//ModifyHistory:
// 1999/05/18: Start to create this file
// 1999/05/18: Start to create this file
//EndModifyHistory:

/*
 * Copyright (C) 2001 NODA, Itsuki, CARC, AIST, JAPAN
 * Copyright (C) 1999, 2000 Itsuki Noda, Electrotechnical Laboratory, Japan
 */

#include "itk/Thread.h"

namespace Itk {

   //----------------------------------------------------------------------
   // facilities to access thisThread

   /* These definitions are buggy, 
    * because initialization of keyToThreadAssignedP should be done
    * before initialization of mainThread.
    * We have no control to order the initialization
    */

   Bool Thread::keyToThreadAssignedP = False ;

   Mutex Thread::keyToThreadMutex ;

   Thread * Thread::mainThread = new Thread("main",False) ;

#ifdef THREADED
   pthread_key_t Thread::keyToThread ;
#endif

   //----------------------------------------------------------------------
   // default exec functions

   void* Thread::defaultStartFunc(void* p) {
      Thread* thr = (Thread*)p ;

      return thr->waitUntilStarter() ;
   } ;

   //----------------------------------------------------------------------
   // starter

   void * Thread::run(void* p) {
      Thread* thr = static_cast<Thread*>(p) ;
      
      thr->registerThisThread() ;
      
      return (*thr->func)(thr->arg) ;
   } ;
}
