#include <stdio.h>

#include "itk/itk.h"
#include "itk/SimpleSexp.h"
#include "itk/Geo2D.h"
#include "itk/RingBufferT.h"
#include "itk/SString.h"

using namespace Itk ;

//----------------------------------------
int sub1(int argc, char** argv) {

   Bool a = False;
   Int b = -3 ;
   UInt c = 5 ;
   Flt d = 3.14 ;
   OptArg optlist[] = {
      { "a",	OptArg::OnOff,	&a,	0,	"-a {on|off}" },
      { "b",	OptArg::IntVal,	&b,	0,	"-b int" },
      { "c",	OptArg::UIntVal, &c,	0,	"-c unsigned int" },
      { "d",	OptArg::FltVal,	&d,	0,	"-d double" },
      { 0 }
   } ;

   myGetOpt(optlist,argc,argv) ;

   ITK_DBG(a) ;
   ITK_DBG(b) ;
   ITK_DBG(c) ;
   ITK_DBG(d) ;

   return 0 ;

}

//----------------------------------------
int sub2() {
   Buffer b(1024) ;
   SimpleSexp * sexp = SimpleSexp::scan(cin,b) ;

   cout << *sexp << endl ;
   sexp->describe(cout) ;

   return 0 ; 
}

//----------------------------------------
int sub3() {
   SString ss("(car (a b c) \"(00))\" lsl ; (
lskej)") ;
   
   Buffer b(ss) ;
   SimpleSexp * sexp = SimpleSexp::scan(b) ;

   cout << *sexp << endl ;
   sexp->describe(cout) ;

   return 0 ; 
}

//----------------------------------------
int sub4() {
   SString ss("(123 456 78.9 1011 1213)") ;
   Buffer b(ss) ;
   SimpleSexp * sexp = SimpleSexp::scan(b) ;

   cout << "1st= " << *(sexp->first()) 
	<< " = " << sexp->first()->scanAsInt() << endl ;

   cout << "2nd= " << *(sexp->nth(1))
	<< " = " << sexp->nth(1)->scanAsInt() << endl ;

   cout << "3rd= " << *(sexp->nth(2))
	<< " = " << sexp->nth(2)->scanAsFlt() << endl ;

   return 0 ;
}   

//----------------------------------------
int sub5() {
   SString ss("(123 456 78.9 1011 (a b c def \"(a b c)\" 1) 1213)") ;
   Buffer b(ss) ;
   SimpleSexp::Heap heap ;
   SimpleSexp * sexp = SimpleSexp::scan(b,&heap) ;

   cout << "1st= " << *(sexp->first()) 
	<< " = " << sexp->first()->scanAsInt() << endl ;

   cout << "2nd= " << *(sexp->nth(1))
	<< " = " << sexp->nth(1)->scanAsInt() << endl ;

   cout << "3rd= " << *(sexp->nth(2))
	<< " = " << sexp->nth(2)->scanAsFlt() << endl ;
   
   cout << "5th= " << *(sexp->nth(4)) << endl ;


   return 0 ;
}   

//----------------------------------------
int sub6() {
   Geo2D::Vec v1(3,4) ;
   Geo2D::Vec v2(5,6) ;
   ITK_DBG(v1) ;
   ITK_DBG(v2) ;
   ITK_DBG(v1+v2) ;
   ITK_DBG(v1*v2) ;
   ITK_DBG(v1.diffFrom(v2)) ;
   ITK_DBG(v1.diffTo(v2)) ;
   ITK_DBG(v1.diffTo(v2)) ;
   ITK_DBG(v1.angle()) ;
   

   return 0 ;
}

//----------------------------------------
namespace sub7A {
   using namespace Itk ;
   typedef Flt typeA ;
} ;

namespace sub7B {
   using namespace Itk ;
   using namespace sub7A ;
   typedef typeA typeB ;
} ;


int sub7() {
   using namespace sub7A ;
   using namespace sub7B ;
   typeA a ;
   typeB b ;
   a = b = 1 ;

   return (int)(a * b) ;
   
}

//----------------------------------------
int sub8() {
   char str[] = "(this is a pen (((()" ;
   SString sstr(str) ;
   Buffer b(sstr) ;
   SimpleSexp * sexp = SimpleSexp::scan(b) ;

   sexp->describe(cout) ;
   ITK_DBG(*sexp) ;

   return 0 ;

} ;


//----------------------------------------
#include <map>

//typedef map<SubString, Int, &SubString::less> MyMap ;
typedef map<SubString, Int> MyMap ;

void sub9() {
   MyMap m ;

   SubString a("aho") ;
   SubString b("baka") ;
   SubString c0("ahobaka") ;
   SubString c = c0.sub(0,3) ;
   SubString d("baka") ;

   ITK_DBG(c0) ;
   ITK_DBG(c) ;
   
   m[a] = 1 ;
   m[b] = 2 ;

   ITK_DBG(m[a]) ;
   ITK_DBG(m[b]) ;
   ITK_DBG(m[c]) ;
   ITK_DBG(m[d]) ;
   
} ;



//----------------------------------------

typedef RingBufferT<Buffer> StrRingBuffer ;

void sub10() {
   StrRingBuffer buf("foo",5) ;

   for(Int i = 0 ; i < 10 ; i++) {
      buf[i].alloc(256,False) ;
      buf[i].printf("aho%ld",i) ;
      ITK_DBG(buf[i]) ;
   }

   cerr << "------------" << endl ;

   for(Int i = 0 ; i < 10 ; i++) {
      ITK_DBG(buf[i]) ;
   }
   
} ;



//======================================================================
int main(int argc, char** argv) {
   //sub1(argc,argv) ;

   //sub2() ;
   //sub3() ;
   //sub4() ;
   //sub5() ;
   //sub6() ;
   //sub7() ;
   //sub8() ;
   //sub9() ;
   sub10() ;

   return 0 ;
}

   
