// -*- Mode:C++ -*-
//Header:
//File: utility.cc
//Author: NODA, Itsuki
//Date: 1999/05/18
//

//ModifyHistory:
// 1999/05/18: Start to create this file
// 1999/05/18: Start to create this file
//EndModifyHistory:

/*
 * Copyright (C) 2001 NODA, Itsuki, CARC, AIST, JAPAN
 * Copyright (C) 1999, 2000 Itsuki Noda, Electrotechnical Laboratory, Japan
 */

#include "utility.h"

namespace Itk {
//======================================================================
// for debug

   void nop() {} ;
   Int _VerboseLevel = 0 ;

//======================================================================
// random

   void randomize(UInt seed) {
      srandom(seed) ;
   } ;

   void randomizeByTime() {
      TimeVal ctime ;
      ctime.getTimeOfDay() ;
      UInt seed = ctime.usec() + ctime.sec() ;
      randomize(seed) ;
   } ;

   static Bool _impricitRandomize() {
      randomizeByTime() ;
      return True ; 
   } ;

   Bool RandomizedP = _impricitRandomize() ;

//======================================================================
// binomial

   Int binomial(Int n, Flt p) {
      Int c = 0 ;
      for(Int i = 0 ; i < n ; i++) {
	 if(fltRand(1.0) < p) c++ ;
      }
      return c ;
   } 

//======================================================================
// sleep

#ifdef THREADED
   pthread_cond_t  NeverAwakeCV ;
   pthread_mutex_t NeverAwakeMX ;
#endif

//--------------------------------------------------
// sleep

   void sleep(const UInt sec, const UInt msec = 0, const UInt usec = 0) {
#ifdef xTHREADED
      struct timeval ctime ;
      gettimeofday(&ctime,ITK_NULLPTR) ;
      struct timespec etime ;
      UInt eusec = msec * 1000 + usec + ctime.tv_usec ;
      etime.tv_nsec = (eusec % 1000000) * 1000 ;
      etime.tv_sec = sec + ctime.tv_sec + (eusec / 1000000) ;

      pthread_mutex_lock(&NeverAwakeMX) ;
      pthread_cond_timedwait(&NeverAwakeCV,&NeverAwakeMX,&etime) ;
      pthread_mutex_unlock(&NeverAwakeMX) ;
#else
//   sleep(sec) ;
//   usleep(msec * 1000 + usec) ;
      ::usleep(sec * 1000000 + msec * 1000 + usec) ;
#endif
   }

//--------------------------------------------------
// sleepUntil
//	return False if specified etime(expier time) is already over

   Bool sleepUntil(const TimeVal& etime) {
      if(etime.isPast()) return False ;
#ifdef THREADED
      struct timespec etm = etime.in_struct_timespec() ;
      pthread_mutex_lock(&NeverAwakeMX) ;
      pthread_cond_timedwait(&NeverAwakeCV,&NeverAwakeMX,&etm) ;
      pthread_mutex_unlock(&NeverAwakeMX) ;
#else      
      sleep(etime - TimeVal::now()) ;
#endif
      return True;
   }

//--------------------------------------------------
// sleep forever
   
   void sleepForever() {
#ifdef THREADED
      pthread_mutex_lock(&NeverAwakeMX) ;
      pthread_cond_wait(&NeverAwakeCV,&NeverAwakeMX) ;
      pthread_mutex_unlock(&NeverAwakeMX) ;
#else      
      exit(0) ;
#endif
   }
      
}
