// Agent.hxx
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AGENT_HXX__INCLUDED) // {
#define AGENT_HXX__INCLUDED

#include "Address.hxx"

namespace Rescue
{
    /////////////////////////////////////////////////////////////////////////
    // Agent

    class Output;
    class Input;
    /**
    * Уб륯饤Ȥ¸ߤ륪֥
    */
    class Agent
    {
    private:
        
    protected:
        /** 饤ȤΥɥ쥹 */
        Address m_clientAddress;

        /** γоʤФʤʤ */
        bool m_needsSensoryInformation;

        /** ޥ */
        Header m_commandType;
        int m_commandSize;
        Byte* m_commandBuffer;
        
    public:
        virtual ~Agent();
        Agent();

        /** 饤ȤΥɥ쥹ꤹ */
        void setClientAddress(const Address& address);
        /** 饤ȤΥɥ쥹 */
        const Address& clientAddress();

        void setNeedsSensoryInformation(bool needsSensoryInformation);
        bool needsSensoryInformation();

        /** Object* إ㥹Ȥͤ */
        Object* asObject();

        /** Agent 줿ޥɤɤ߹ǵ */
        void inputCommand(Header type, int size, Input& buffer);
        /** ޥɤεꥻåȤ롣getCommandType()  HEADER_NULL ֤褦ˤʤ */
        void resetCommand();
        /** ޥɤμ롣󥹥ȥ饯ľ HEADER_NULL ֤ */
        Header getCommandType();
        /** ޥɤ Simulator ؤѤ˥ХåեϤ */
        void outputCommand(Output& buffer);
        
        
    public:
        /** a cache for broadcasting of voices */
        Objects m_cacheForVoices;
        int m_radiusOfCacheForVoices;
        void resetCacheForVoices();
        
    private:
        Agent(const Agent& source);
        Agent& operator= (const Agent& rhs);
        bool operator== (const Agent& rhs) const;
    };
    
    /////////////////////////////////////////////////////////////////////////
} // namespace Rescue

#ifdef NDEBUG
#  include "Agent.inl"
#endif

#endif // } !defined(AGENT_HXX__INCLUDED)
