// Agent.inl
//
/////////////////////////////////////////////////////////////////////////////

#ifdef NDEBUG
#  include "objects.hxx"
#endif


#ifndef NDEBUG
#  define inline
#else
#  define inline inline
#endif

namespace Rescue
{
	/////////////////////////////////////////////////////////////////////////
	// Agent
	
	inline Agent::Agent()
	{
		m_needsSensoryInformation = false;
		m_commandType = HEADER_NULL;
		m_commandSize = 0;
		m_commandBuffer = 0;
		m_radiusOfCacheForVoices = 0;
	}
	
	inline void Agent::setClientAddress(const Address& address)
	{
		m_clientAddress = address;
	}
	inline const Address& Agent::clientAddress()
	{
		return m_clientAddress;
	}
	inline void Agent::setNeedsSensoryInformation(bool needsSensoryInformation)
	{
		m_needsSensoryInformation = needsSensoryInformation;
	}
	inline bool Agent::needsSensoryInformation()
	{
		return m_needsSensoryInformation;
	}
	inline Object* Agent::asObject()
	{
		Object* result = dynamic_cast<Object*>(this);
		ASSERT(result);
		return result;
	}

	inline void Agent::inputCommand(Header type, int size, Input& buffer)
	{
		if(size > m_commandSize) {
			if(m_commandBuffer) {
				m_commandType = HEADER_NULL;
				m_commandSize = 0;
				delete[] m_commandBuffer;
			}
			m_commandBuffer = new Byte[size];
		}
		m_commandType = type;
		m_commandSize = size;
		buffer.get(size, m_commandBuffer);
	}
	inline void Agent::resetCommand()
	{
		m_commandType = HEADER_NULL;
	}
	inline Header Agent::getCommandType()
	{
		return m_commandType;
	}
	inline void Agent::outputCommand(Output& buffer)
	{
		buffer.put(m_commandSize);
		buffer.put(m_commandSize, m_commandBuffer);
	}
	inline void Agent::resetCacheForVoices()
	{
		m_radiusOfCacheForVoices = 0;
		m_cacheForVoices.clear();
	}

	/*inline Agent::Agent(const Agent& source)
	{
		Agent();
		operator= (source);
	}
	inline Agent& Agent::operator= (const Agent& rhs)
	{
		if(this == &rhs)
			return *this;
		return *this;
	}
	inline bool Agent::operator== (const Agent& rhs) const
	{
		if(this == &rhs)
			return true;
	}*/
	
	/////////////////////////////////////////////////////////////////////////
} // namespace Rescue
#undef inline
