// -*- Mode:C++ -*-
//Header:
//File: AgentBase.cc
//Author: NODA, Itsuki
//Date: 2001/11/24
//

//ModifyHistory:
// 2001/11/24: Start to create this file
//EndModifyHistory:

#include "AgentBase.h"

namespace Rescue {

   //======================================================================
   // class AgentBase
   
   //------------------------------------------------------------
   //   : AgentBase 
   // static vars

   AgentBase::PositTable
   AgentBase::
   commonPositTable ;

   Sexp
   AgentBase::
   noAction_(Sexp::T_Atom,SubString("_no_action_")) ;

   Sexp *
   AgentBase::
   noAction = &noAction_ ;

   //------------------------------------------------------------
   //   : AgentBase 
   // cycle()

   Sexp * 
   AgentBase::cycle() {

      /* clear */
      contextStack().clear() ;
      ctxRuleStack().clear() ;

      // engine().clear() ; /* no effect */

      /* check condition of all rules */

      for(PositStack::Itr posit = situation().begin() ;
	  posit != situation().end() ;
	  posit++) {

	 RSC_EVAL_TRACE_IN(&engine(),
			   "[enter posit " << (*posit)->name() << "]") ;

	 for(Posit::RuleSet::Itr rule = (*posit)->ruleset().begin() ;
	     rule != (*posit)->ruleset().end() ;
	     rule++) {
	 
	    RSC_EVAL_TRACE_IN(&engine(),
			      "[check rule " << (*rule)->name() << "]") ;

	    /* clear context */
	    UInt rewindpos = contextStack().toppos() ;
	    EvalEngine::Context & context = contextStack().get() ;
	    context.setGlobalVarTable(&globalvar()) ;
	    context.clearLocal() ;

	    /* check condition */
	    Bool r = (*rule)->checkCondition(&engine(),&context) ;

	    if(r) {
	       ctxRuleStack().push(CtxRule(*rule,&context)) ;
	    } else {
	       contextStack().rewind(rewindpos) ;
	    }

	    RSC_EVAL_TRACE_OUT(&engine(),
			       r << " = [result of rule " 
			       << (*rule)->name() << "]") ;

	 }

	 RSC_EVAL_TRACE_OUT(&engine(),
			    "[exit " << (*posit)->name() << "]") ;
      }

      /* calc all activity */

      Flt maxact = 0.0 ;
      CtxRule bestrule(ITK_NULLPTR,ITK_NULLPTR) ;

      for(CtxRuleStack::Itr r = ctxRuleStack().begin() ; 
	  r < ctxRuleStack().end() ; r++) {

	 RSC_EVAL_TRACE_IN(&engine(),
			   "[calc activity of " 
			   << (*r).rule()->name() << "]") ;

	 Flt act = (*r).rule()->calcActivity(&engine(),(*r).context()) ;
	 if(isNull(bestrule.rule()) || maxact < act) {
	    bestrule = (*r) ;
	    maxact = act;
	 }

	 RSC_EVAL_TRACE_OUT(&engine(),
			    act << " = [activity of " 
			    << (*r).rule()->name() << "]") ;
      }

      /* exec best rule */

      if(isNull(bestrule.rule())) return noAction ;

      RSC_EVAL_TRACE_IN(&engine(),
			"[exec rule " << bestrule.rule()->name() << "]") ;

      Sexp * sexp =
	 bestrule.rule()->execAction(&engine(),bestrule.context()) ;
      
      RSC_EVAL_TRACE_OUT(&engine(),
			 sexp << " = [done rule " 
			 << bestrule.rule()->name() << "]") ;

      return sexp ;
   }

} ;


