// -*- Mode:C++ -*-
//Header:
//File: EvalEngine.h
//Author: NODA, Itsuki
//Date: 2001/11/19
//

//ModifyHistory:
// 2001/11/19: Start to create this file
//EndModifyHistory:

/*
 * Copyright (C) 2001 NODA, Itsuki, CARC, AIST, JAPAN
 */

#ifndef _itk_EvalEngine_h_
#define _itk_EvalEngine_h_
//////////////////////////////////////////////////////////////////////

#include <map>

#include "itk/SimpleSexp2.h"
#include "itk/StackT.h"

namespace Rescue {

   using namespace Itk ;

   typedef SimpleSexp2 Sexp ;

   //======================================================================
   // class EvalEngine
   /*--------------------*/
   /**
    * 
    */

   class EvalEngine : public WithDescriber {

	 //==================================================
	 // EvalEngine:: 
	 // class Context
	 /*--------------------*/
	 /**
	  * 
	  */
      public:
	 class Context : public WithDescriber {

	       //========================================
	       //  : Context : EvalEngine
	       // class BindTable
	       /*--------------------*/
	       /**
		* 
		*/
	    public:
	       class BindTable : public WithDescriber {

		     //==============================
		     //   : BindTable : Context : EvalEngine
		     // class Entry
		     /*--------------------*/
		     /**
		      * 
		      */
		  public:
		     class Entry : public WithDescriber {
			   /*--------------------*/
			   /**
			    * 
			    */
			public:
			   SubString var ;

			   /*--------------------*/
			   /**
			    * 
			    */
			public:
			   Sexp * value ;

			public:
			   virtual void describe(ostream& ostr, 
						 const Bool detailp = True) 
			      const {
				 ostr << "#Entry[" << var
				      << "=" << *value << "]" ;
				 if(detailp) ostr << endl ;
			   } ;
		     } ;

		     //==============================
		     //   : BindTable : Context : EvalEngine
		     // === BODY ===

		     //------------------------------
		     //   : BindTable : Context : EvalEngine
		     // typedefs
		  public:
		     typedef StackT<Entry> BindStack ;
		     typedef UInt BindStackIndex ;

		     //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
		     //   : BindTable : Context : EvalEngine
		     // members
		     /*--------------------*/
		     /**
		      * 
		      */
		  public:
		     ITK_DEF_ACCESS(BindStack & stack(), { return stack_ ;}) ;
		     BindStack stack_ ;

		     
		     /*--------------------*/
		     /**
		      * 
		      */
		  public:
		     ITK_DEF_ACCESS(Sexp::Heap & sheap(), {
			return sheap_ ; }) ;
		     Sexp::Heap sheap_ ;

		     //------------------------------
		     //   : BindTable : Context : EvalEngine
		     // clear()
		     /*--------------------*/
		     /**
		      * 
		      */
		  public:
		     void clear() ;
			
		     //------------------------------
		     //   : BindTable : Context : EvalEngine
		     // find()
		     /*--------------------*/
		     /**
		      * 
		      */
		  public:
		     Entry * find(const SubString & varname) ;

		     /*--------------------*/
		     /**
		      * 
		      */
		  public:
		     Entry * find(Sexp * var) {
			return find(var->symVal()) ;
		     } ;

		     //------------------------------
		     //   : BindTable : Context : EvalEngine
		     // rfind()
		     /*--------------------*/
		     /**
		      * 
		      */
		  public:
		     Entry * rfind(const SubString & varname) ;

		     /*--------------------*/
		     /**
		      * 
		      */
		  public:
		     Entry * rfind(Sexp * var) {
			return rfind(var->symVal()) ;
		     } ;

		     //------------------------------
		     //   : BindTable : Context : EvalEngine
		     // bind()
		     /*--------------------*/
		     /**
		      * 
		      */
		  public:
		     Entry * bind(const SubString & varname, 
				  Sexp * value,
				  Bool copyp = False) ;

		     /*--------------------*/
		     /**
		      * 
		      */
		  public:
		     Entry * bind(Sexp * var,
				  Sexp * value,
				  Bool copyp = False) {
			return bind(var->symVal(),value,copyp) ;
		     } ;
		     
		     //------------------------------
		     //   : BindTable : Context : EvalEngine
		     // unify()
		     /*--------------------*/
		     /**
		      * 
		      */
		  public:
		     Bool unify(const SubString & varname, 
				Sexp * value,
				Bool copyp = False) ;

		     /*--------------------*/
		     /**
		      * 
		      */
		  public:
		     Bool unify(Sexp * var,
				Sexp * value,
				Bool copyp = False) {
			return unify(var->symVal(),value,copyp) ;
		     } ;
		     
		     //------------------------------
		     //   : BindTable : Context : EvalEngine
		     // let()
		     /*--------------------*/
		     /**
		      * 
		      */
		  public:
		     void let(const SubString & varname, 
			      Sexp * value,
			      Bool copyp = False) ;

		     /*--------------------*/
		     /**
		      * 
		      */
		  public:
		     void let(Sexp * var,
			      Sexp * value,
			      Bool copyp = False) {
			return let(var->symVal(),value,copyp) ;
		     } ;
		     
		     //------------------------------
		     //   : BindTable : Context : EvalEngine
		     // index()
		     /*--------------------*/
		     /**
		      * 
		      */
		  public:
		     BindStackIndex index() const ;

		     //------------------------------
		     //   : BindTable : Context : EvalEngine
		     // rewind()
		     /*--------------------*/
		     /**
		      * 
		      */
		  public:
		     void rewind(const BindStackIndex & idx) ;

		     //------------------------------
		     //   : BindTable : Context : EvalEngine
		     // describe()
		  public:
		     virtual void describe(ostream& ostr, 
					   const Bool detailp = True) const {
			ostr << "#BindTable[" << Ptr(this) << "]" ;
			if(detailp) {
			   ostr << endl ;
			   ostr << "  [bind_table] : " ;
			   stack().describe(ostr,detailp) ;
			   ostr << "  [heap] : " << sheap() << endl ;
			   ostr << "----------------------------------------"
				<< endl ;
			} 
		     } ;
	       } ;

	       //========================================
	       //   : Context : EvalEngine
	       // === BODY ===

	       //----------------------------------------
	       // EvalEngine::Context:: 
	       // typedefs
	       /*--------------------*/
	       /**
		* 
		*/
	    public:
	       typedef BindTable::BindStackIndex BindIndex ;

	       //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	       //   : Context : EvalEngine
	       // member

	       //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	       //   : Context : EvalEngine
	       // localvar & sheap
	       /*--------------------*/
	       /**
		* 
		*/
	    public:
	       ITK_DEF_ACCESS(BindTable & localvar(), { return localvar_ ;}) ;
	       ITK_DEF_ACCESS(Sexp::Heap & localsheap(), { 
		  return localvar().sheap() ;}) ;

	       ITK_DEF_ACCESS(Sexp::Heap & sheap(), { 
		  return localsheap() ;}) ;
	       
	       BindTable localvar_ ;

	       //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	       //   : Context : EvalEngine
	       // staticvar & sheap
	       /*--------------------*/
	       /**
		* 
		*/
	    public:
	       ITK_DEF_ACCESS(BindTable & staticvar(), { 
		  return staticvar_ ;}) ;
	       ITK_DEF_ACCESS(Sexp::Heap & staticsheap(), { 
		  return staticvar().sheap() ;}) ;

	       BindTable staticvar_ ;

	       //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	       //   : Context : EvalEngine
	       // staticvar & sheap
	       /*--------------------*/
	       /**
		* 
		*/
	    public:
	       ITK_DEF_ACCESS(BindTable & globalvar(), { 
		  return *globalvar_ ;});
	       ITK_DEF_ACCESS(Sexp::Heap & globalsheap(), { 
		  return globalvar().sheap() ;});

	       void setGlobalVarTable(BindTable * btable) {
		  globalvar_ = btable ;
	       } ;

	       BindTable * globalvar_ ;
	       //Sexp::Heap * globalsheap_ ;

	       //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	       //   : Context : EvalEngine
	       // commonvar & sheap (static)
	       /*--------------------*/
	       /**
		* 
		*/
	    public:
	       static BindTable commonvar ;

	       //----------------------------------------
	       //   : Context : EvalEngine
	       // constructor
	       /*--------------------*/
	       /**
		* constructor
		*/
	    public:
	       Context() { init() ; } ;
	       
	       //----------------------------------------
	       //   : Context : EvalEngine
	       // init()
	       /*--------------------*/
	       /**
		* 
		*/
	    public:
	       void init() {
		  setGlobalVarTable(&commonvar) ;
	       } ;

	       //----------------------------------------
	       //   : Context : EvalEngine
	       // getValue() 
	       /*--------------------*/
	       /**
		* 
		*/
	    public:
	       Sexp * 
	       getValue(const SubString & varname) ;

	       /*--------------------*/
	       /**
		* 
		*/
	    public:
	       Sexp * 
	       getValue(Sexp * var) {
		  return getValue(var->symVal()) ;
	       } ;

	       //----------------------------------------
	       //   : Context : EvalEngine
	       // local var operations
	       //------------------------------
	       //   : Context : EvalEngine
	       // clearLocal() 
	       /*--------------------*/
	       /**
		* 
		*/
	    public:
	       void clearLocal() ;

	       //------------------------------
	       //   : Context : EvalEngine
	       // findLocal() 
	       /*--------------------*/
	       /**
		* 
		*/
	    public:
	       BindTable::Entry * 
	       findLocal(const SubString & varname) ;

	       /*--------------------*/
	       /**
		* 
		*/
	    public:
	       BindTable::Entry * 
	       findLocal(Sexp * var) {
		  return findLocal(var->symVal()) ;
	       } ;

	       //------------------------------
	       //   : Context : EvalEngine
	       // bindLocal() 
	       /*--------------------*/
	       /**
		* 
		*/
	    public:
	       BindTable::Entry * 
	       bindLocal(const SubString & varname, Sexp * value) ;

	       /*--------------------*/
	       /**
		* 
		*/
	    public:
	       BindTable::Entry * 
	       bindLocal(Sexp * var, Sexp * value) {
		  return bindLocal(var->symVal(),value) ;
	       } ;

	       //------------------------------
	       //   : Context : EvalEngine
	       // unifyLocal() 
	       /*--------------------*/
	       /**
		* 
		*/
	    public:
	       Bool
	       unifyLocal(const SubString & varname, Sexp * value) ;

	       /*--------------------*/
	       /**
		* 
		*/
	    public:
	       Bool
	       unifyLocal(Sexp * var, Sexp * value) {
		  return unifyLocal(var->symVal(),value) ;
	       } ;

	       //------------------------------
	       //   : Context : EvalEngine
	       // letLocal() 
	       /*--------------------*/
	       /**
		* 
		*/
	    public:
	       void
	       letLocal(const SubString & varname, Sexp * value) ;

	       /*--------------------*/
	       /**
		* 
		*/
	    public:
	       void
	       letLocal(Sexp * var, Sexp * value) {
		  return letLocal(var->symVal(),value) ;
	       } ;

	       //------------------------------
	       //   : Context : EvalEngine
	       // newLetLocal() 
	       /*--------------------*/
	       /**
		* 
		*/
	    public:
	       void
	       newLetLocal(const SubString & varname, Sexp * value) ;

	       /*--------------------*/
	       /**
		* 
		*/
	    public:
	       void
	       newLetLocal(Sexp * var, Sexp * value) {
		  return newLetLocal(var->symVal(),value) ;
	       } ;

	       //------------------------------
	       //   : Context : EvalEngine
	       // indexLocal() ;
	       /*--------------------*/
	       /**
		* 
		*/
	    public:
	       BindIndex
	       indexLocal() const ;

	       //------------------------------
	       //   : Context : EvalEngine
	       // rewindLocal() ;
	       /*--------------------*/
	       /**
		* 
		*/
	    public:
	       void 
	       rewindLocal(const BindIndex & idx) ;
	       
	       //----------------------------------------
	       //   : Context : EvalEngine
	       // static var operations
	       //------------------------------
	       //   : Context : EvalEngine
	       // clearStatic() 
	       /*--------------------*/
	       /**
		* 
		*/
	    public:
	       void clearStatic() ;

	       //------------------------------
	       //   : Context : EvalEngine
	       // EvalEngine::Context:: findStatic() 
	       /*--------------------*/
	       /**
		* 
		*/
	    public:
	       BindTable::Entry * 
	       findStatic(const SubString & varname) ;

	       /*--------------------*/
	       /**
		* 
		*/
	    public:
	       BindTable::Entry * 
	       findStatic(Sexp * var) {
		  return findStatic(var->symVal()) ;
	       } ;

	       //------------------------------
	       //   : Context : EvalEngine
	       // bindStatic() 
	       /*--------------------*/
	       /**
		* 
		*/
	    public:
	       BindTable::Entry * 
	       bindStatic(const SubString & varname, Sexp * value) ;

	       /*--------------------*/
	       /**
		* 
		*/
	    public:
	       BindTable::Entry * 
	       bindStatic(Sexp * var, Sexp * value) {
		  return bindStatic(var->symVal(),value) ;
	       } ;

	       //------------------------------
	       //   : Context : EvalEngine
	       // unifyStatic() 
	       /*--------------------*/
	       /**
		* 
		*/
	    public:
	       Bool
	       unifyStatic(const SubString & varname, Sexp * value) ;

	       /*--------------------*/
	       /**
		* 
		*/
	    public:
	       Bool
	       unifyStatic(Sexp * var, Sexp * value) {
		  return unifyStatic(var->symVal(),value) ;
	       } ;

	       //------------------------------
	       //   : Context : EvalEngine
	       // letStatic() 
	       /*--------------------*/
	       /**
		* 
		*/
	    public:
	       void
	       letStatic(const SubString & varname, Sexp * value) ;

	       /*--------------------*/
	       /**
		* 
		*/
	    public:
	       void
	       letStatic(Sexp * var, Sexp * value) {
		  return letStatic(var->symVal(),value) ;
	       } ;

	       //----------------------------------------
	       //   : Context : EvalEngine
	       // global var operations
	       //------------------------------
	       //   : Context : EvalEngine
	       // clearGlobal() 
	       /*--------------------*/
	       /**
		* 
		*/
	    public:
	       void clearGlobal() ;

	       //------------------------------
	       //   : Context : EvalEngine
	       // findGlobal() 
	       /*--------------------*/
	       /**
		* 
		*/
	    public:
	       BindTable::Entry * 
	       findGlobal(const SubString & varname) ;

	       /*--------------------*/
	       /**
		* 
		*/
	    public:
	       BindTable::Entry * 
	       findGlobal(Sexp * var) {
		  return findGlobal(var->symVal()) ;
	       } ;

	       //------------------------------
	       //   : Context : EvalEngine
	       // bindGlobal() 
	       /*--------------------*/
	       /**
		* 
		*/
	    public:
	       BindTable::Entry * 
	       bindGlobal(const SubString & varname, Sexp * value) ;

	       /*--------------------*/
	       /**
		* 
		*/
	    public:
	       BindTable::Entry * 
	       bindGlobal(Sexp * var, Sexp * value) {
		  return bindGlobal(var->symVal(),value) ;
	       } ;

	       //------------------------------
	       //   : Context : EvalEngine
	       // unifyGlobal() 
	       /*--------------------*/
	       /**
		* 
		*/
	    public:
	       Bool
	       unifyGlobal(const SubString & varname, Sexp * value) ;

	       /*--------------------*/
	       /**
		* 
		*/
	    public:
	       Bool
	       unifyGlobal(Sexp * var, Sexp * value) {
		  return unifyGlobal(var->symVal(),value) ;
	       } ;

	       //------------------------------
	       //   : Context : EvalEngine
	       // letGlobal() 
	       /*--------------------*/
	       /**
		* 
		*/
	    public:
	       void
	       letGlobal(const SubString & varname, Sexp * value) ;

	       /*--------------------*/
	       /**
		* 
		*/
	    public:
	       void
	       letGlobal(Sexp * var, Sexp * value) {
		  return letGlobal(var->symVal(),value) ;
	       } ;


	       //----------------------------------------
	       //   : Context : EvalEngine
	       // describe() ;
	    public:
	       virtual void describe(ostream& ostr, 
				     const Bool detailp = True) const {
		  ostr << "#Context[" << Ptr(this) << "]" ;
		  if(detailp) {
		     ostr << endl ;
		     ostr << "  [localvar] : " ;
		     localvar().describe(ostr,detailp) ;
		     ostr << "  [staticvar] : " ;
		     staticvar().describe(ostr,detailp) ;
		     ostr << "  [globalvar] : " ;
		     globalvar().describe(ostr,detailp) ;
		  } 
	       } ;

	 } ;
	 
	 //==================================================
	 //   : EvalEngine
	 // class FuncTable
	 /*--------------------*/
	 /**
	  * 
	  */
      public:
	 typedef Sexp * (*FuncType)(Sexp *, EvalEngine *) ;

	 /*--------------------*/
	 /**
	  * 
	  */
      public:
	 class FuncTable : public WithDescriber, 
			   public map < SubString, FuncType > {
	       //----------------------------------------
	       //   : FuncTable : EvalEngine
	       // typedefs
	    public:
	       typedef iterator Itr ;
	       typedef const_iterator C_Itr ;
	       typedef reverse_iterator RevItr ;
	       typedef const_reverse_iterator C_RevItr ;

	       //----------------------------------------
	       //   : FuncTable : EvalEngine
	       // destructor
	    public:
	       virtual ~FuncTable() {} ;

	       //----------------------------------------
	       //   : FuncTable : EvalEngine
	       // describe
	    public:
	       virtual void describe(ostream& ostr, 
				     const Bool detailp = True) const {
		  ostr << "#FuncTable[" << Ptr(this) << "]" ;

		  if(detailp) {
		     ostr << endl ;
		     ostr << "\t[entries]" << endl ;
		     for(C_Itr f = begin() ; f != end() ; f++) {
			ostr << "\t\t" << f->first 
			     << " : " << Ptr((void *)(f->second))
			     << endl ;
		     }
		  } 
	       } ;
	 } ;
	 
	 //==================================================
	 //   : EvalEngine
	 // === BODY ===

	 //--------------------------------------------------
	 //   : EvalEngine
	 // typedef
	 /*--------------------*/
	 /**
	  * 
	  */
      public:
	 typedef Context::BindIndex RewindPoint ;
	 
	 //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	 //   : EvalEngine
	 // member static const var
	 /*--------------------*/
	 /**
	  * 
	  */
      public:
	 static const char VarPrefixChar = '*' ;

	 //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	 //   : EvalEngine
	 // static member
	 /*--------------------*/
	 /**
	  * 
	  */
      public:
	 ITK_DEF_ACCESS(FuncTable & functable(), { return functable_ ;}) ;
	 static FuncTable functable_ ;


	 /*--------------------*/
	 /**
	  * 
	  */
      public:
	 static void initFuncTable(Bool forcep = False) ;

	 /*--------------------*/
	 /**
	  * 
	  */
      public:
	 static void registerFunc(SubString name,
				  FuncType func,
				  FuncTable * ftab = &functable_) ;

	 /*--------------------*/
	 /**
	  * 
	  */
      public:
	 static void registerFunc(char * name,
				  FuncType func,
				  FuncTable * ftab = &functable_) ;

	 //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	 //   : EvalEngine
	 // member var
	 /*--------------------*/
	 /**
	  * 
	  */
      public:
	 static Context commonContext ;

	 /*--------------------*/
	 /**
	  * 
	  */
      public:
	 ITK_DEF_ACCESS(Context & context(), { return *context_ ; }) ;
	 Context * context_ ;

	 /*--------------------*/
	 /**
	  * 
	  */
      public:
	 ITK_DEF_ACCESS(Sexp::Heap & sheap(), { 
	    return context().sheap() ; }) ;

	 /*--------------------*/
	 /**
	  * 
	  */
      public:
	 Bool tracep ;

	 /*--------------------*/
	 /**
	  * 
	  */
      public:
	 Int tracelevel ;

	 //--------------------------------------------------
	 //   : EvalEngine
	 // constructor
	 /*--------------------*/
	 /**
	  * constructor
	  */
      public:
	 EvalEngine() { init() ; } ;

	 //--------------------------------------------------
	 //   : EvalEngine
	 // init()
	 /*--------------------*/
	 /**
	  * 
	  */
      public:
	 void init() { 
	    initFuncTable() ; 
	    tracep = False ;
	    context_ = &commonContext ;
	 } ;
	 
	 //--------------------------------------------------
	 //   : EvalEngine
	 // clear() 
	 /*--------------------*/
	 /**
	  * 
	  */
      public:
	 void clear() ;

	 //--------------------------------------------------
	 //   : EvalEngine
	 // rewindpoint() ;
	 /*--------------------*/
	 /**
	  * 
	  */
      public:
	 RewindPoint rewindpoint() const ;
	 
	 /*--------------------*/
	 /**
	  * 
	  */
      public:
	 void rewind(RewindPoint point) ;

	 //--------------------------------------------------
	 //   : EvalEngine
	 // evalTop()
	 /*--------------------*/
	 /**
	  * 
	  */
      public:
	 Sexp * evalTop(Sexp * form, 
			Bool clearp = False,
			Context * ctx = ITK_NULLPTR) ;

	 //--------------------------------------------------
	 //   : EvalEngine
	 // eval()
	 /*--------------------*/
	 /**
	  * 
	  */
      public:
	 Sexp * eval(Sexp * form) ;

	 /*--------------------*/
	 /**
	  * 
	  */
      public:
	 Sexp * evalFunc(Sexp * form) ;

	 /*--------------------*/
	 /**
	  * 
	  */
#define RSC_EVAL_TRACE_IN(eng,form) {\
	    if((eng)->tracep) {\
	       cerr << "TRC:" ;\
	       for(Int i = 0 ; i < (eng)->tracelevel ; i++) cerr << " " ;\
	       cerr << "[" << (eng)->tracelevel << "]" ;\
	       cerr << "> " << form << endl ;\
	       (eng)->tracelevel++ ;\
	    }\
	 }
	 
	 /*--------------------*/
	 /**
	  * 
	  */
#define RSC_EVAL_TRACE_OUT(eng,form) {\
	    if((eng)->tracep) {\
	       (eng)->tracelevel-- ;\
	       cerr << "TRC:" ;\
	       for(Int i = 0 ; i < (eng)->tracelevel ; i++) cerr << " " ;\
	       cerr << "[" << (eng)->tracelevel << "]" ;\
	       cerr << "< " << form << endl ;\
	    }\
         }

	 //--------------------------------------------------
	 //   : EvalEngine
	 // isVar() 
	 /*--------------------*/
	 /**
	  * 
	  */
      public:
	 Bool isVar(Sexp * form) ;

	 //--------------------------------------------------
	 //   : EvalEngine
	 // trace() 
	 /*--------------------*/
	 /**
	  * 
	  */
      public:
	 void traceOn() { tracep = True ; tracelevel = 0 ; } ;

	 /*--------------------*/
	 /**
	  * 
	  */
      public:
	 void traceOff() { tracep = False ; } ;
	 
	 //--------------------------------------------------
	 //   : EvalEngine
	 // describe
      public:
	 virtual void describe(ostream& ostr, 
			       const Bool detailp = True) const {
	    ostr << "#EvalEngine[" << Ptr(this) << "]" ;
	    if(detailp) {
	       ostr << endl ;
	       ostr << "  [context]" << endl ;
	       context().describe(ostr,detailp) ;
	       ostr << "  [functions]" << endl ;
	       functable().describe(ostr,detailp) ;
	    } 
	 } ;
   } ;

   //======================================================================
   // system functions
   
   //--------------------------------------------------
   // sysfunc: arity check macro

   /*--------------------*/
   /**
    * 
    */
#define EVAL_CHK_ARITY(form,arity) {\
	 if(form->rest()->length() != arity) {\
           ITK_ERR("wrong arity (" << arity << ") : " << form) ; \
           throw 0 ;\
         }\
     }

   /*--------------------*/
   /**
    * 
    */
#define EVAL_CHK_ARITY2(form,min_arity,max_arity) {\
         Int arity = form->rest()->length() ;\
	 if(arity < min_arity || arity > max_arity) {\
           ITK_ERR("wrong arity (" << arity_min << "," << arity_max \
                   << ") : " << form) ; \
           throw 0 ;\
         }\
     }

   //--------------------------------------------------
   // sysfunc: logical operation

   /*--------------------*/
   /**
    * 
    */

   Sexp * sysfunc_and(Sexp * form, 
			     EvalEngine * engine) ;

   /*--------------------*/
   /**
    * 
    */

   Sexp * sysfunc_or(Sexp * form, 
			    EvalEngine * engine) ;

   /*--------------------*/
   /**
    * 
    */

   Sexp * sysfunc_not(Sexp * form, 
			     EvalEngine * engine) ;

   //--------------------------------------------------
   // sysfunc: procedual operation

   /*--------------------*/
   /**
    * 
    */

   Sexp * sysfunc_do(Sexp * form, 
			    EvalEngine * engine) ;

   /*--------------------*/
   /**
    * 
    */

   Sexp * sysfunc_quote(Sexp * form, 
			       EvalEngine * engine) ;


   /*--------------------*/
   /**
    * 
    */

   Sexp * sysfunc_setq_local(Sexp * form, 
				    EvalEngine * engine) ;

   /*--------------------*/
   /**
    * 
    */

   Sexp * sysfunc_setq_static(Sexp * form, 
				     EvalEngine * engine) ;

   /*--------------------*/
   /**
    * 
    */

   Sexp * sysfunc_setq_global(Sexp * form, 
				     EvalEngine * engine) ;


   //--------------------------------------------------
   // sysfunc: numerical operation

   /*--------------------*/
   /**
    * 
    */

   Sexp * sysfunc_add(Sexp * form, 
			     EvalEngine * engine) ;

   /*--------------------*/
   /**
    * 
    */

   Sexp * sysfunc_sub(Sexp * form, 
			     EvalEngine * engine) ;

   /*--------------------*/
   /**
    * 
    */

   Sexp * sysfunc_mul(Sexp * form, 
			     EvalEngine * engine) ;

   /*--------------------*/
   /**
    * 
    */

   Sexp * sysfunc_div(Sexp * form, 
			     EvalEngine * engine) ;

   /*--------------------*/
   /**
    * 
    */

  // by kshinoda
   SimpleSexp2 * sysfunc_mod(SimpleSexp2 * form,
			     EvalEngine * engine) ;

   //--------------------------------------------------
   // sysfunc: comparison

   /*--------------------*/
   /**
    * 
    */

   Sexp * sysfunc_varunify(Sexp * form, 
				  EvalEngine * engine) ;

   /*--------------------*/
   /**
    * 
    */

   Sexp * sysfunc_equal(Sexp * form, 
			       EvalEngine * engine) ;

   /*--------------------*/
   /**
    * 
    */

   Sexp * sysfunc_lt(Sexp * form, 
			    EvalEngine * engine) ;

   /*--------------------*/
   /**
    * 
    */

   Sexp * sysfunc_le(Sexp * form, 
			    EvalEngine * engine) ;

   /*--------------------*/
   /**
    * 
    */

   Sexp * sysfunc_gt(Sexp * form, 
			    EvalEngine * engine) ;

   /*--------------------*/
   /**
    * 
    */

   Sexp * sysfunc_ge(Sexp * form, 
			    EvalEngine * engine) ;

   //--------------------------------------------------
   // sysfunc: output

   /*--------------------*/
   /**
    * 
    */

   Sexp * sysfunc_print(Sexp * form, 
			EvalEngine * engine) ;
   
   
} ;

//////////////////////////////////////////////////////////////////////
#endif

