// basic.hxx
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(BASIC_HXX__INCLUDED) // {
#define BASIC_HXX__INCLUDED

namespace Rescue
{
	/////////////////////////////////////////////////////////////////////////
	// basic
	
	//typedef u_char	U8;
	//typedef u_short	U16;
	//typedef u_long	U32;
	typedef unsigned char	Byte;
	typedef std::vector<Byte> Bytes;
	
	//typedef signed short	int16_t;
	//typedef signed long		int32_t;
	//typedef unsigned short	uint16_t;
	//typedef unsigned long	uint32_t;
	typedef signed int		int_fast8_t;
	typedef signed int		int_fast16_t;
	typedef signed long		int_fast32_t;
	typedef unsigned int	uint_fast8_t;
	typedef unsigned int	uint_fast16_t;
	typedef unsigned long	uint_fast32_t;
	
	typedef signed char		S8;		// 8bitʾ
	typedef signed short	S16;	// 16bitʾ
	typedef signed long		S32;	// 32bitʾ
									// S8, S16, S32 ϰ㤦ʤvoid foo(S8){} void foo(S16){} void foo(S32){} ϥ顼ǤϤʤ
	const S32 S32_MAX = 0x7FFFFFFF;
	const S32 S32_MIN = -0x7FFFFFFF;

	typedef S32 Id;
	class Object;
	typedef std::list<Object*> Objects;

	typedef S32 Header;
	const Header HEADER_NULL		= 0x00;
	const Header AK_CONNECT			= 0x10;
	const Header AK_ACKNOWLEDGE		= 0x11;
	const Header KA_CONNECT_OK		= 0x50;
	const Header KA_CONNECT_ERROR	= 0x51;
	const Header KA_SENSE			= 0x52;
	const Header KA_HEAR			= 0x53;
	
	const Header SK_CONNECT			= 0x20;
	const Header SK_ACKNOWLEDGE		= 0x21;
	const Header SK_UPDATE			= 0x22;
	const Header KS_CONNECT_OK		= 0x60;
	const Header KS_CONNECT_ERROR	= 0x61;
	const Header KS_COMMANDS		= 0x62;
	const Header KS_UPDATE			= 0x63;
	
	const Header VK_CONNECT			= 0x38;
	const Header VK_ACKNOWLEDGE		= 0x21;
	const Header KV_CONNECT_OK		= 0x60;
	const Header KV_CONNECT_ERROR	= 0x61;
	const Header KV_UPDATE			= 0x63;
	
	const Header GK_CONNECT_OK		= 0x30;
	const Header GK_CONNECT_ERROR	= 0x31;
	const Header KG_CONNECT			= 0x70;
	const Header KG_ACKNOWLEDGE		= 0x71;
	const Header KG_UPDATE			= 0x63;

	const Header HEADER_COMMAND_MIN	= 0x80;	// ޥɤϤ礭

	// RESCUE{ Rescue ¸   RescueSystem.hxx ˤΤŪ basic.hxx ˤ
#include "objdef.enum.h"

	const TypeId TYPE_FIRE_COMPANY = TYPE_FIRE_BRIGADE;
	
	const Header AK_REST			= 0x80;
	const Header AK_MOVE			= 0x81;
	const Header AK_LOAD			= 0x82;
	const Header AK_UNLOAD			= 0x83;
	const Header AK_SAY				= 0x84;
	const Header AK_TELL			= 0x85;
	const Header AK_EXTINGUISH		= 0x86;
	const Header AK_STRETCH			= 0x87;
	const Header AK_RESCUE			= 0x88;
	const Header AK_CLEAR			= 0x89;

	/** Ȥμ 0 Ϥޤ뼫إޥåפ */
	enum {
		AGENTTYPE_CIVILIAN,
		AGENTTYPE_FIRE_COMPANY,
		AGENTTYPE_FIRE_STATION,
		AGENTTYPE_AMBULANCE_TEAM,
		AGENTTYPE_AMBULANCE_CENTER,
		AGENTTYPE_POLICE_FORCE,
		AGENTTYPE_POLICE_OFFICE,
		AGENTTYPE_MAZ,	// max+1
	};
	const TypeId agnetTypeToTypeId[] = {
		TYPE_CIVILIAN,
		TYPE_FIRE_COMPANY,
		TYPE_FIRE_STATION,
		TYPE_AMBULANCE_TEAM,
		TYPE_AMBULANCE_CENTER,
		TYPE_POLICE_FORCE,
		TYPE_POLICE_OFFICE,
	};
	// }ޤ

	/////////////////////////////////////////////////////////////////////////
} // namespace Rescue

#ifdef NDEBUG
#  include "basic.inl"
#endif

#endif // } !defined(BASIC_HXX__INCLUDED)
