#ifndef SIMBLOCKAGE_H__
#define SIMBLOCKAGE_H__

#include "common.hxx"
#include "basic.hxx"
#include "Config.hxx"
#include "Address.hxx"
#include "Input.hxx"
#include "Output.hxx"
#include "LongUDPSocket.hxx"
#include "ObjectPool.hxx"
#include "objects.hxx"

using namespace Rescue;

#define DUMMY 0
#define S_UNDER5 1
#define S_5TO6 2
#define S_6TO7 3
#define S_OVER7 4

enum judgePolygon{
  OUT_SIDE,
  IN_SIDE
};

struct areaProperty{
  long int areaRNum;  //ο٤ΰˤroadܿ
  long int sumBroken; //ο٤ΰˤroad˴ؤݲ٤
                      //(MAX(headBrokenSum, tailBrokenSum))
  double avrBroken; //ο٤ΰˤroad˴ؤʿŪݲ٤
                      //(MAX(headBrokenSum, tailBrokenSum)ʿ)
  double hhBroken;  //Ʊɸк
  double avrBlock;  //ο٤ΰˤroadʿŪĺ
  double hhBlock;   //Ʊɸк
};

struct coordinates{
  long int polyx; //ʬۿޤΥݥꥴιxɸ
  long int polyy; //ʬۿޤΥݥꥴιyɸ
};


//////////////////////
//ʬɲäclass

class ExtRoad : public Road{
  Id extId;  
  short int headBrokenAvr;  //head³ʪݲ٤ʿ  
  short int tailBrokenAvr;  //tail³ʪݲ٤ʿ
  short int shindo;  //roadμ

public:
  Id get_extId(){return extId;}
  short int get_headBrokenAvr(){return headBrokenAvr;}
  short int get_tailBrokenAvr(){return tailBrokenAvr;}
  short int get_shindo(){return shindo;}
  void set_extId(Id dt){extId = dt;}
  void init_headBrokenAvr(){headBrokenAvr=0;}
  void init_tailBrokenAvr(){tailBrokenAvr=0;}
  void set_headBrokenAvr(short int dt){headBrokenAvr = dt;}
  void set_tailBrokenAvr(short int dt){tailBrokenAvr = dt;}
  void set_shindo(short int dt){shindo = dt;}
};


class ExtNode : public Node{
  Id extId;
  short int brokenCnt;
  short int brokenSum;  
  short int brokenAvr;
public:
  Id get_extId(){return extId;}
  short int get_brokenSum(){return brokenSum;}
  short int get_brokenAvr(){return brokenAvr;}
  void set_Id(Id dt){extId = dt;}
  void init_brokens(){brokenSum = 0; brokenCnt = 0; brokenAvr = 0;}
  void add_brokenSum(short int dt){
    ++brokenCnt;
    brokenSum = brokenSum + dt;
    brokenAvr = brokenSum / brokenCnt;
  }
};

typedef std::list<Road*> Roads;
typedef std::list<Node*> Nodes;
typedef std::list<Building*> Buildings;
typedef std::list<ExtRoad*> ExtRoads;
typedef std::list<ExtNode*> ExtNodes;


/////////////
//prototypes
int getShindo(long int tx, long int ty, long int polyNum,
             struct coordinates *polyPtr);
enum judgePolygon polygonIn(long int ptTx, long int ptTy,
                            struct coordinates *polyPtr, long int polySize);

coordinates* getPoly(long int* plyNum, long int* pntNum, coordinates* polyPtr);
void initArea(areaProperty *areaPtr);
long int getBlock(double bbar, double Sb, double dbar, double Sd, areaProperty* areaPtr, ExtRoad* extrPtr);

#endif
