#include "common.hxx"
#include "basic.hxx"
#include "Config.hxx"
#include "Address.hxx"
#include "Input.hxx"
#include "Output.hxx"
#include "LongUDPSocket.hxx"
#include "ObjectPool.hxx"
#include "objects.hxx"
#include "simCollapse.h"
using namespace Rescue;

int main2(int argc, char** argv);
void commands(S32& time, Input& input, Output& output, LongUDPSocket& socket, Address& to, ObjectPool& pool,
              Buildings buildings, Buildings::const_iterator bit, Building* bPtr);

int main(int argc, char** argv)
{
  try {
    return main2(argc, argv);
  } catch(std::exception& e) {
    fprintf(stderr, "%s\n", (const char*)e.what());
  } catch(...) {
    fprintf(stderr, "error...\n");
  }
  return 1;
}

const char* galpolydata = "";
int main2(int argc, char** argv)
{
  const char* host = "localhost";
  Config config;
  
  // 
  int i;
  int count = 0;
  for(i=1; i<argc; i++) {
    if(argv[i][0] == '-') {
      if(strcmp(argv[i], "-file") == 0) {
        if(++i < argc) {
          config.readConfigFile(argv[i]);
        } else {
          fprintf(stderr, "error: '-file'\n");
        }
      } else {
        if(++i < argc) {
          if(!config.setValue(argv[i-1]+1, argv[i]))
            fprintf(stderr, "error: '%s'\n", argv[i]);
        } else {
          fprintf(stderr, "error: '%s'\n", argv[i-1]);
        }
      }
    } else {
      switch(count++) {
      case 0:
        host = argv[i];
        break;
      default:
        fprintf(stderr, "error: '%s'\n", argv[i]);
        break;
      }
    }
  }
  galpolydata = config.galpolydata().c_str();
  
  //variables
  Header type; //typeId
  long int objId; //object id
  Objects::const_iterator oit;
  Buildings buildings; //list to put in Building*
  Buildings::const_iterator bit = 0;
  Object* objPtr; //ObjectsobjectļФƤ
  Building* bPtr;
  long int accel = 0;
  long int answer = 0; //줿ݲ
  int kscon = 0; //KS_CONNECT_OK
  int kscom = 0; //KS_COMMANDS
  int bNum = 0; //buildingο
  int collapsed_num = 0; //number of collapsed buildings
  int mdamage_num = 0; //number of moderate damaged buildings
  int sdamage_num = 0; //number of slight damaged buildings
  int results[3][9][4];
  
  //ΰϿޤɤ߹
  long int polyNum = 0;
  long int pointNum = 0;
  coordinates* polyPtr = NULL;
  polyPtr = getPoly(&polyNum, &pointNum, polyPtr);
  //getPoly(&polyNum, &pointNum, polyPtr);
  
  // åȺ
  LongUDPSocket socket;
  Input input;
  Output output;
  output.setWait(config.send_udp_wait());
  Address to(host, config.port());    //
  
  // ³å
  printf("connecting...\n");
  output.clear();    //ϥХåեˤ
  output.put(SK_CONNECT);    //ϥХåե SK_CONNECT (4ХȤ)Ϥ
  Output::Cursor base = output.put(~(S32)0);    //body ΥȤƤȤꤢߡͤϤƤơbase ˤΰ֤򵭲롣
  output.put(0);    //ϥХåե 0 Ϥ
  output.setSize(base);    //base ǵ֤ˡbase 餳ޤǤ put Хȿꤹ롣
  output.put(HEADER_NULL);
  socket.send(output, to);    //output  put Х to 롣
  
  // å롼
  S32 time = 0;
  ObjectPool pool;
  for(;;) {
    try {
      socket.receive(input);    // TODO: 顼㳰֤     //ǡinput ߤ롣
      for(;;) {
        Header header = input.get();    //input (4ХȤ)ǡФheader 
        if(header == HEADER_NULL)
          break;
        
        S32 size = input.get();
        Input::Cursor start = input.cursor();   //ɤ߽ФƤ֤򵭲
        
        switch(header) {
        default:
          printf("Unknown header.\n");
          break;
        case KS_CONNECT_ERROR:
          printf("Connection failed.\n");
          return 1;
        case KS_CONNECT_OK:
          ++kscon;
          if (kscon >= 2) {
            printf("got KS_CONNECT %d times, using first KS_CONNECT\n", kscon);
            break;
          }

          printf("Connect Ok %d.\n", kscon);
          // ack ֤
          output.clear();
          output.put(SK_ACKNOWLEDGE);
          output.put(~(S32)0);
          output.put(HEADER_NULL);
          socket.send(output, to);
          
          to = socket.addressRecievedFrom();    //ʹߤѹ
          pool.restructure(0, input);    //ɥǥ롣
          
          
          //results
          int i, j, k;
          for (i = 0; i <= 2; i++) {
            for (j = 0; j <= 8; j++) {
              for (k = 0; k <= 3; k++) {
                results[i][j][k] = 0;
              }
            }
          }
          

          oit = pool.objects().begin();
          for( ; oit != pool.objects().end(); oit++){
            objPtr = *oit;
            type = objPtr->type();
            objId = objPtr->id();
            
            switch(type){
            case TYPE_BUILDING:    
              ++bNum;
              bPtr = dynamic_cast<Building*>(objPtr);

              //ɸݥꥴȽΥ⥸塼Ϥ,®٤餦  
              accel = getAccel(bPtr->x(), bPtr->y(), polyNum, polyPtr);
              
              //ݲȽ
              answer = collapse_check(bPtr, accel);
              bPtr->setBrokenness(time, answer);
              
              //⤷줿ʤdifObjs
              switch (bPtr->brokenness()) {
              case COLLAPSE:
                ++collapsed_num;
                buildings.push_back(bPtr);
                ++results[bPtr->buildingAttributes()][accel][3];
                break;
              case MODERATE:
                ++mdamage_num;
                buildings.push_back(bPtr);
                ++results[bPtr->buildingAttributes()][accel][2];
                break;
              case SLIGHT:
                ++sdamage_num;
                buildings.push_back(bPtr);
                ++results[bPtr->buildingAttributes()][accel][1];
                break;
              case NODAMAGE:
                ++results[bPtr->buildingAttributes()][accel][0];
                break;
              } //switch (bPtr->brokenness())
              

            } //switch(type)
            
          } //for( ; oit != pool.objects().end(); oit++)
          
          /*̤פɽ
          for (i = 0; i <= 2; i++){
            printf ("building type = %d\n", i);
            for (j = 0; j <= 8; j++){
              for (k = 0; k <= 3; k++){
                printf ("PGA = %d, damage type = %d, number = %d\n", j, k, results[i][j][k]);
              }
              printf ("\n");
            }
            printf ("\n");
          }
          */
           
          printf("end of KS_CONNECT_OK %d\n\n", kscon);
          break;
          
        case KS_COMMANDS:
          ++kscom;
          printf("KS_COMMANDS %d\n", kscom);
          if (kscom >=2){
            printf("time = %ld\n", (long)time);
            printf("doing nothing...\nend of KS_COMMANDS %d\n\n", kscom);
            break;
          }
          commands(time, input, output, socket, to, pool, buildings, bit, bPtr);
          printf("time = %ld.\n", (long)time);
          printf("end of KS_COMMANDS %d\n\n", kscom);
          break;
          
        case KS_UPDATE:
          printf("KS_UPDATE\n");
          time = input.get();
          pool.restructure(time, input);
          break;
        }
        
        input.setCursor(start);
        input.skip(size);    //size Хȥåפ
      }
    } catch(std::exception& e) {
      fprintf(stderr, "%s\n", (const char*)e.what());
    } catch(...) {
      fprintf(stderr, "error...\n");
    }
  }
  
  return 0;
}

void commands(S32& time, Input& input, Output& output, LongUDPSocket& socket, Address& to, ObjectPool& pool,
              Buildings buildings, Buildings::const_iterator bit, Building* bPtr)
{
  
  //֤
  time = input.get();
  
  // ߥ졼̤
  output.clear();
  output.put(SK_UPDATE);
  Output::Cursor base = output.put(~(S32)0);
  
  bit = buildings.begin();
  for( ; bit != buildings.end(); bit++){
    bPtr = *bit;
    output.put(TYPE_BUILDING);    
    output.put(bPtr->id());
    output.put(PROPERTY_BROKENNESS);
    output.put(bPtr->brokenness());
    output.put(PROPERTY_NULL);
  } //for( ; bit != buildings.end(); bit++)
  
  pool.output(output, time);
  output.setSize(base);
  output.put(HEADER_NULL);
  socket.send(output, to);
}
