
import java.util.*;
import java.io.*;

public class DMake {
    public static void main(final String[] args) {
        try {
            final String[] argv = args;
            final LinkedList queue = new LinkedList();
            File[] files = new File("./").listFiles();
            for (int i = 0; i < files.length; i++) {
                if (files[i].isDirectory())
                    queue.add(files[i]);
            }
            
            Thread[] threads = new Thread[args.length];
            for (int j = 0; j < args.length; j++) {
                final int index = j;
                threads[j] = new Thread() {
                    public void run() {
                        for (;;) {
                            File file;
                            synchronized (queue) {
                                if (queue.isEmpty())
                                    break;
                                file = (File) queue.removeFirst();
                            }
                            try {
                                Runtime runtime = Runtime.getRuntime();
                                String name = file.getCanonicalPath();
                                System.out.println(name + " on " + argv[index]);
                                Process process = runtime.exec(new String[] {
                                    "ssh",
                                    argv[index],
                                    "cd " + name + " ; make",
                                });
                                process.waitFor();
                                System.out.println("done: " + name + " on " + argv[index]);
                            } catch (Exception x) {
                                System.err.println("error");
                            }
                        }
                    }
                };
                threads[j].start();
            }
            
            for (int j = 0; j < args.length; j++) {
                threads[j].join();
            }
        } catch (Exception x) {
            x.printStackTrace();
        }
    }
}

