// AppTechObjectPool.cxx
//
/////////////////////////////////////////////////////////////////////////////

#include <iostream.h>

#include "common.hxx"
#include "AppTech.hxx"
#include "AppTechObjectPool.hxx"
#include "AppTechFlammableBuilding.hxx"


namespace Rescue
{
#ifdef MKDAT
	/**********************************************************************
	!
	!                 ſκɸ
	!
	!**********************************************************************/

	void AppTechFlammableBuilding::jushin_cal()
	{
		XY sum(0,0);

		int size = zahyo.size() - 1;
		int i = 0;
		for (; i < size; i++) {
			sum += zahyo[i];
		}
		ajushin = sum / size;
	}

	/**********************************************************************
	!
	!             ȲΥݥ
	!
	!**********************************************************************/

	void AppTechFlammableBuilding::scl_cal()
	{
		ascl = 0;

		std::vector<XY>::const_iterator it_xy = zahyo.begin();
		for (; it_xy != zahyo.end(); it_xy++) {
			std::vector<XY>::const_iterator it_xy2 = zahyo.begin();
			for (; it_xy2 != zahyo.end(); it_xy2++) {
				double al = abs((*it_xy) - (*it_xy2));
				if (al > ascl) {
					ascl = al;
				}
			}
		}
	}

	/**********************************************************************
	!
	!                 Ļ롦ԲĻȽݥ
	!
	!**********************************************************************/
	void AppTechFlammableBuilding::kashi()
	{
		std::vector<rinsetu> nrin;
		near(nrin);
		pickup(nrin);
	}

	/**********************************************************************
        !
	!                       ᤤȲФ
	!
	!**********************************************************************/
	void AppTechFlammableBuilding::near(std::vector<rinsetu>& nrin)
	{
		Objects::const_iterator it_objects = m_owner->objects().begin();
		for (; it_objects != m_owner->objects().end(); it_objects++) {
			AppTechFlammableBuilding* fb = dynamic_cast<AppTechFlammableBuilding*> (*it_objects);
			if (fb != 0) {
				double dist = abs(ajushin - fb->ajushin);
				if (dist < EPS) {
					continue;
				}
				double rr = dist - (ascl + fb->ascl) / 2;
				if (rr > 20) {
					continue;
				}
				nrin.push_back(rinsetu(fb));
			}
		}
	}

	/**********************************************************************
	!
	!                  ä륪֥ȤȽ
	!
	!**********************************************************************/
	double distmin(const AppTechFlammableBuilding& fb1, const AppTechFlammableBuilding& fb2);
	void AppTechFlammableBuilding::pickup(std::vector<rinsetu>& nrin)
	{
		XY sen[2];
		sen[0] = ajushin;

		//lp1:
		std::vector<rinsetu>::iterator it_nrin = nrin.begin();
		for (; it_nrin != nrin.end(); it_nrin++) {
			double rmin = distmin(*this, *(it_nrin->fb));
			it_nrin->min_dist = rmin;
			double a1, a2, b1, b2;
			a1 = a2 = b1 = b2 = 0;
			if (rmin < 3.0) {
				nrinsetu.push_back(*it_nrin);
				continue;
			} else {
				sen[1] = it_nrin->fb->ajushin;
				double bunshi = XY(sen[1] - sen[0]).y();
				double bunbo  = XY(sen[1] - sen[0]).x();
				bool ifrg;
				if (abs(bunbo) < EPS) {
					ifrg = true;
					b1 = sen[0].x();
				} else {
					ifrg = false;
					a1 = bunshi / bunbo;
					b1 = sen[0].y() - a1 * sen[0].x();
				}
				//lp2:
				std::vector<rinsetu>::iterator it_nrin2 = nrin.begin();
				for (; it_nrin2 != nrin.end(); it_nrin2++) {
					if (it_nrin == it_nrin2) {
						continue;
					}
				//lp3:
					std::vector<XY>::const_iterator it_xy = it_nrin2->fb->zahyo.begin();
					if (it_xy != it_nrin2->fb->zahyo.end()) {
						XY p0, p1;
						p0 = p1 = *it_xy;
						it_xy++;
						for (; it_xy != it_nrin2->fb->zahyo.end(); it_xy++) {
							XY p2 = *it_xy;
							double ya1, ya2, yb1, yb2;
							ya1 = ya2 =  yb1 = yb2 = 0;

							bunshi = XY(p2 - p1).y();
							bunbo  = XY(p2 - p1).x();

							if (abs(bunbo) < EPS) {
								b2 = p2.x();
								if (!ifrg) {
									ya1 = a1 * p1.x() + b1 - p1.y();
									ya2 = a1 * p2.x() + b1 - p2.y();
									yb1 = sen[0].x() - b2;
									yb2 = sen[1].x() - b2;
								} else if (b1 == b2) {
									//continue lp1;
									goto continue_lp1;
								} else {
									//continue lp3;
									goto continue_lp3;
								}
							} else {
								a2 = bunshi / bunbo;
								b2 = p1.y() - a2 * p1.x();
								if (!ifrg) {
									ya1 = a1 * p1.x() + b1 - p1.y();
									ya2 = a1 * p2.x() + b1 - p2.y();
									yb1 = a2 * sen[0].x() + b2 - sen[0].y();
									yb2 = a2 * sen[1].x() + b2 - sen[1].y();
								} else {
									ya1 = p1.x() - b1;
									ya2 = p2.x() - b1;
									yb1 = a2 * sen[0].x() + b2 - sen[0].y();
									yb2 = a2 * sen[1].x() + b2 - sen[1].y();
								}
							}
							if (ya1 * ya2 < 0 && yb1 * yb2 < 0) {
								//continue lp1;
								goto continue_lp1;
							}
						continue_lp3:
							p1 = p2;
						}
					}
				}
				nrinsetu.push_back(*it_nrin);
			}
		continue_lp1:
			;
		}
	}

	/**********************************************************************
	!
	!                ݥꥴ֤κûΥݥ
	!
	!**********************************************************************/
	double __distmin(const XY& p0, const XY& p1, const XY& p2)
	{
		double x1, x2, y1, y2, x10, y10, x12, y12, x20, y20, x21, y21, xx, yy, r2, r3;
		xx = p0.x();
		yy = p0.y();
		x1 = p1.x();
		y1 = p1.y();
		x2 = p2.x();
		y2 = p2.y();

		x10 = xx - x1;
		y10 = yy - y1;
		x12 = x2 - x1;
		y12 = y2 - y1;
		x20 = xx - x2;
		y20 = yy - y2;
		x21 = x1 - x2;
		y21 = y1 - y2;
		r2 = x10 * x12 + y10 * y12;
		r3 = x20 * x21 + y20 * y21;
		if(r2 >= 0 && r3 >= 0) {
			return abs(y21 * xx - x21 * yy + x21 * y1 - y21 * x1) / sqrt(x21 * x21 + y21* y21);
		} else if(r2 < 0) {
			return sqrt(x10 * x10 + y10 * y10);
		} else { //if(r3 < 0) {
			return (x20 * x20 + y20 * y20);
		}
		
	}

	double _distmin(const AppTechFlammableBuilding& fb1, const AppTechFlammableBuilding& fb2)
	{
		double d1min = (abs(fb1.ajushin - fb2.ajushin) + fb1.ascl + fb2.ascl) * 2;
		double d1;

		std::vector<XY>::const_iterator it_xy = fb1.zahyo.begin();
		for (; it_xy != fb1.zahyo.end(); it_xy++) {
			std::vector<XY>::const_iterator it_xy2 = fb2.zahyo.begin();
			if (it_xy2 != fb2.zahyo.end()) {
				XY p0, p1;
				p0 = p1 = *it_xy2++;
				for (; it_xy2 != fb2.zahyo.end(); it_xy2++) {
					d1 = __distmin(*it_xy, p1, *it_xy2);
					if (d1 < d1min) {
						d1min = d1;
					}
					p1 = *it_xy2;
				}
				d1 = __distmin(*it_xy2, p1, p0);
				if (d1 < d1min) {
					d1min = d1;
				}
			}
		}
		return d1min;
	}

	double _distmin2(const AppTechFlammableBuilding& fb1, const AppTechFlammableBuilding& fb2)
	{
		double d1min =  (abs(fb1.ajushin - fb2.ajushin) + fb1.ascl + fb2.ascl) * 2;
		for (int i = 0; i < fb1.zahyo.size() - 1; i++) {		//do i=1,poly1%np-1
			double xx = fb1.zahyo[i].x();				//	xx=poly1%zahyo(i)%x
			double yy = fb1.zahyo[i].y();				//	yy=poly1%zahyo(i)%y
			for (int j = 0; j < fb2.zahyo.size() - 1; j++){		//	do j=1,poly2%np-1
			
				double x1 = fb2.zahyo[j].x();			//		x1=poly2%zahyo(j)%x
				double y1 = fb2.zahyo[j].y();			//		y1=poly2%zahyo(j)%y
				int j2;
				if(j == fb2.zahyo.size()){			//		if(j.eq.poly2%np)then <- bug XXX
					j2 = 1;
				} else {
					j2 = j + 1;
				}
				double x2 = fb2.zahyo[j2].x();
				double y2 = fb2.zahyo[j2].y();

				double x10=xx-x1;
				double y10=yy-y1;
				double x12=x2-x1;
				double y12=y2-y1;
				double x20=xx-x2;
				double y20=yy-y2;
				double x21=x1-x2;
				double y21=y1-y2;
				double r2=x10*x12+y10*y12;
				double r3=x20*x21+y20*y21;
				double d1;
				if (r2 >= 0 && r3 >= 0) {			//		if(r2.ge.0..and.r3.ge.0.)then
					d1=abs(y21*xx-x21*yy+x21*y1-y21*x1)/sqrt(x21*x21+y21*y21);
				}else if(r2 < 0) {				//		elseif(r2.lt.0)then
					d1=sqrt(x10*x10+y10*y10);
				}else if(r3 < 0) {				//		elseif(r3.lt.0)then
					d1=sqrt(x20*x20+y20*y20);
				}						//		endif
				if(d1 <= d1min) d1min=d1;			//		if(d1.le.d1min) d1min=d1
			}					       		//	end do
		}					       			//end do

		double d2min = (abs(fb1.ajushin - fb2.ajushin) + fb1.ascl + fb2.ascl) * 2;
		for (int i=0; i < fb2.zahyo.size() - 1; i++){			//    do i=1,poly2%np-1
			double xx = fb2.zahyo[i].x();				//       xx=poly2%zahyo(i)%x
			double yy = fb2.zahyo[i].y();				//       yy=poly2%zahyo(i)%y
			for (int j = 0; j < fb1.zahyo.size() - 1; j++) {	//       do j=1,poly1%np-1
				double x1 = fb1.zahyo[j].x();			//          x1=poly1%zahyo(j)%x
				double y1 = fb1.zahyo[j].y();			//          y1=poly1%zahyo(j)%y
				int j2;
				if (j == fb1.zahyo.size()) {			//          if(j.eq.poly1%np)then
					j2 = 1;
				} else {					//          else
					j2 = j + 1;
				}						//          endif
				double x2=fb1.zahyo[j2].x();
				double y2=fb1.zahyo[j2].y();
				double x10=xx-x1;
				double y10=yy-y1;
				double x12=x2-x1;
				double y12=y2-y1;
				double x20=xx-x2;
				double y20=yy-y2;
				double x21=x1-x2;
				double y21=y1-y2;
				double r2=x10*x12+y10*y12;
				double r3=x20*x21+y20*y21;
				double d2;
				if (r2 >= 0  && r3 >= 0) {			//          if(r2.ge.0..and.r3.ge.0.)then
					d2=abs(y21*xx-x21*yy+x21*y1-y21*x1)/sqrt(x21*x21+y21*y21);
				}else if (r2 < 0) {				//          elseif(r2.lt.0)then
					d2=sqrt(x10*x10+y10*y10);
				}else if (r3 < 0) {				//          elseif(r3.lt.0)then
					d2=sqrt(x20*x20+y20*y20);
				}						//          endif
				if (d2 <= d2min) d2min = d2;			//          if(d2.le.d2min) d2min=d2
			}							//       end do
		}								//    end do
		return  (d1min < d2min)? d1min: d2min;
	}

	double distmin(const AppTechFlammableBuilding& fb1, const AppTechFlammableBuilding& fb2)
	{
#if 0
		double d1 = _distmin(fb1, fb2);
		double d2 = _distmin(fb2, fb1);


		return (d1 < d2)? d1: d2;
#else
		return _distmin2(fb1, fb2);
#endif 
	}

	/**********************************************************************
	!
	!                ݥꥴ֤θ̤Ѥݥ
	!
	!**********************************************************************/
	double normal_arg(double arg) {
		while (arg >= 2 * M_PI) {
			arg -= 2 * M_PI;
		}
		while (arg < 0) {
			arg += 2 * M_PI;
		}
		return arg;
	}

#if 0
	static double vecarg(const XY & xy) 
	{
		double rr = sqrt(xy.x() * xy.x() + xy.y() * xy.y());

		if (abs(rr) < EPS) {
			return M_PI;
		} else if (xy.y() > 0){
			return acos(xy.x() / rr);			
		} else {
			return 2 * M_PI - abs(acos(xy.x() / rr));			
		}
	}
#endif
	void AppTechFlammableBuilding::angle(rinsetu& ri)
	{
		std::vector<XY>::const_iterator it1 = zahyo.begin();
		std::vector<XY>::const_iterator it2 = ri.fb->zahyo.begin();
		std::vector<XY>::const_iterator it3 = zahyo.begin();
		std::vector<XY>::const_iterator it4 = ri.fb->zahyo.begin();

		double dotp_min = 1;

		for (; it1 != zahyo.end() ; it1++) {
			it2 = ri.fb->zahyo.begin();
			for (; it2 != ri.fb->zahyo.end() ; it2++) {
				it3 = zahyo.begin();
				for (; it3 != zahyo.end() ; it3++) {
					it4 = ri.fb->zahyo.begin();
					for (; it4 != ri.fb->zahyo.end() ; it4++) {
						XY v1 = *it2 - *it1;
						XY v2 = *it4 - *it3;
						
						if (abs(v1) < EPS) {
							goto continue_loop2;
						} 
						if (abs(v2) < EPS) {
							continue;
						}

						// A B cos T / |A||B| = cos T
						double dotp = (v1.x() * v2.x() + v1.y() * v2.y()) / (abs(v1) * abs(v2));
						if (abs(dotp) > 1) {
							dotp /= abs(dotp);
						}
						if (dotp < dotp_min) {
							dotp_min = dotp;
							//double angmin = normal_arg(acos(dotp_min));
							double ang1 = normal_arg(arg(v1));
							double ang2 = normal_arg(arg(v2));
							double sang, eang;
							if (abs(ang2 - ang1) < M_PI) {
								if (ang2 > ang1){
									sang = ang1;
									eang = ang2;
								} else {
									sang = ang2;
									eang = ang1;
								}
							} else {
								if (ang2 > ang1){
									sang = ang2;
									eang = ang1;
								} else {
									sang = ang1;
									eang = ang2;
								}
								
							}
							ri.start_angle = sang;
							ri.end_angle = eang;
						}
					}
				}
			continue_loop2:
				;
			}
		}
	}


	/***********************************************************************
	!
	!			Ѥؿ
	!
        !***********************************************************************/

	static double gaiseki(XY& xy0, XY& xy1)
	{
		return xy0.x() * xy1.y() - xy0.y() * xy1.x();
	}

	/***********************************************************************
	!
	!			Ѥؿ
	!
	!***********************************************************************/
	double AppTechFlammableBuilding::men_cal()
	{
		std::vector<XY>::const_iterator it_xy = zahyo.begin();

		double menseki = 0;

		if (it_xy != zahyo.end()) {
			XY p0 = *it_xy;
			it_xy++;
			if (it_xy != zahyo.end()) {
				XY p1 = *it_xy;
				it_xy++;
				for (; it_xy != zahyo.end(); it_xy++) {
					XY xy0 = p1 - p0;
					XY xy1 = (*it_xy) - p0;
					menseki += gaiseki(xy0, xy1);
					p1 = *it_xy;
				}
			}
		}
		return abs(menseki / 2);
	}

	/**********************************************************************
	!
	!                 Ȳǡݥ
	!
	!**********************************************************************/
	void AppTechObjectPool::mkdat(S32 time)
	{
		puts("in mkdat()");

		// ſ
		Objects::const_iterator it_objects = objects().begin();
		for (; it_objects != objects().end(); it_objects++) {
			AppTechFlammableBuilding* fb = dynamic_cast<AppTechFlammableBuilding*> (*it_objects);
			if (fb != 0) {
				fb->jushin_cal();
			}
		}
		cerr << "jushin_cal OK" << endl;

		// ȲΥݥ
		it_objects = objects().begin();
		for (; it_objects != objects().end(); it_objects++) {
			AppTechFlammableBuilding* fb = dynamic_cast<AppTechFlammableBuilding*> (*it_objects);
			if (fb != 0) {
				fb->scl_cal();
			}
		}
		cerr << "scl_cal OK" << endl;

		// Ļ롦ԲĻȽݥ
		it_objects = objects().begin();
		for (; it_objects != objects().end(); it_objects++) {
			AppTechFlammableBuilding* fb = dynamic_cast<AppTechFlammableBuilding*> (*it_objects);
			if (fb != 0) {
				fb->kashi();
			}
		}
		cerr << "kashi OK" << endl;

		it_objects = objects().begin();
		for (; it_objects != objects().end(); it_objects++) {
			AppTechFlammableBuilding* fb = dynamic_cast<AppTechFlammableBuilding*> (*it_objects);
			S32 time = 0;
			if (fb != 0) {
				if (fb->floors() == 0) {
					cerr << "ꤵƤޤ:(" << fb->id() << ")2ꤷޤ" << endl;
					fb->setFloors(time, 2);
				}
				if (abs(fb->areaTotal()) < EPS) {
					if (abs(fb->areaGround()) > EPS) {
						cerr << "Ѥ᤮ޤ:(" << fb->id() << ")1Ѥꤷޤ" << endl;
						fb->setAreaTotal(time, fb->areaGround() * fb->floors());
					} else {
						cerr << "1Ѥ᤮ޤ:(" << fb->id() << ")ꤷޤ" << endl;
						fb->setAreaGround(time, fb->men_cal());
						fb->setAreaTotal(time, fb->areaGround() * fb->floors());
					}
				}
				if (fb->m_buildingCode_mkdat == 0) {
					cerr << "ʪɤꤵƤޤ:(" << fb->id() << ")¤(11)ꤷޤ" << endl;
					fb->m_buildingCode_mkdat = 11;
				}
				std::vector<AppTechFlammableBuilding::rinsetu>::iterator it_rinsetu = fb->nrinsetu.begin();
				for (; it_rinsetu != fb->nrinsetu.end(); it_rinsetu++) {
					fb->angle(*it_rinsetu);
				}
			}
		}

		// ܥǡ
		{
			it_objects= objects().begin();
			int i = 0;
			for(; it_objects!= objects().end(); it_objects++) {
				AppTechFlammableBuilding* fb = dynamic_cast<AppTechFlammableBuilding*>(*it_objects);
				if (fb != 0) {
					printf("%d %ld %ld %.3f %.3f %ld %.3f %.3f %d %d\n",
					       i++, fb->id(), fb->floors(),
					       fb->areaGround(), fb->areaTotal(),
					       fb->m_buildingCode_mkdat,
					       fb->ajushin.x(), fb->ajushin.y(),
					       fb->zahyo.size(), fb->nrinsetu.size());
					std::vector<AppTechFlammableBuilding::rinsetu>::const_iterator it_r = fb->nrinsetu.begin();
					for (; it_r != fb->nrinsetu.end(); it_r++) {
						printf ("%ld %ld %.5f %.5f %.5f\n", 
							fb->id(),
							it_r->fb->id(),
							it_r->min_dist,
							it_r->start_angle,
							it_r->end_angle);
					}
				}
			}
			cout.flush();
		}
		puts("out mkdat()");
		cerr << "mkdat end." << endl;

	}
#endif // MKDAT
}






