// AppTechObjectPool.cxx
//
/////////////////////////////////////////////////////////////////////////////

#include "common.hxx"
#include "AppTech.hxx"
#include "AppTechObjectPool.hxx"

#ifndef NDEBUG
#  include "AppTechObjectPool.inl"
#endif

#include "AppTechFlammableBuilding.hxx"

namespace Rescue
{
	/////////////////////////////////////////////////////////////////////////
	// AppTechObjectPool
	AppTechObjectPool::AppTechObjectPool(const Config& cf)
		:para(cf),tikudat(this),rindat(this),fire(this),now(this),enslog(this),icall(0)
	{
		//icall = 0;
	}

	AppTechObjectPool::~AppTechObjectPool()
	{
	}

	Object* AppTechObjectPool::newObject(TypeId type)
	{
		if(type == TYPE_BUILDING)
			return new AppTechFlammableBuilding(this);
		return ObjectPool::newObject(type);
	}

	void AppTechObjectPool::fireInit(S32 time)
	{
		Objects::const_iterator it_obj = objects().begin();
		for (; it_obj != objects().end(); it_obj++) {
			AppTechFlammableBuilding* fb = dynamic_cast<AppTechFlammableBuilding*> (*it_obj);
			if (fb != 0) {
				if (fb->getTimeIgnitionUpdated() == time) {
					fb->fire.setRankF(fb->ignition(), time * 60);
					if (fb->ignition() == 1) {
						fb->fire.on_time =
							fb->fire_log.start = time * 60;
					}
					fb->setFieryness((time == 0? 1: time), fb->ignition()); 
				}
				if (fb->getTimeBrokennessUpdated() == time) {
					fb->fire.itoukai = (fb->brokenness() == 0? 0: 1);
				}
			}
		}
	}

	void AppTechObjectPool::fireUpdate(S32 time)
	{
		Objects::const_iterator it_obj = objects().begin();
		for (; it_obj != objects().end(); it_obj++) {
			AppTechFlammableBuilding* fb = dynamic_cast<AppTechFlammableBuilding*> (*it_obj);
			if (fb != 0) {
				if (fb->getTimeIgnitionUpdated() == time) {
					fb->fire.setRankF(fb->ignition(), time * 60);
					if (fb->ignition() == 1) {
						fb->fire.on_time =
							fb->fire_log.start = time * 60;
					}
				}
				if (fb->getTimeBrokennessUpdated() == time) {
					fb->fire.itoukai = (fb->brokenness() == 0? 0: 1);
				}
			}
		}
	}

	void AppTechObjectPool::step(S32 time)
	{
		cout << time << "steps start" << endl;
		{
			// ߥ졼ǤβкҾκʬȤ뤿ḽߤͤ¸
			std::vector<AppTechFlammableBuilding*>::const_iterator it = fb_v.begin();
			for(; it != fb_v.end(); it++) {
				AppTechFlammableBuilding* fb = dynamic_cast<AppTechFlammableBuilding*>(*it);
				if(fb != 0) {
					fb->fire.rank_f_bak = fb->fire.rank_f;
					fb->fire.rank_w_bak = fb->fire.rank_w;
				}
			}
			Objects::const_iterator it_objects = objects().begin();
			for(; it_objects != objects().end(); it_objects++) {
				World* w = dynamic_cast<World*>(*it_objects);
				if (w != 0) {
					kisyo.at_ks_ndw = (int)    w->windDirection();
					kisyo.at_ks_wvv = (double) w->windForce() / 0.001;
					break;
				}
			}

			// ߥ졼¹
			calc(time);

			// кҾκʬȤä
			//it = fb_v.begin();
			for(unsigned int i = 0; i < fb_v.size(); i++) {
				//AppTechFlammableBuilding* fb = dynamic_cast<AppTechFlammableBuilding*>(*it);
				AppTechFlammableBuilding* fb = fb_v[i];
				//if(fb != 0) 
				{
					bool change = false;
					if (fb->fire.rank_f_bak != fb->fire.rank_f){
						change = true;
					}
					if (fb->fire.rank_w_bak != fb->fire.rank_w){
						change = true;
					}
					if (change) {
						if (fb->fire.rank_f == 4 && fb->fire.rank_w != 0) {
							fb->setFieryness(time, fb->fire.rank_f + fb->fire.rank_w);
						} else if (fb->fire.rank_f != 4 && fb->fire.rank_w == 0) {
							fb->setFieryness(time, fb->fire.rank_f);
						} else {
							cerr << "Invalid Value !!" << endl;
						}
					}
				}
			}
		}
		cout << time << "steps end" << endl;
	}
/////////////////////////////////////////////////////////////////////////
} // namespace Rescue
