// UDPSocket.hxx
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(UDPSOCKET_HXX__INCLUDED) // {
#define UDPSOCKET_HXX__INCLUDED

#include "basic.hxx"
#include "Address.hxx"

namespace Rescue
{
	/////////////////////////////////////////////////////////////////////////
	// UDPSocket

	/** åȤ餫Υ顼 */
	class SocketError : public std::runtime_error {
	public:
		SocketError(const std::string& what_arg) : runtime_error(what_arg)
		{
		}
	};
	
	/**
	* UDP/IP ˤ³롣
	*/
	class UDPSocket
	{
	private:
		
	protected:
		/** å */
		SOCKET m_socket;
		/** ľ receive Ǽå */
		Address m_addressRecievedFrom;
		
	public:
		virtual ~UDPSocket();
		/** ꤵ줿 Address ĥåȤȤƹۤ */
		UDPSocket(const Address& self = Address(INADDR_ANY, 0, true)); //throw(SocketError)
		
		/** ľ receive Ǽå */
		const Address& addressRecievedFrom() const;

		/** to  buffer  size ХȤ */
		bool send(const Address& to, const char* buffer, int size);
		bool send(const Address& to, const Byte* buffer, int size);
		/**
		* åʤ true 򡢤 false ֤empty() ΤȤ 
		* receive  åޤǥ֥å롣!empty() ΤȤ  
		* receive Ϥ˽λ롣
		*/
		bool empty() const;
		/**
		* å롣
		* @return		硢ХȿХåե
		*				 -2¾Υ顼ξ -1
		*/
		int receive(char* buffer, int size);
		int receive(Byte* buffer, int size);

		/** åȤΤɤ줫åޤԤġǡΤ륽åȤο֤ */
		static int wait(const std::vector<const UDPSocket*>& sockets, int ms);

	private:
		UDPSocket(const UDPSocket& source);
		UDPSocket& operator= (const UDPSocket& rhs);
		bool operator== (const UDPSocket& rhs) const;
	};
	
	/////////////////////////////////////////////////////////////////////////
} // namespace Rescue

#ifdef NDEBUG
#  include "UDPSocket.inl"
#endif

#endif // } !defined(UDPSOCKET_HXX__INCLUDED)
