
#include "common.hxx"
#include "basic.hxx"
#include "Config.hxx"
#include "Address.hxx"
#include "Input.hxx"
#include "Output.hxx"
#include "LongUDPSocket.hxx"

#ifdef APPTECH
#include "AppTechObjectPool.hxx"
#include "objects.hxx"
#include "AppTechFlammableBuilding.hxx"
#define RescueObjectPool AppTechObjectPool
#define FlammableBuilding AppTechFlammableBuilding
#else
#include "RescueObjectPool.hxx"
#include "objects.hxx"
#include "FlammableBuilding.hxx"
#endif

using namespace Rescue;

int main2(int argc, char** argv);
void commands(S32& time, Input& input, Output& output, LongUDPSocket& socket, Address& to, RescueObjectPool& pool, Config& config);
void commands(S32& time, Header type, Input& input, RescueObjectPool& pool, Config& config);
#ifdef APPTECH
void extinguish(S32& time, MovingObject* agent, Input& input, AppTechObjectPool& pool, Config& config);
#else
void extinguish(S32& time, MovingObject* agent, Input& input, ObjectPool& pool, Config& config);
void step(S32& time, ObjectPool& pool, Config& config);
#endif

int main(int argc, char** argv)
{
    try {
        return main2(argc, argv);
    } catch(std::exception& e) {
        fprintf(stderr, "%s\n", (const char*)e.what());
    } catch(...) {
        fprintf(stderr, "error...\n");
    }
    return 1;
}

int main2(int argc, char** argv)
{
    const char* host = "localhost";
    Config config;

    // 
    int i;
    int count = 0;
    for(i=1; i<argc; i++) {
        if(argv[i][0] == '-') {
            if(strcmp(argv[i], "-file") == 0) {
                if(++i < argc) {
                    config.readConfigFile(argv[i]);
                } else {
                    fprintf(stderr, "error: '-file'\n");
                }
            } else {
                if(++i < argc) {
                    if(!config.setValue(argv[i-1]+1, argv[i]))
                        fprintf(stderr, "error: '%s'\n", argv[i]);
                } else {
                    fprintf(stderr, "error: '%s'\n", argv[i-1]);
                }
            }
        } else {
            switch(count++) {
            case 0:
                host = argv[i];
                break;
            default:
                fprintf(stderr, "error: '%s'\n", argv[i]);
                break;
            }
        }
    }

    // åȺ
    LongUDPSocket socket(config.textlogname_samplesimulator());
    Input input;
    Output output;
    output.setWait(config.send_udp_wait());
    output.resetFrameSize(config.send_udp_size());
    Address to(host, config.port());    //

    // ³å
    printf("connecting...\n");
    output.clear();                             //ϥХåեˤ
    output.put(SK_CONNECT);                     //ϥХåե SK_CONNECT (4ХȤ)Ϥ
    Output::Cursor base = output.put(~(S32)0);  //body ΥȤƤȤꤢߡͤϤƤơbase ˤΰ֤򵭲롣
    output.put(0);                              //ϥХåե 0 Ϥ
    output.setSize(base);                       //base ǵ֤ˡbase 餳ޤǤ put Хȿꤹ롣
    output.put(HEADER_NULL);
    socket.send(output, to, -1);                    //output  put Х to 롣

    // å롼
    S32 time = 0;
#ifdef APPTECH
    AppTechObjectPool pool(config);
#else
    RescueObjectPool pool;
#endif
    for(;;) {
        try {
            socket.receive(input);  // TODO: 顼㳰֤ //ǡinput ߤ롣
            for(;;) {
                Header header = input.get();    //input (4ХȤ)ǡФheader 
                if(header == HEADER_NULL)
                    break;

                S32 size = input.get();
                Input::Cursor start = input.cursor();   //ɤ߽ФƤ֤򵭲

                switch(header) {
                default:
                    printf("Unknown header.\n");
                    break;
                case KS_CONNECT_ERROR:
                    printf("Connection failed.\n");
                    return 1;
                case KS_CONNECT_OK:
                    printf("Connect Ok.\n");
                    // ack ֤
                    output.clear();
                    output.put(SK_ACKNOWLEDGE);
                    output.put(~(S32)0);
                    output.put(HEADER_NULL);
                    socket.send(output, to, -1);

                    printf("Initializing...\n");
                    to = socket.addressRecievedFrom();  //ʹߤѹ
                    pool.restructure(0, input);         //ɥǥ롣
    
#ifdef APPTECH
                    pool.fireInit(0);
                    pool.mkdat(0);
                    pool.dataread();
#else
                    pool.setUpMesh(config.mesh_size(), config.mesh_size());
#endif

                    printf("Initialized.\n");
                    break;
                case KS_COMMANDS:
                    commands(time, input, output, socket, to, pool, config);
                    printf("time = %ld.\n", (long)time);
                    break;
                case KS_UPDATE:
                    time = input.get();
                    pool.restructure(time, input);

#ifdef APPTECH
                    pool.fireUpdate(time);
#endif                      
                    break;
                }

                input.setCursor(start);
                input.skip(size);                       //size Хȥåפ
            }
        } catch(std::exception& e) {
            fprintf(stderr, "%s\n", (const char*)e.what());
        } catch(...) {
            fprintf(stderr, "error...\n");
        }
    }
    
    return 0;
}

void commands(S32& time, Input& input, Output& output, LongUDPSocket& socket, Address& to, RescueObjectPool& pool, Config& config)
{
    // KS_COMMANDS 
    time = input.get();
    Header type;

#ifdef APPTECH
    pool.in_tutu.clear();
#endif
    while(type = input.get(), type != HEADER_NULL) {
        S32 size = input.get();
        Input::Cursor start = input.cursor();
        commands(time, type, input, pool, config);
        input.setCursor(start);
        input.skip(size);
    }

    // ƥå
#ifdef APPTECH
    pool.step(time);
#else
    step(time, pool, config);
#endif
    // ߥ졼̤
    output.clear();
    output.put(SK_UPDATE);
    Output::Cursor base = output.put(~(S32)0);
    pool.output(output, time);
    output.setSize(base);
    output.put(HEADER_NULL);
    socket.send(output, to, time);
}

void commands(S32& time, Header type, Input& input, RescueObjectPool& pool, Config& config)
{
    Id sender;
    while(sender = input.get(), sender != 0) {
        S32 size = input.get();
        Input::Cursor start = input.cursor();

        Object* o = pool.get(sender);   //ɥǥ뤫顢sender  ID ˻ĥ֥ȤĥФ
        MovingObject* agent = dynamic_cast<MovingObject*>(o);
        if(agent != 0) {
            switch(type) {
            case AK_EXTINGUISH:
                extinguish(time, agent, input, pool, config);
                break;
            }
        }
        
        input.setCursor(start);
        input.skip(size);
    }
}

#ifdef APPTECH
void extinguish(S32& time, MovingObject* agent, Input& input, AppTechObjectPool& pool, Config& config)
#else
void extinguish(S32& time, MovingObject* agent, Input& input, ObjectPool& pool, Config& config)
#endif
{
#ifdef APPTECH
    while (input.cursor().index() < input.size()) {
        Id targetID = input.get();
        if (targetID == 0)
            break;
        S32 direction = input.get();
        S32 x = input.get();
        S32 y = input.get();
        if (config.ignore_nozzle_position()) {
            x = agent->x();
            y = agent->y();
        }
        S32 quantity = input.get();
        
        Object* target = pool.get(targetID);
        FlammableBuilding* fb = dynamic_cast<FlammableBuilding*>(target);
        if(fb != 0) {
            pool.in_tutu.push_back(AppTechObjectPool::tutu_n(fb, direction, x, y, quantity, config.round_down_quantity()));
        }
        if (!config.accept_multiple_nozzles())
            break;
    }
#else
    Id targetID = input.get();
    Object* target = pool.get(targetID);
    FlammableBuilding* fb = dynamic_cast<FlammableBuilding*>(target);
    if(fb != 0)
        fb->extinguish();
#endif
}

#ifndef APPTECH
void step(S32& time, ObjectPool& pool, Config& config)
{
    Objects::const_iterator it = pool.objects().begin();
    for(; it != pool.objects().end(); it++) {
        FlammableBuilding* fb = dynamic_cast<FlammableBuilding*>(*it);
        if(fb != 0) {
            if(fb->ignition() != 0) {
                fb->ignite();
                fb->setIgnition(time, 0);
            }
            fb->step(time);

        }
    }
}
#endif




