// Input.inl
//
/////////////////////////////////////////////////////////////////////////////

#ifdef NDEBUG
//#  include
#endif

#ifndef NDEBUG
#  define inline
#else
#  define inline inline
#endif

namespace Rescue
{
	/////////////////////////////////////////////////////////////////////////
	// Input
	
	inline Input::Input()
	{
		// TODO: C λͥå
		m_index = 0;
		m_index = m_index-1;
		m_segment = 0;
		m_segment = m_segment-1;
		m_offset = 0;
		m_offset = m_offset-1;
	}

	inline void Input::reset(const Pages& source)
	{
		m_index = 0;
		m_segment = 0;
		m_offset = 0;
		//m_pages.clear();
		m_pages = source;
	}

	inline long Input::size() const
	{
		long result = 0;
		for(unsigned int i=0; i<m_pages.size(); i++)
			result += m_pages[i]->size();
		return result;
	}
	inline Input::Cursor Input::cursor() const
	{
#ifndef NDEBUG
		unsigned long x = 0;
		for(unsigned int i=0; i<m_segment; i++)
			x += m_pages[i]->size();
		x += m_offset;
		ASSERT(x == m_index);
#endif
		return Cursor(m_index, m_segment, m_offset);
	}
	inline void Input::setCursor(Cursor cursor)
	{
		m_index = cursor.m_index;
		m_segment = cursor.m_segment;
		m_offset = cursor.m_offset;
#ifndef NDEBUG
		unsigned long x = 0;
		for(unsigned int i=0; i<m_segment; i++)
			x += m_pages[i]->size();
		x += m_offset;
		ASSERT(x == m_index);
#endif
	}
	inline void Input::skip(long size)
	{
		// TODO: ä᤯Ǥ
		m_index += size;
		unsigned long cursor = m_index;
		for(unsigned int i=0; i<m_pages.size(); i++) {
			if(cursor < m_pages[i]->size()) {
				m_segment = i;
				m_offset = cursor;
				return;
			}
			cursor -= m_pages[i]->size();
		}
		ASSERT(false);
	}

#if 0	// ѻߤ줿
	inline void Input::get(U8& result)
	{
		result = get8();
	}
	inline void Input::get(U16& result)
	{
		result = get16();
	}
	inline void Input::get(U32& result)
	{
		result = get32();
	}
	inline U8 Input::get8()
	{
		return (U8)get32();
	}
	inline U16 Input::get16()
	{
		return (U16)get32();
	}
#endif
	inline S32 Input::get()
	{
		if(m_segment >= m_pages.size())
			throw Overrun();
		ASSERT(0 <= m_segment);
		Byte* p = m_pages[m_segment]->top();
		ASSERT(0 <= m_offset);
#if 0 // 2000/08/25
		if(m_offset+4 > m_pages[m_segment]->size())
			throw Overrun();
#endif
		p += m_offset;
#if 1 // 2000/08/25
		for(;;) {
			if(m_offset < m_pages[m_segment]->size())
				break;
			m_offset -= m_pages[m_segment]->size();
			m_segment++;
			if(m_segment >= m_pages.size())
				throw Overrun();
			p = m_pages[m_segment]->top();
		}
		m_index += 4;
		m_offset += 4;
		if(m_offset > m_pages[m_segment]->size())
			throw Overrun();
#else
		m_index += 4;
		m_offset += 4;
		if(m_offset >= m_pages[m_segment]->size()) {
			m_offset -= m_pages[m_segment]->size();
			m_segment++;
		}
#endif

		typedef unsigned char U8;
		typedef unsigned long U32;
		U8 d1 = *p++;
		U8 d2 = *p++;
		U8 d3 = *p++;
		U8 d4 = *p;
		U32 e1 = (d1 << 8) | d2;
		U32 e2 = (d3 << 8) | d4;
		U32 f = (e1 << 16) | e2;
		
		// TODO: C λͥå
#if -1 == ~0	// 2ɽɤ
		return (S32)f;
#else
		if(f <= 0x7FFFFFFF)
			return (S32)f;
		else
			return -(S32)(~f + 1);
#endif
	}
	inline void Input::getBytes(Bytes& buffer)
	{
#if 1
		// 餫٤
		buffer.clear();
		S32 size = get();
		for(; size > 0; size -= 4) {
			S32 data = get();
			buffer.push_back((Byte)(data >> 24));
			if(size > 1) {
				buffer.push_back((Byte)(data >> 16));
				if(size > 2) {
					buffer.push_back((Byte)(data >> 8));
					if(size > 3)
						buffer.push_back((Byte)data);
				}
			}
		}
#else
		// ǥХå̤λ
		S32 size = get();
		S32 bounded = (size + 3) & ~(S32)3;

		buffer.clear();
		Byte* p = m_pages[m_segment]->top();
		p += m_offset;
		int i=0;
		for(; i<size; i++) {
			while(m_offset >= m_pages[m_segment]->size()) {
				m_offset -= m_pages[m_segment]->size();
				m_segment++;
				if(m_segment >= m_pages.size())
					throw Overrun();
				p = m_pages[m_segment]->top();
			}
			buffer.push_back(*p++);
			m_index++;
			m_offset++;
		}
		if(i<bounded) {
			m_index += bounded - size;
			m_offset += bounded - size;
			for(;;) {
				if(m_offset < m_pages[m_segment]->size())
					break;
				m_offset -= m_pages[m_segment]->size();
				m_segment++;
				if(m_segment >= m_pages.size())
					throw Overrun();
			}
		}
#endif
	}
	inline void Input::get(int size, Byte* buffer)
	{
		ASSERT(size % 4 == 0);
		if(m_segment >= m_pages.size())
			throw Overrun();
		Byte* p = m_pages[m_segment]->top();
		p += m_offset;
		for(int i=0; i<size; i++) {
			for(;;) {
				if(m_offset < m_pages[m_segment]->size())
					break;
				m_offset -= m_pages[m_segment]->size();
				m_segment++;
				if(m_segment >= m_pages.size())
					throw Overrun();
				p = m_pages[m_segment]->top();
			}
			buffer[i] = *p++;
			m_index++;
			m_offset++;
		}
	}
	inline void Input::getString(std::string& result)
	{
		result = "";
		S32 size = get();
		for(; size > 0; size -= 4) {
			S32 data = get();
			result += (char)(Byte)(data >> 24);
			if(size > 1) {
				result += (char)(Byte)(data >> 16);
				if(size > 2) {
					result += (char)(Byte)(data >> 8);
					if(size > 3)
						result += (char)(Byte)data;
				}
			}
		}
	}
	inline std::string Input::getString()
	{
		std::string result;
		getString(result);
		return result;
	}

	/*inline Input::Input(const Input& source)
	{
		Input();
		operator= (source);
	}
	inline Input& Input::operator= (const Input& rhs)
	{
		if(this == &rhs)
			return *this;
		return *this;
	}
	inline bool Input::operator== (const Input& rhs) const
	{
		if(this == &rhs)
			return true;
	}*/
	
	/////////////////////////////////////////////////////////////////////////
} // namespace Rescue
#undef inline
