// Output.hxx
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(OUTPUT_HXX__INCLUDED) // {
#define OUTPUT_HXX__INCLUDED

#include "basic.hxx"

namespace Rescue
{
	/////////////////////////////////////////////////////////////////////////
	// Output
	
	class UDPSocket;
	class Address;
	class Output
	{
	private:
		
	protected:
		long m_wait;
		typedef std::vector<Byte*> Store;
		Store m_store;
		unsigned long m_size;
		unsigned long m_capacity;
		unsigned int m_frameSize;
		enum { m_headerSize = 0x8 };
		
		void resize(unsigned long size);	// ѥƥ m_size ѹ

	public:
		void setWait(long wait);

		class Cursor {
			friend Output;
			unsigned int segment;
			unsigned int offset;
			Cursor(unsigned int s, unsigned int o) {
				segment = s;
				offset = o;
			}
		};

		virtual ~Output();
		Output(int frameSize = 1024);
		void resetFrameSize(int frameSize);
		
		long size() const;
		void resize(long size);

		/** Хåեˤ */
		void clear();

		Cursor put(S32 value);
		void putString(const char* string);
		void put(const Bytes& buffer);
		void put(int size, const Byte* buffer);
		void set(Cursor cursor, S32 value);
		void setSize(Cursor cursor);
		
		void log(FILE* logfp) const;
		bool send(UDPSocket& socket, const Address& to, S16 id, FILE* logfp) const;

	private:
		Output(const Output& source);
		Output& operator= (const Output& rhs);
		bool operator== (const Output& rhs) const;
	};
	
	/////////////////////////////////////////////////////////////////////////
} // namespace Rescue

#ifdef NDEBUG
#  include "Output.inl"
#endif

#endif // } !defined(OUTPUT_HXX__INCLUDED)
