// RescueObjectPool.cxx
//
/////////////////////////////////////////////////////////////////////////////

#include "common.hxx"
#include "RescueObjectPool.hxx"

#ifndef NDEBUG
#  include "RescueObjectPool.inl"
#endif

namespace Rescue
{
    void Building::setFieryness(S32 time, S32 value)
    {
        bool changed = (m_fieryness != value);
        m_fieryness = value;
        m_timeFierynessUpdated = time;
        if(changed)
            m_owner->addFiredObject(this);
    }
    
    /////////////////////////////////////////////////////////////////////////
    // RescueObjectPool
    
    RescueObjectPool::~RescueObjectPool()
    {
    }

    void RescueObjectPool::setUpMesh(int meshX, int meshY)
    {
        m_meshXCount = meshX;
        m_meshYCount = meshY;

        m_movingObjects.clear();
        m_mesh.clear();
        m_mesh.resize(m_meshYCount);
        for(int i=0; i<m_meshYCount; i++)
            m_mesh[i].resize(m_meshXCount);

        S32 xMin = S32_MAX;
        S32 yMin = S32_MAX;
        S32 xMax = S32_MIN;
        S32 yMax = S32_MIN;
        Objects::const_iterator it = objects().begin();
        for(; it != objects().end(); it++) {
            RealObject* ro = dynamic_cast<RealObject*>(*it);
            if(ro != 0) {
                S32 x = ro->x();
                if(x < xMin)
                    xMin = x;
                if(x > xMax)
                    xMax = x;
                S32 y = ro->y();
                if(y < yMin)
                    yMin = y;
                if(y > yMax)
                    yMax = y;
            }
        }

        m_meshXBase = xMin;
        m_meshYBase = yMin;
        m_meshXSize = (xMax - xMin) / m_meshXCount + 1;
        m_meshYSize = (yMax - yMin) / m_meshYCount + 1;
        it = objects().begin();
        for(; it != objects().end(); it++) {
            Object* o = *it;
            if(dynamic_cast<RealObject*>(o) != 0) {
                MotionlessObject* mlo = dynamic_cast<MotionlessObject*>(o);
                if(mlo == 0) {
                    m_movingObjects.push_back(o);
                } else {
                    int x = (mlo->x() - m_meshXBase) / m_meshXSize;
                    if(x >= m_meshXCount)   x = m_meshXCount - 1;
                    if(x < 0)               x = 0;
                    int y = (mlo->y() - m_meshYBase) / m_meshYSize;
                    if(y >= m_meshYCount)   y = m_meshYCount - 1;
                    if(y < 0)               y = 0;
                    m_mesh[y][x].push_back(mlo);
                }
            }
        }
    }
    
    /////////////////////////////////////////////////////////////////////////
} // namespace Rescue
