// RescueObjectPool.inl
//
/////////////////////////////////////////////////////////////////////////////

#ifdef NDEBUG
//#  include
#endif
#include "objects.hxx"

#ifndef NDEBUG
#  define inline
#else
#  define inline inline
#endif

namespace Rescue
{
    /////////////////////////////////////////////////////////////////////////
    // RescueObjectPool
    
    inline RescueObjectPool::RescueObjectPool()
    {
        m_meshXBase = 0;
        m_meshYBase = 0;
        m_meshXSize = 100;
        m_meshYSize = 100;
        m_meshXCount = 1;
        m_meshYCount = 1;
        m_mesh.resize(m_meshYCount);
        for(int i=0; i<m_meshYCount; i++)
            m_mesh[i].resize(m_meshXCount);
    }
    inline void RescueObjectPool::add(Object* newObject)
    {
        newObject->setOwner(this);
        ObjectPool::add(newObject);
        if(dynamic_cast<RealObject*>(newObject) != 0)
            m_movingObjects.push_back(newObject);
    }

    inline void RescueObjectPool::addFiredObject(Object* object)
    {
        m_firedObjects.push_back(object);
    }
    inline void RescueObjectPool::clearFiredObjects()
    {
        m_firedObjects.clear();
    }
    
    inline const Objects& RescueObjectPool::firedObjects() const
    {
        return m_firedObjects;
    }

    inline RescueObjectPool::Enumerator::Enumerator(RescueObjectPool* owner, S32 x, S32 y, S32 r)
    {
        m_owner = owner;
        m_centerX = x;
        m_centerY = y;
        m_squaredRadius = (double)r * r;
        
        S32 tmp = x - r;
        m_xMin = (tmp - owner->m_meshXBase) / owner->m_meshXSize;
        if(m_xMin >= owner->m_meshXCount)   m_xMin = owner->m_meshXCount - 1;
        if(m_xMin < 0)                      m_xMin = 0;
        
        tmp = x + r;
        m_xMaz = (tmp - owner->m_meshXBase) / owner->m_meshXSize + 1;
        if(m_xMaz >= owner->m_meshXCount)       m_xMaz = owner->m_meshXCount - 1;
        if(m_xMaz < 0)                      m_xMaz = 0;
        
        tmp = y - r;
        m_yMin = (tmp - owner->m_meshYBase) / owner->m_meshYSize;
        if(m_yMin >= owner->m_meshYCount)       m_yMin = owner->m_meshYCount - 1;
        if(m_yMin < 0)                      m_yMin = 0;
        
        tmp = y + r;
        m_yMaz = (tmp - owner->m_meshYBase) / owner->m_meshYSize + 1;
        if(m_yMaz >= owner->m_meshYCount)       m_yMaz = owner->m_meshYCount - 1;
        if(m_yMaz < 0)                      m_yMaz = 0;
        
        m_x = m_xMin;
        m_y = m_yMin;
        m_it = m_owner->m_mesh[m_y][m_x].begin();

        //printf("(%d, %d) - (%d, %d)\n", m_xMin, m_yMin, m_xMaz, m_yMaz);
    }
    inline Object* RescueObjectPool::Enumerator::nextCore() {
        for(;;) {
            if(m_x < 0) {
                if(m_y >= 0) {
                    if(m_it != m_owner->m_movingObjects.end())
                        return *m_it++;
                    m_y = -1;
                }
                return 0;
            }
            if(m_it != m_owner->m_mesh[m_y][m_x].end())
                return *m_it++;
            if(++m_x >= m_xMaz) {
                m_x = m_xMin;
                if(++m_y >= m_yMaz) {
                    m_x = -1;
                    m_y = 0;
                    m_it = m_owner->m_movingObjects.begin();
                    continue;
                }
            }
            m_it = m_owner->m_mesh[m_y][m_x].begin();
        }
    }
    inline Object* RescueObjectPool::Enumerator::next() {
        Object* result;
        while(result = nextCore(), result != 0) {
            ASSERT(dynamic_cast<RealObject*>(result) != 0);
            RealObject* ro = (RealObject*)result;
            double x = ro->x() - m_centerX;
            double y = ro->y() - m_centerY;
            if(x*x + y*y <= m_squaredRadius)
                break;
        }
        return result;
    }
    inline RescueObjectPool::Enumerator RescueObjectPool::objectsInRound(S32 x, S32 y, S32 r) {
        return Enumerator(this, x, y, r);
    }

    /*inline RescueObjectPool::RescueObjectPool(const RescueObjectPool& source)
    {
        RescueObjectPool();
        operator= (source);
    }
    inline RescueObjectPool& RescueObjectPool::operator= (const RescueObjectPool& rhs)
    {
        if(this == &rhs)
            return *this;
        return *this;
    }
    inline bool RescueObjectPool::operator== (const RescueObjectPool& rhs) const
    {
        if(this == &rhs)
            return true;
    }*/

    /////////////////////////////////////////////////////////////////////////
} // namespace Rescue
#undef inline
