// RescueSystem.hxx
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(RESCUESYSTEM_HXX__INCLUDED) // {
#define RESCUESYSTEM_HXX__INCLUDED

#include "System.hxx"

namespace Rescue
{
    /////////////////////////////////////////////////////////////////////////
    // RescueSystem
    
    /** kernel Υ */
    class RescueSystem : public System
    {
    private:
        
    protected:
    public:
        virtual ~RescueSystem();
        RescueSystem();
        
        virtual void loop();
        virtual void resetAgents();
        virtual void outputObjectForAgentsAtStart(const Object* o, Output& buffer);
        virtual void outputObjectForAgents(const Object* o, Output& buffer);
        virtual void outputFarBuildingForAgents(const Building* o, Output& buffer);
        virtual void sendToAgents();
        virtual void processCommand(Agent* agent, Header header, S32 size, Input& input, const LongUDPSocket& from);
        void say(Id from, char* message);
        void buildCacheForVoices(Agent* a, int radius);
        void tell(Id from, char* message);
        
        void reportRejection(Agent* agent, const char* why);
        void reportRejection(Id agentId, const char* why);
        
    private:
        RescueSystem(const RescueSystem& source);
        RescueSystem& operator= (const RescueSystem& rhs);
        bool operator== (const RescueSystem& rhs) const;
    };
    
    /////////////////////////////////////////////////////////////////////////
} // namespace Rescue

#ifdef NDEBUG
#  include "RescueSystem.inl"
#endif

#endif // } !defined(RESCUESYSTEM_HXX__INCLUDED)
