// System.inl
//
/////////////////////////////////////////////////////////////////////////////

#ifdef NDEBUG
//#  include
#endif

#ifndef NDEBUG
#  define inline
#else
#  define inline inline
#endif

namespace Rescue
{
	/////////////////////////////////////////////////////////////////////////
	// System
	
	inline System::System(const std::vector<TypeId>& agentTypes)
	{
		m_agentTypes = agentTypes;
		m_pFreeAgents = new Agents[agentTypes.size()];
		m_pConnectedAgents = new Agents[agentTypes.size()];

		m_logFile = 0;

		m_publicSocket = 0;
		m_agentSocket = 0;
		m_simulatorSocket = 0;
		m_gisSocket = 0;

		m_time = 0;
		m_systemTime = 0;

		m_gisConnected = false;
	}

	inline LongUDPSocket& System::publicSocket()
	{
		ASSERT(m_publicSocket);
		return *m_publicSocket;
	}
	inline LongUDPSocket& System::agentSocket()
	{
		ASSERT(m_agentSocket);
		return *m_agentSocket;
	}
	inline LongUDPSocket& System::simulatorSocket()
	{
		ASSERT(m_simulatorSocket);
		return *m_simulatorSocket;
	}
	inline LongUDPSocket& System::gisSocket()
	{
		ASSERT(m_gisSocket);
		return *m_gisSocket;
	}
	inline Config& System::config()
	{
		return m_config;
	}
	inline RescueObjectPool& System::objectPool()
	{
		return m_objectPool;
	}
	
	/*inline System::System(const System& source)
	{
		System();
		operator= (source);
	}
	inline System& System::operator= (const System& rhs)
	{
		if(this == &rhs)
			return *this;
		return *this;
	}
	inline bool System::operator== (const System& rhs) const
	{
		if(this == &rhs)
			return true;
	}*/
	
	/////////////////////////////////////////////////////////////////////////
} // namespace Rescue
#undef inline
