// This file was generated by odc from .\objdef

class Object
{
private:
	Id m_id;

public:
	Id id() const { return m_id; }
	void setId(Id value) { m_id = value; }


public:
	Object() {
	}
	virtual ~Object() { }

	virtual TypeId type() const = 0;

	void outputObject(Output& buffer, S32 time) const {
		// Output all properties changed after 'time' (inclusive). If time=0, output all properties.
		long cursor = buffer.size();
		buffer.put(type());
		buffer.put(id());
		if(outputProperties(buffer, time))
			buffer.put(PROPERTY_NULL);
		else
			buffer.resize(cursor);
	}
	void outputObject(Output& buffer) const {
		// Output all properties.
		buffer.put(type());
		buffer.put(id());
		outputProperties(buffer);
		buffer.put(PROPERTY_NULL);
	}
	virtual int outputProperties(Output& buffer, S32 time) const {
		int result = 0;
		return result;
	}

	virtual void outputProperties(Output& buffer) const {
	}

	virtual int output(Output& buffer, PropertyId property, S32 time) const {
		int result = 0;
		switch(property) {
		default:
			ASSERT(false);
			break;
		/*case PROPERTY_Type:
			buffer.put(type());
			break;*/
		}
		return result;
	}


	virtual void output(Output& buffer, PropertyId property) const {
		switch(property) {
		default:
			ASSERT(false);
			break;
		/*case PROPERTY_Type:
			buffer.put(type());
			break;*/
		}
	}


	void inputAllProperty(S32 time, ObjectPool& pool, Input& buffer) {
		PropertyId prop;
		while(prop = buffer.get(), prop != PROPERTY_NULL)
			input(time, pool, buffer, prop);
	}
	virtual void input(S32 time, ObjectPool& pool, Input& buffer, PropertyId property) {
		switch(property) {
		default:
			//ASSERT(false);
			if(0x80 <= property && property <= 0xBF) {
				Bytes value;
				buffer.getBytes(value);
			} else if(0xC0 <= property && property <= 0xFF) {
				Id id;
				while(id = buffer.get(), id != 0);
			} else {
				buffer.get();
			}
			break;
		}
	}


public:
	const Objects& contents() const
	{
		return m_contents;
	}
	void addContent(S32 time, Object* object)
	{
		m_contents.push_back(object);
		//m_timeContentsUpdated = time;
	}
	void removeContent(S32 time, Object* content)
	{
		m_contents.remove(content);
		//m_timeContentsUpdated = time;
	}
	void setOwner(class RescueObjectPool* owner)
	{
		m_owner = owner;
	}
protected:
	RescueObjectPool* m_owner;
private:
	Objects m_contents;
	

private:
	Object(const Object&);
	Object& operator=(const Object&);
	bool operator==(const Object&) const;
};

class VirtualObject
:
	public Object
{
private:

public:


public:
	VirtualObject() {
	}
	virtual ~VirtualObject() { }


	virtual int outputProperties(Output& buffer, S32 time) const {
		int result = 0;
		result += Object::outputProperties(buffer, time);
		return result;
	}

	virtual void outputProperties(Output& buffer) const {
		Object::outputProperties(buffer);
	}

	virtual int output(Output& buffer, PropertyId property, S32 time) const {
		int result = 0;
		switch(property) {
		default:
			result = Object::output(buffer, property, time);
			break;
		}
		return result;
	}


	virtual void output(Output& buffer, PropertyId property) const {
		switch(property) {
		default:
			Object::output(buffer, property);
			break;
		}
	}


	virtual void input(S32 time, ObjectPool& pool, Input& buffer, PropertyId property) {
		switch(property) {
		default:
			Object::input(time, pool, buffer, property);
			break;
		}
	}


public:

private:
	VirtualObject(const VirtualObject&);
	VirtualObject& operator=(const VirtualObject&);
	bool operator==(const VirtualObject&) const;
};

class RealObject
:
	public Object
{
private:

public:


public:
	RealObject() {
	}
	virtual ~RealObject() { }


	virtual int outputProperties(Output& buffer, S32 time) const {
		int result = 0;
		result += Object::outputProperties(buffer, time);
		return result;
	}

	virtual void outputProperties(Output& buffer) const {
		Object::outputProperties(buffer);
	}

	virtual int output(Output& buffer, PropertyId property, S32 time) const {
		int result = 0;
		switch(property) {
		default:
			result = Object::output(buffer, property, time);
			break;
		}
		return result;
	}


	virtual void output(Output& buffer, PropertyId property) const {
		switch(property) {
		default:
			Object::output(buffer, property);
			break;
		}
	}


	virtual void input(S32 time, ObjectPool& pool, Input& buffer, PropertyId property) {
		switch(property) {
		default:
			Object::input(time, pool, buffer, property);
			break;
		}
	}


public:
	virtual S32 x() const = 0;
	virtual S32 y() const = 0;
	

private:
	RealObject(const RealObject&);
	RealObject& operator=(const RealObject&);
	bool operator==(const RealObject&) const;
};

class World
:
	public VirtualObject
{
private:
	S32 m_startTime;
	S32 m_timeStartTimeUpdated;
	S32 m_longitude;
	S32 m_timeLongitudeUpdated;
	S32 m_latitude;
	S32 m_timeLatitudeUpdated;
	S32 m_windForce;
	S32 m_timeWindForceUpdated;
	S32 m_windDirection;
	S32 m_timeWindDirectionUpdated;

public:
	S32 startTime() const { return m_startTime; }
	void setStartTime(S32 time, S32 value) {
		m_startTime = value; m_timeStartTimeUpdated = time; }
	S32 getTimeStartTimeUpdated() { return m_timeStartTimeUpdated; }
	S32 longitude() const { return m_longitude; }
	void setLongitude(S32 time, S32 value) {
		m_longitude = value; m_timeLongitudeUpdated = time; }
	S32 getTimeLongitudeUpdated() { return m_timeLongitudeUpdated; }
	S32 latitude() const { return m_latitude; }
	void setLatitude(S32 time, S32 value) {
		m_latitude = value; m_timeLatitudeUpdated = time; }
	S32 getTimeLatitudeUpdated() { return m_timeLatitudeUpdated; }
	S32 windForce() const { return m_windForce; }
	void setWindForce(S32 time, S32 value) {
		m_windForce = value; m_timeWindForceUpdated = time; }
	S32 getTimeWindForceUpdated() { return m_timeWindForceUpdated; }
	S32 windDirection() const { return m_windDirection; }
	void setWindDirection(S32 time, S32 value) {
		m_windDirection = value; m_timeWindDirectionUpdated = time; }
	S32 getTimeWindDirectionUpdated() { return m_timeWindDirectionUpdated; }


public:
	World() {
		m_startTime = 0;
		m_timeStartTimeUpdated = 0;
		m_longitude = 0;
		m_timeLongitudeUpdated = 0;
		m_latitude = 0;
		m_timeLatitudeUpdated = 0;
		m_windForce = 0;
		m_timeWindForceUpdated = 0;
		m_windDirection = 0;
		m_timeWindDirectionUpdated = 0;
	}
	virtual ~World() { }

	virtual TypeId type() const {
		return TYPE_WORLD;
	}

	virtual int outputProperties(Output& buffer, S32 time) const {
		int result = 0;
		result += VirtualObject::outputProperties(buffer, time);
		result += output(buffer, PROPERTY_START_TIME, time);
		result += output(buffer, PROPERTY_LONGITUDE, time);
		result += output(buffer, PROPERTY_LATITUDE, time);
		result += output(buffer, PROPERTY_WIND_FORCE, time);
		result += output(buffer, PROPERTY_WIND_DIRECTION, time);
		return result;
	}

	virtual void outputProperties(Output& buffer) const {
		VirtualObject::outputProperties(buffer);
		output(buffer, PROPERTY_START_TIME);
		output(buffer, PROPERTY_LONGITUDE);
		output(buffer, PROPERTY_LATITUDE);
		output(buffer, PROPERTY_WIND_FORCE);
		output(buffer, PROPERTY_WIND_DIRECTION);
	}

	virtual int output(Output& buffer, PropertyId property, S32 time) const {
		int result = 0;
		switch(property) {
		default:
			result = VirtualObject::output(buffer, property, time);
			break;
		case PROPERTY_START_TIME:
			if(m_timeStartTimeUpdated >= time) {
				buffer.put(property);
				buffer.put(startTime());
				result = 1;
			}
			break;
		case PROPERTY_LONGITUDE:
			if(m_timeLongitudeUpdated >= time) {
				buffer.put(property);
				buffer.put(longitude());
				result = 1;
			}
			break;
		case PROPERTY_LATITUDE:
			if(m_timeLatitudeUpdated >= time) {
				buffer.put(property);
				buffer.put(latitude());
				result = 1;
			}
			break;
		case PROPERTY_WIND_FORCE:
			if(m_timeWindForceUpdated >= time) {
				buffer.put(property);
				buffer.put(windForce());
				result = 1;
			}
			break;
		case PROPERTY_WIND_DIRECTION:
			if(m_timeWindDirectionUpdated >= time) {
				buffer.put(property);
				buffer.put(windDirection());
				result = 1;
			}
			break;
		}
		return result;
	}


	virtual void output(Output& buffer, PropertyId property) const {
		switch(property) {
		default:
			VirtualObject::output(buffer, property);
			break;
		case PROPERTY_START_TIME:
			{
				buffer.put(property);
				buffer.put(startTime());
			}
			break;
		case PROPERTY_LONGITUDE:
			{
				buffer.put(property);
				buffer.put(longitude());
			}
			break;
		case PROPERTY_LATITUDE:
			{
				buffer.put(property);
				buffer.put(latitude());
			}
			break;
		case PROPERTY_WIND_FORCE:
			{
				buffer.put(property);
				buffer.put(windForce());
			}
			break;
		case PROPERTY_WIND_DIRECTION:
			{
				buffer.put(property);
				buffer.put(windDirection());
			}
			break;
		}
	}


	virtual void input(S32 time, ObjectPool& pool, Input& buffer, PropertyId property) {
		switch(property) {
		default:
			VirtualObject::input(time, pool, buffer, property);
			break;
		case PROPERTY_START_TIME:
		{
			S32 value = buffer.get();
			setStartTime(time, value);
		}
			break;
		case PROPERTY_LONGITUDE:
		{
			S32 value = buffer.get();
			setLongitude(time, value);
		}
			break;
		case PROPERTY_LATITUDE:
		{
			S32 value = buffer.get();
			setLatitude(time, value);
		}
			break;
		case PROPERTY_WIND_FORCE:
		{
			S32 value = buffer.get();
			setWindForce(time, value);
		}
			break;
		case PROPERTY_WIND_DIRECTION:
		{
			S32 value = buffer.get();
			setWindDirection(time, value);
		}
			break;
		}
	}


public:
	virtual S32 x() const { return 0; }
	virtual S32 y() const { return 0; }
	

private:
	World(const World&);
	World& operator=(const World&);
	bool operator==(const World&) const;
};

class MotionlessObject
:
	public RealObject
{
private:

public:


public:
	MotionlessObject() {
	}
	virtual ~MotionlessObject() { }


	virtual int outputProperties(Output& buffer, S32 time) const {
		int result = 0;
		result += RealObject::outputProperties(buffer, time);
		return result;
	}

	virtual void outputProperties(Output& buffer) const {
		RealObject::outputProperties(buffer);
	}

	virtual int output(Output& buffer, PropertyId property, S32 time) const {
		int result = 0;
		switch(property) {
		default:
			result = RealObject::output(buffer, property, time);
			break;
		}
		return result;
	}


	virtual void output(Output& buffer, PropertyId property) const {
		switch(property) {
		default:
			RealObject::output(buffer, property);
			break;
		}
	}


	virtual void input(S32 time, ObjectPool& pool, Input& buffer, PropertyId property) {
		switch(property) {
		default:
			RealObject::input(time, pool, buffer, property);
			break;
		}
	}


public:

private:
	MotionlessObject(const MotionlessObject&);
	MotionlessObject& operator=(const MotionlessObject&);
	bool operator==(const MotionlessObject&) const;
};

class PointObject
:
	public MotionlessObject
{
private:
	S32 m_x;
	S32 m_timeXUpdated;
	S32 m_y;
	S32 m_timeYUpdated;

public:
	S32 x() const { return m_x; }
	void setX(S32 time, S32 value) {
		m_x = value; m_timeXUpdated = time; }
	S32 getTimeXUpdated() { return m_timeXUpdated; }
	S32 y() const { return m_y; }
	void setY(S32 time, S32 value) {
		m_y = value; m_timeYUpdated = time; }
	S32 getTimeYUpdated() { return m_timeYUpdated; }


public:
	PointObject() {
		m_x = 0;
		m_timeXUpdated = 0;
		m_y = 0;
		m_timeYUpdated = 0;
	}
	virtual ~PointObject() { }


	virtual int outputProperties(Output& buffer, S32 time) const {
		int result = 0;
		result += MotionlessObject::outputProperties(buffer, time);
		result += output(buffer, PROPERTY_X, time);
		result += output(buffer, PROPERTY_Y, time);
		return result;
	}

	virtual void outputProperties(Output& buffer) const {
		MotionlessObject::outputProperties(buffer);
		output(buffer, PROPERTY_X);
		output(buffer, PROPERTY_Y);
	}

	virtual int output(Output& buffer, PropertyId property, S32 time) const {
		int result = 0;
		switch(property) {
		default:
			result = MotionlessObject::output(buffer, property, time);
			break;
		case PROPERTY_X:
			if(m_timeXUpdated >= time) {
				buffer.put(property);
				buffer.put(x());
				result = 1;
			}
			break;
		case PROPERTY_Y:
			if(m_timeYUpdated >= time) {
				buffer.put(property);
				buffer.put(y());
				result = 1;
			}
			break;
		}
		return result;
	}


	virtual void output(Output& buffer, PropertyId property) const {
		switch(property) {
		default:
			MotionlessObject::output(buffer, property);
			break;
		case PROPERTY_X:
			{
				buffer.put(property);
				buffer.put(x());
			}
			break;
		case PROPERTY_Y:
			{
				buffer.put(property);
				buffer.put(y());
			}
			break;
		}
	}


	virtual void input(S32 time, ObjectPool& pool, Input& buffer, PropertyId property) {
		switch(property) {
		default:
			MotionlessObject::input(time, pool, buffer, property);
			break;
		case PROPERTY_X:
		{
			S32 value = buffer.get();
			setX(time, value);
		}
			break;
		case PROPERTY_Y:
		{
			S32 value = buffer.get();
			setY(time, value);
		}
			break;
		}
	}


public:

private:
	PointObject(const PointObject&);
	PointObject& operator=(const PointObject&);
	bool operator==(const PointObject&) const;
};

class MovingObject
:
	public RealObject
{
private:
	Object* m_position;
	S32 m_timePositionUpdated;
	S32 m_positionExtra;
	S32 m_timePositionExtraUpdated;
	S32 m_direction;
	S32 m_timeDirectionUpdated;
	Objects m_positionHistory;
	S32 m_timePositionHistoryUpdated;

public:
	Object* position() const { return m_position; }
	S32 getTimePositionUpdated() { return m_timePositionUpdated; }
	S32 positionExtra() const { return m_positionExtra; }
	void setPositionExtra(S32 time, S32 value) {
		m_positionExtra = value; m_timePositionExtraUpdated = time; }
	S32 getTimePositionExtraUpdated() { return m_timePositionExtraUpdated; }
	S32 direction() const { return m_direction; }
	void setDirection(S32 time, S32 value) {
		m_direction = value; m_timeDirectionUpdated = time; }
	S32 getTimeDirectionUpdated() { return m_timeDirectionUpdated; }
	const Objects& positionHistory() const { return m_positionHistory; }
	void setPositionHistory(S32 time, const Objects& value) {
		m_positionHistory = value; m_timePositionHistoryUpdated = time; }
	S32 getTimePositionHistoryUpdated() { return m_timePositionHistoryUpdated; }


public:
	MovingObject() {
		m_position = 0;
		m_timePositionUpdated = 0;
		m_positionExtra = 0;
		m_timePositionExtraUpdated = 0;
		m_direction = 0;
		m_timeDirectionUpdated = 0;
	}
	virtual ~MovingObject() { }


	virtual int outputProperties(Output& buffer, S32 time) const {
		int result = 0;
		result += RealObject::outputProperties(buffer, time);
		result += output(buffer, PROPERTY_POSITION, time);
		result += output(buffer, PROPERTY_POSITION_EXTRA, time);
		result += output(buffer, PROPERTY_DIRECTION, time);
		result += output(buffer, PROPERTY_POSITION_HISTORY, time);
		return result;
	}

	virtual void outputProperties(Output& buffer) const {
		RealObject::outputProperties(buffer);
		output(buffer, PROPERTY_POSITION);
		output(buffer, PROPERTY_POSITION_EXTRA);
		output(buffer, PROPERTY_DIRECTION);
		output(buffer, PROPERTY_POSITION_HISTORY);
	}

	virtual int output(Output& buffer, PropertyId property, S32 time) const {
		int result = 0;
		switch(property) {
		default:
			result = RealObject::output(buffer, property, time);
			break;
		case PROPERTY_POSITION:
			if(m_timePositionUpdated >= time) {
				buffer.put(property);
				if(position() == 0)
					buffer.put((Id)0);
				else
					buffer.put(position()->id());
				result = 1;
			}
			break;
		case PROPERTY_POSITION_EXTRA:
			if(m_timePositionExtraUpdated >= time) {
				buffer.put(property);
				buffer.put(positionExtra());
				result = 1;
			}
			break;
		case PROPERTY_DIRECTION:
			if(m_timeDirectionUpdated >= time) {
				buffer.put(property);
				buffer.put(direction());
				result = 1;
			}
			break;
		case PROPERTY_POSITION_HISTORY:
			if(m_timePositionHistoryUpdated >= time) {
				buffer.put(property);
				Objects::const_iterator it = positionHistory().begin();
				for(; it != positionHistory().end(); it++)
					buffer.put((*it)->id());
				buffer.put((Id)0);
				result = 1;
			}
			break;
		}
		return result;
	}


	virtual void output(Output& buffer, PropertyId property) const {
		switch(property) {
		default:
			RealObject::output(buffer, property);
			break;
		case PROPERTY_POSITION:
			{
				buffer.put(property);
				if(position() == 0)
					buffer.put((Id)0);
				else
					buffer.put(position()->id());
			}
			break;
		case PROPERTY_POSITION_EXTRA:
			{
				buffer.put(property);
				buffer.put(positionExtra());
			}
			break;
		case PROPERTY_DIRECTION:
			{
				buffer.put(property);
				buffer.put(direction());
			}
			break;
		case PROPERTY_POSITION_HISTORY:
			{
				buffer.put(property);
				Objects::const_iterator it = positionHistory().begin();
				for(; it != positionHistory().end(); it++)
					buffer.put((*it)->id());
				buffer.put((Id)0);
			}
			break;
		}
	}


	virtual void input(S32 time, ObjectPool& pool, Input& buffer, PropertyId property) {
		switch(property) {
		default:
			RealObject::input(time, pool, buffer, property);
			break;
		case PROPERTY_POSITION:
		{
			Id id = buffer.get();
			setPosition(time, pool.get(id));
		}
			break;
		case PROPERTY_POSITION_EXTRA:
		{
			S32 value = buffer.get();
			setPositionExtra(time, value);
		}
			break;
		case PROPERTY_DIRECTION:
		{
			S32 value = buffer.get();
			setDirection(time, value);
		}
			break;
		case PROPERTY_POSITION_HISTORY:
		{
			Id id;
			m_positionHistory.clear();
			while(id = buffer.get(), id != 0) {
				Object* o = pool.get(id);
				m_positionHistory.push_back(o);
			}
			m_timePositionHistoryUpdated = time;
		}
			break;
		}
	}


public:
	void setPosition(S32 time, Object* value)
	{
		if(m_position != 0)
			m_position->removeContent(time, this);
		if(value != 0)
			value->addContent(time, this);
		m_position = value;
		m_timePositionUpdated = time;
	}
	virtual S32 x() const;
	virtual S32 y() const;
	

private:
	MovingObject(const MovingObject&);
	MovingObject& operator=(const MovingObject&);
	bool operator==(const MovingObject&) const;
};

class Humanoid
:
	public MovingObject
{
private:
	S32 m_stamina;
	S32 m_timeStaminaUpdated;
	S32 m_hp;
	S32 m_timeHpUpdated;
	S32 m_damage;
	S32 m_timeDamageUpdated;
	S32 m_buriedness;
	S32 m_timeBuriednessUpdated;

public:
	S32 stamina() const { return m_stamina; }
	void setStamina(S32 time, S32 value) {
		m_stamina = value; m_timeStaminaUpdated = time; }
	S32 getTimeStaminaUpdated() { return m_timeStaminaUpdated; }
	S32 hp() const { return m_hp; }
	void setHp(S32 time, S32 value) {
		m_hp = value; m_timeHpUpdated = time; }
	S32 getTimeHpUpdated() { return m_timeHpUpdated; }
	S32 damage() const { return m_damage; }
	void setDamage(S32 time, S32 value) {
		m_damage = value; m_timeDamageUpdated = time; }
	S32 getTimeDamageUpdated() { return m_timeDamageUpdated; }
	S32 buriedness() const { return m_buriedness; }
	void setBuriedness(S32 time, S32 value) {
		m_buriedness = value; m_timeBuriednessUpdated = time; }
	S32 getTimeBuriednessUpdated() { return m_timeBuriednessUpdated; }


public:
	Humanoid() {
		m_stamina = 10000;
		m_timeStaminaUpdated = 0;
		m_hp = 10000;
		m_timeHpUpdated = 0;
		m_damage = 0;
		m_timeDamageUpdated = 0;
		m_buriedness = 0;
		m_timeBuriednessUpdated = 0;
	}
	virtual ~Humanoid() { }


	virtual int outputProperties(Output& buffer, S32 time) const {
		int result = 0;
		result += MovingObject::outputProperties(buffer, time);
		result += output(buffer, PROPERTY_STAMINA, time);
		result += output(buffer, PROPERTY_HP, time);
		result += output(buffer, PROPERTY_DAMAGE, time);
		result += output(buffer, PROPERTY_BURIEDNESS, time);
		return result;
	}

	virtual void outputProperties(Output& buffer) const {
		MovingObject::outputProperties(buffer);
		output(buffer, PROPERTY_STAMINA);
		output(buffer, PROPERTY_HP);
		output(buffer, PROPERTY_DAMAGE);
		output(buffer, PROPERTY_BURIEDNESS);
	}

	virtual int output(Output& buffer, PropertyId property, S32 time) const {
		int result = 0;
		switch(property) {
		default:
			result = MovingObject::output(buffer, property, time);
			break;
		case PROPERTY_STAMINA:
			if(m_timeStaminaUpdated >= time) {
				buffer.put(property);
				buffer.put(stamina());
				result = 1;
			}
			break;
		case PROPERTY_HP:
			if(m_timeHpUpdated >= time) {
				buffer.put(property);
				buffer.put(hp());
				result = 1;
			}
			break;
		case PROPERTY_DAMAGE:
			if(m_timeDamageUpdated >= time) {
				buffer.put(property);
				buffer.put(damage());
				result = 1;
			}
			break;
		case PROPERTY_BURIEDNESS:
			if(m_timeBuriednessUpdated >= time) {
				buffer.put(property);
				buffer.put(buriedness());
				result = 1;
			}
			break;
		}
		return result;
	}


	virtual void output(Output& buffer, PropertyId property) const {
		switch(property) {
		default:
			MovingObject::output(buffer, property);
			break;
		case PROPERTY_STAMINA:
			{
				buffer.put(property);
				buffer.put(stamina());
			}
			break;
		case PROPERTY_HP:
			{
				buffer.put(property);
				buffer.put(hp());
			}
			break;
		case PROPERTY_DAMAGE:
			{
				buffer.put(property);
				buffer.put(damage());
			}
			break;
		case PROPERTY_BURIEDNESS:
			{
				buffer.put(property);
				buffer.put(buriedness());
			}
			break;
		}
	}


	virtual void input(S32 time, ObjectPool& pool, Input& buffer, PropertyId property) {
		switch(property) {
		default:
			MovingObject::input(time, pool, buffer, property);
			break;
		case PROPERTY_STAMINA:
		{
			S32 value = buffer.get();
			setStamina(time, value);
		}
			break;
		case PROPERTY_HP:
		{
			S32 value = buffer.get();
			setHp(time, value);
		}
			break;
		case PROPERTY_DAMAGE:
		{
			S32 value = buffer.get();
			setDamage(time, value);
		}
			break;
		case PROPERTY_BURIEDNESS:
		{
			S32 value = buffer.get();
			setBuriedness(time, value);
		}
			break;
		}
	}


public:

private:
	Humanoid(const Humanoid&);
	Humanoid& operator=(const Humanoid&);
	bool operator==(const Humanoid&) const;
};

class Building
:
	public PointObject
{
private:
	S32 m_floors;
	S32 m_timeFloorsUpdated;
	S32 m_buildingAttributes;
	S32 m_timeBuildingAttributesUpdated;
	S32 m_ignition;
	S32 m_timeIgnitionUpdated;
	S32 m_fieryness;
	S32 m_timeFierynessUpdated;
	S32 m_brokenness;
	S32 m_timeBrokennessUpdated;
	Objects m_entrances;
	S32 m_timeEntrancesUpdated;
	S32 m_buildingCode;
	S32 m_timeBuildingCodeUpdated;
	S32 m_buildingAreaGround;
	S32 m_timeBuildingAreaGroundUpdated;
	S32 m_buildingAreaTotal;
	S32 m_timeBuildingAreaTotalUpdated;
	Bytes m_buildingApexes;
	S32 m_timeBuildingApexesUpdated;

public:
	S32 floors() const { return m_floors; }
	void setFloors(S32 time, S32 value) {
		m_floors = value; m_timeFloorsUpdated = time; }
	S32 getTimeFloorsUpdated() { return m_timeFloorsUpdated; }
	S32 buildingAttributes() const { return m_buildingAttributes; }
	void setBuildingAttributes(S32 time, S32 value) {
		m_buildingAttributes = value; m_timeBuildingAttributesUpdated = time; }
	S32 getTimeBuildingAttributesUpdated() { return m_timeBuildingAttributesUpdated; }
	S32 ignition() const { return m_ignition; }
	void setIgnition(S32 time, S32 value) {
		m_ignition = value; m_timeIgnitionUpdated = time; }
	S32 getTimeIgnitionUpdated() { return m_timeIgnitionUpdated; }
	S32 fieryness() const { return m_fieryness; }
	S32 getTimeFierynessUpdated() { return m_timeFierynessUpdated; }
	S32 brokenness() const { return m_brokenness; }
	void setBrokenness(S32 time, S32 value) {
		m_brokenness = value; m_timeBrokennessUpdated = time; }
	S32 getTimeBrokennessUpdated() { return m_timeBrokennessUpdated; }
	const Objects& entrances() const { return m_entrances; }
	void setEntrances(S32 time, const Objects& value) {
		m_entrances = value; m_timeEntrancesUpdated = time; }
	S32 getTimeEntrancesUpdated() { return m_timeEntrancesUpdated; }
	S32 buildingCode() const { return m_buildingCode; }
	void setBuildingCode(S32 time, S32 value) {
		m_buildingCode = value; m_timeBuildingCodeUpdated = time; }
	S32 getTimeBuildingCodeUpdated() { return m_timeBuildingCodeUpdated; }
	S32 buildingAreaGround() const { return m_buildingAreaGround; }
	void setBuildingAreaGround(S32 time, S32 value) {
		m_buildingAreaGround = value; m_timeBuildingAreaGroundUpdated = time; }
	S32 getTimeBuildingAreaGroundUpdated() { return m_timeBuildingAreaGroundUpdated; }
	S32 buildingAreaTotal() const { return m_buildingAreaTotal; }
	void setBuildingAreaTotal(S32 time, S32 value) {
		m_buildingAreaTotal = value; m_timeBuildingAreaTotalUpdated = time; }
	S32 getTimeBuildingAreaTotalUpdated() { return m_timeBuildingAreaTotalUpdated; }
	const Bytes& buildingApexes() const { return m_buildingApexes; }
	void setBuildingApexes(S32 time, const Bytes& value) {
		m_buildingApexes = value; m_timeBuildingApexesUpdated = time; }
	S32 getTimeBuildingApexesUpdated() { return m_timeBuildingApexesUpdated; }


public:
	Building() {
		m_floors = 1;
		m_timeFloorsUpdated = 0;
		m_buildingAttributes = 0;
		m_timeBuildingAttributesUpdated = 0;
		m_ignition = 0;
		m_timeIgnitionUpdated = 0;
		m_fieryness = 0;
		m_timeFierynessUpdated = 0;
		m_brokenness = 0;
		m_timeBrokennessUpdated = 0;
		m_buildingCode = 0;
		m_timeBuildingCodeUpdated = 0;
		m_buildingAreaGround = 0;
		m_timeBuildingAreaGroundUpdated = 0;
		m_buildingAreaTotal = 0;
		m_timeBuildingAreaTotalUpdated = 0;
	}
	virtual ~Building() { }

	virtual TypeId type() const {
		return TYPE_BUILDING;
	}

	virtual int outputProperties(Output& buffer, S32 time) const {
		int result = 0;
		result += PointObject::outputProperties(buffer, time);
		result += output(buffer, PROPERTY_FLOORS, time);
		result += output(buffer, PROPERTY_BUILDING_ATTRIBUTES, time);
		result += output(buffer, PROPERTY_IGNITION, time);
		result += output(buffer, PROPERTY_FIERYNESS, time);
		result += output(buffer, PROPERTY_BROKENNESS, time);
		result += output(buffer, PROPERTY_ENTRANCES, time);
		result += output(buffer, PROPERTY_BUILDING_CODE, time);
		result += output(buffer, PROPERTY_BUILDING_AREA_GROUND, time);
		result += output(buffer, PROPERTY_BUILDING_AREA_TOTAL, time);
		result += output(buffer, PROPERTY_BUILDING_APEXES, time);
		return result;
	}

	virtual void outputProperties(Output& buffer) const {
		PointObject::outputProperties(buffer);
		output(buffer, PROPERTY_FLOORS);
		output(buffer, PROPERTY_BUILDING_ATTRIBUTES);
		output(buffer, PROPERTY_IGNITION);
		output(buffer, PROPERTY_FIERYNESS);
		output(buffer, PROPERTY_BROKENNESS);
		output(buffer, PROPERTY_ENTRANCES);
		output(buffer, PROPERTY_BUILDING_CODE);
		output(buffer, PROPERTY_BUILDING_AREA_GROUND);
		output(buffer, PROPERTY_BUILDING_AREA_TOTAL);
		output(buffer, PROPERTY_BUILDING_APEXES);
	}

	virtual int output(Output& buffer, PropertyId property, S32 time) const {
		int result = 0;
		switch(property) {
		default:
			result = PointObject::output(buffer, property, time);
			break;
		case PROPERTY_FLOORS:
			if(m_timeFloorsUpdated >= time) {
				buffer.put(property);
				buffer.put(floors());
				result = 1;
			}
			break;
		case PROPERTY_BUILDING_ATTRIBUTES:
			if(m_timeBuildingAttributesUpdated >= time) {
				buffer.put(property);
				buffer.put(buildingAttributes());
				result = 1;
			}
			break;
		case PROPERTY_IGNITION:
			if(m_timeIgnitionUpdated >= time) {
				buffer.put(property);
				buffer.put(ignition());
				result = 1;
			}
			break;
		case PROPERTY_FIERYNESS:
			if(m_timeFierynessUpdated >= time) {
				buffer.put(property);
				buffer.put(fieryness());
				result = 1;
			}
			break;
		case PROPERTY_BROKENNESS:
			if(m_timeBrokennessUpdated >= time) {
				buffer.put(property);
				buffer.put(brokenness());
				result = 1;
			}
			break;
		case PROPERTY_ENTRANCES:
			if(m_timeEntrancesUpdated >= time) {
				buffer.put(property);
				Objects::const_iterator it = entrances().begin();
				for(; it != entrances().end(); it++)
					buffer.put((*it)->id());
				buffer.put((Id)0);
				result = 1;
			}
			break;
		case PROPERTY_BUILDING_CODE:
			if(m_timeBuildingCodeUpdated >= time) {
				buffer.put(property);
				buffer.put(buildingCode());
				result = 1;
			}
			break;
		case PROPERTY_BUILDING_AREA_GROUND:
			if(m_timeBuildingAreaGroundUpdated >= time) {
				buffer.put(property);
				buffer.put(buildingAreaGround());
				result = 1;
			}
			break;
		case PROPERTY_BUILDING_AREA_TOTAL:
			if(m_timeBuildingAreaTotalUpdated >= time) {
				buffer.put(property);
				buffer.put(buildingAreaTotal());
				result = 1;
			}
			break;
		case PROPERTY_BUILDING_APEXES:
			if(m_timeBuildingApexesUpdated >= time) {
				buffer.put(property);
				buffer.put(buildingApexes());
				result = 1;
			}
			break;
		}
		return result;
	}


	virtual void output(Output& buffer, PropertyId property) const {
		switch(property) {
		default:
			PointObject::output(buffer, property);
			break;
		case PROPERTY_FLOORS:
			{
				buffer.put(property);
				buffer.put(floors());
			}
			break;
		case PROPERTY_BUILDING_ATTRIBUTES:
			{
				buffer.put(property);
				buffer.put(buildingAttributes());
			}
			break;
		case PROPERTY_IGNITION:
			{
				buffer.put(property);
				buffer.put(ignition());
			}
			break;
		case PROPERTY_FIERYNESS:
			{
				buffer.put(property);
				buffer.put(fieryness());
			}
			break;
		case PROPERTY_BROKENNESS:
			{
				buffer.put(property);
				buffer.put(brokenness());
			}
			break;
		case PROPERTY_ENTRANCES:
			{
				buffer.put(property);
				Objects::const_iterator it = entrances().begin();
				for(; it != entrances().end(); it++)
					buffer.put((*it)->id());
				buffer.put((Id)0);
			}
			break;
		case PROPERTY_BUILDING_CODE:
			{
				buffer.put(property);
				buffer.put(buildingCode());
			}
			break;
		case PROPERTY_BUILDING_AREA_GROUND:
			{
				buffer.put(property);
				buffer.put(buildingAreaGround());
			}
			break;
		case PROPERTY_BUILDING_AREA_TOTAL:
			{
				buffer.put(property);
				buffer.put(buildingAreaTotal());
			}
			break;
		case PROPERTY_BUILDING_APEXES:
			{
				buffer.put(property);
				buffer.put(buildingApexes());
			}
			break;
		}
	}


	virtual void input(S32 time, ObjectPool& pool, Input& buffer, PropertyId property) {
		switch(property) {
		default:
			PointObject::input(time, pool, buffer, property);
			break;
		case PROPERTY_FLOORS:
		{
			S32 value = buffer.get();
			setFloors(time, value);
		}
			break;
		case PROPERTY_BUILDING_ATTRIBUTES:
		{
			S32 value = buffer.get();
			setBuildingAttributes(time, value);
		}
			break;
		case PROPERTY_IGNITION:
		{
			S32 value = buffer.get();
			setIgnition(time, value);
		}
			break;
		case PROPERTY_FIERYNESS:
		{
			S32 value = buffer.get();
			setFieryness(time, value);
		}
			break;
		case PROPERTY_BROKENNESS:
		{
			S32 value = buffer.get();
			setBrokenness(time, value);
		}
			break;
		case PROPERTY_ENTRANCES:
		{
			Id id;
			m_entrances.clear();
			while(id = buffer.get(), id != 0) {
				Object* o = pool.get(id);
				m_entrances.push_back(o);
			}
			m_timeEntrancesUpdated = time;
		}
			break;
		case PROPERTY_BUILDING_CODE:
		{
			S32 value = buffer.get();
			setBuildingCode(time, value);
		}
			break;
		case PROPERTY_BUILDING_AREA_GROUND:
		{
			S32 value = buffer.get();
			setBuildingAreaGround(time, value);
		}
			break;
		case PROPERTY_BUILDING_AREA_TOTAL:
		{
			S32 value = buffer.get();
			setBuildingAreaTotal(time, value);
		}
			break;
		case PROPERTY_BUILDING_APEXES:
		{
			Bytes value;
			buffer.getBytes(value);
			setBuildingApexes(time, value);
		}
			break;
		}
	}


public:
	void setFieryness(S32 time, S32 value);
	

private:
	Building(const Building&);
	Building& operator=(const Building&);
	bool operator==(const Building&) const;
};

class Civilian
:
	public Humanoid,
	public Agent
{
private:

public:


public:
	Civilian() {
	}
	virtual ~Civilian() { }

	virtual TypeId type() const {
		return TYPE_CIVILIAN;
	}

	virtual int outputProperties(Output& buffer, S32 time) const {
		int result = 0;
		result += Humanoid::outputProperties(buffer, time);
		return result;
	}

	virtual void outputProperties(Output& buffer) const {
		Humanoid::outputProperties(buffer);
	}

	virtual int output(Output& buffer, PropertyId property, S32 time) const {
		int result = 0;
		switch(property) {
		default:
			result = Humanoid::output(buffer, property, time);
			break;
		}
		return result;
	}


	virtual void output(Output& buffer, PropertyId property) const {
		switch(property) {
		default:
			Humanoid::output(buffer, property);
			break;
		}
	}


	virtual void input(S32 time, ObjectPool& pool, Input& buffer, PropertyId property) {
		switch(property) {
		default:
			Humanoid::input(time, pool, buffer, property);
			break;
		}
	}


public:

private:
	Civilian(const Civilian&);
	Civilian& operator=(const Civilian&);
	bool operator==(const Civilian&) const;
};

class Car
:
	public Humanoid
{
private:

public:


public:
	Car() {
	}
	virtual ~Car() { }

	virtual TypeId type() const {
		return TYPE_CAR;
	}

	virtual int outputProperties(Output& buffer, S32 time) const {
		int result = 0;
		result += Humanoid::outputProperties(buffer, time);
		return result;
	}

	virtual void outputProperties(Output& buffer) const {
		Humanoid::outputProperties(buffer);
	}

	virtual int output(Output& buffer, PropertyId property, S32 time) const {
		int result = 0;
		switch(property) {
		default:
			result = Humanoid::output(buffer, property, time);
			break;
		}
		return result;
	}


	virtual void output(Output& buffer, PropertyId property) const {
		switch(property) {
		default:
			Humanoid::output(buffer, property);
			break;
		}
	}


	virtual void input(S32 time, ObjectPool& pool, Input& buffer, PropertyId property) {
		switch(property) {
		default:
			Humanoid::input(time, pool, buffer, property);
			break;
		}
	}


public:

private:
	Car(const Car&);
	Car& operator=(const Car&);
	bool operator==(const Car&) const;
};

class FireBrigade
:
	public Humanoid,
	public Agent
{
private:
	S32 m_waterQuantity;
	S32 m_timeWaterQuantityUpdated;
	S32 m_stretchedLength;
	S32 m_timeStretchedLengthUpdated;

public:
	S32 waterQuantity() const { return m_waterQuantity; }
	void setWaterQuantity(S32 time, S32 value) {
		m_waterQuantity = value; m_timeWaterQuantityUpdated = time; }
	S32 getTimeWaterQuantityUpdated() { return m_timeWaterQuantityUpdated; }
	S32 stretchedLength() const { return m_stretchedLength; }
	void setStretchedLength(S32 time, S32 value) {
		m_stretchedLength = value; m_timeStretchedLengthUpdated = time; }
	S32 getTimeStretchedLengthUpdated() { return m_timeStretchedLengthUpdated; }


public:
	FireBrigade() {
		m_waterQuantity = 0;
		m_timeWaterQuantityUpdated = 0;
		m_stretchedLength = 0;
		m_timeStretchedLengthUpdated = 0;
	}
	virtual ~FireBrigade() { }

	virtual TypeId type() const {
		return TYPE_FIRE_BRIGADE;
	}

	virtual int outputProperties(Output& buffer, S32 time) const {
		int result = 0;
		result += Humanoid::outputProperties(buffer, time);
		result += output(buffer, PROPERTY_WATER_QUANTITY, time);
		result += output(buffer, PROPERTY_STRETCHED_LENGTH, time);
		return result;
	}

	virtual void outputProperties(Output& buffer) const {
		Humanoid::outputProperties(buffer);
		output(buffer, PROPERTY_WATER_QUANTITY);
		output(buffer, PROPERTY_STRETCHED_LENGTH);
	}

	virtual int output(Output& buffer, PropertyId property, S32 time) const {
		int result = 0;
		switch(property) {
		default:
			result = Humanoid::output(buffer, property, time);
			break;
		case PROPERTY_WATER_QUANTITY:
			if(m_timeWaterQuantityUpdated >= time) {
				buffer.put(property);
				buffer.put(waterQuantity());
				result = 1;
			}
			break;
		case PROPERTY_STRETCHED_LENGTH:
			if(m_timeStretchedLengthUpdated >= time) {
				buffer.put(property);
				buffer.put(stretchedLength());
				result = 1;
			}
			break;
		}
		return result;
	}


	virtual void output(Output& buffer, PropertyId property) const {
		switch(property) {
		default:
			Humanoid::output(buffer, property);
			break;
		case PROPERTY_WATER_QUANTITY:
			{
				buffer.put(property);
				buffer.put(waterQuantity());
			}
			break;
		case PROPERTY_STRETCHED_LENGTH:
			{
				buffer.put(property);
				buffer.put(stretchedLength());
			}
			break;
		}
	}


	virtual void input(S32 time, ObjectPool& pool, Input& buffer, PropertyId property) {
		switch(property) {
		default:
			Humanoid::input(time, pool, buffer, property);
			break;
		case PROPERTY_WATER_QUANTITY:
		{
			S32 value = buffer.get();
			setWaterQuantity(time, value);
		}
			break;
		case PROPERTY_STRETCHED_LENGTH:
		{
			S32 value = buffer.get();
			setStretchedLength(time, value);
		}
			break;
		}
	}


public:

private:
	FireBrigade(const FireBrigade&);
	FireBrigade& operator=(const FireBrigade&);
	bool operator==(const FireBrigade&) const;
};

class FireStation
:
	public Building,
	public Agent
{
private:

public:


public:
	FireStation() {
	}
	virtual ~FireStation() { }

	virtual TypeId type() const {
		return TYPE_FIRE_STATION;
	}

	virtual int outputProperties(Output& buffer, S32 time) const {
		int result = 0;
		result += Building::outputProperties(buffer, time);
		return result;
	}

	virtual void outputProperties(Output& buffer) const {
		Building::outputProperties(buffer);
	}

	virtual int output(Output& buffer, PropertyId property, S32 time) const {
		int result = 0;
		switch(property) {
		default:
			result = Building::output(buffer, property, time);
			break;
		}
		return result;
	}


	virtual void output(Output& buffer, PropertyId property) const {
		switch(property) {
		default:
			Building::output(buffer, property);
			break;
		}
	}


	virtual void input(S32 time, ObjectPool& pool, Input& buffer, PropertyId property) {
		switch(property) {
		default:
			Building::input(time, pool, buffer, property);
			break;
		}
	}


public:

private:
	FireStation(const FireStation&);
	FireStation& operator=(const FireStation&);
	bool operator==(const FireStation&) const;
};

class AmbulanceTeam
:
	public Humanoid,
	public Agent
{
private:

public:


public:
	AmbulanceTeam() {
	}
	virtual ~AmbulanceTeam() { }

	virtual TypeId type() const {
		return TYPE_AMBULANCE_TEAM;
	}

	virtual int outputProperties(Output& buffer, S32 time) const {
		int result = 0;
		result += Humanoid::outputProperties(buffer, time);
		return result;
	}

	virtual void outputProperties(Output& buffer) const {
		Humanoid::outputProperties(buffer);
	}

	virtual int output(Output& buffer, PropertyId property, S32 time) const {
		int result = 0;
		switch(property) {
		default:
			result = Humanoid::output(buffer, property, time);
			break;
		}
		return result;
	}


	virtual void output(Output& buffer, PropertyId property) const {
		switch(property) {
		default:
			Humanoid::output(buffer, property);
			break;
		}
	}


	virtual void input(S32 time, ObjectPool& pool, Input& buffer, PropertyId property) {
		switch(property) {
		default:
			Humanoid::input(time, pool, buffer, property);
			break;
		}
	}


public:

private:
	AmbulanceTeam(const AmbulanceTeam&);
	AmbulanceTeam& operator=(const AmbulanceTeam&);
	bool operator==(const AmbulanceTeam&) const;
};

class AmbulanceCenter
:
	public Building,
	public Agent
{
private:

public:


public:
	AmbulanceCenter() {
	}
	virtual ~AmbulanceCenter() { }

	virtual TypeId type() const {
		return TYPE_AMBULANCE_CENTER;
	}

	virtual int outputProperties(Output& buffer, S32 time) const {
		int result = 0;
		result += Building::outputProperties(buffer, time);
		return result;
	}

	virtual void outputProperties(Output& buffer) const {
		Building::outputProperties(buffer);
	}

	virtual int output(Output& buffer, PropertyId property, S32 time) const {
		int result = 0;
		switch(property) {
		default:
			result = Building::output(buffer, property, time);
			break;
		}
		return result;
	}


	virtual void output(Output& buffer, PropertyId property) const {
		switch(property) {
		default:
			Building::output(buffer, property);
			break;
		}
	}


	virtual void input(S32 time, ObjectPool& pool, Input& buffer, PropertyId property) {
		switch(property) {
		default:
			Building::input(time, pool, buffer, property);
			break;
		}
	}


public:

private:
	AmbulanceCenter(const AmbulanceCenter&);
	AmbulanceCenter& operator=(const AmbulanceCenter&);
	bool operator==(const AmbulanceCenter&) const;
};

class PoliceForce
:
	public Humanoid,
	public Agent
{
private:

public:


public:
	PoliceForce() {
	}
	virtual ~PoliceForce() { }

	virtual TypeId type() const {
		return TYPE_POLICE_FORCE;
	}

	virtual int outputProperties(Output& buffer, S32 time) const {
		int result = 0;
		result += Humanoid::outputProperties(buffer, time);
		return result;
	}

	virtual void outputProperties(Output& buffer) const {
		Humanoid::outputProperties(buffer);
	}

	virtual int output(Output& buffer, PropertyId property, S32 time) const {
		int result = 0;
		switch(property) {
		default:
			result = Humanoid::output(buffer, property, time);
			break;
		}
		return result;
	}


	virtual void output(Output& buffer, PropertyId property) const {
		switch(property) {
		default:
			Humanoid::output(buffer, property);
			break;
		}
	}


	virtual void input(S32 time, ObjectPool& pool, Input& buffer, PropertyId property) {
		switch(property) {
		default:
			Humanoid::input(time, pool, buffer, property);
			break;
		}
	}


public:

private:
	PoliceForce(const PoliceForce&);
	PoliceForce& operator=(const PoliceForce&);
	bool operator==(const PoliceForce&) const;
};

class PoliceOffice
:
	public Building,
	public Agent
{
private:

public:


public:
	PoliceOffice() {
	}
	virtual ~PoliceOffice() { }

	virtual TypeId type() const {
		return TYPE_POLICE_OFFICE;
	}

	virtual int outputProperties(Output& buffer, S32 time) const {
		int result = 0;
		result += Building::outputProperties(buffer, time);
		return result;
	}

	virtual void outputProperties(Output& buffer) const {
		Building::outputProperties(buffer);
	}

	virtual int output(Output& buffer, PropertyId property, S32 time) const {
		int result = 0;
		switch(property) {
		default:
			result = Building::output(buffer, property, time);
			break;
		}
		return result;
	}


	virtual void output(Output& buffer, PropertyId property) const {
		switch(property) {
		default:
			Building::output(buffer, property);
			break;
		}
	}


	virtual void input(S32 time, ObjectPool& pool, Input& buffer, PropertyId property) {
		switch(property) {
		default:
			Building::input(time, pool, buffer, property);
			break;
		}
	}


public:

private:
	PoliceOffice(const PoliceOffice&);
	PoliceOffice& operator=(const PoliceOffice&);
	bool operator==(const PoliceOffice&) const;
};

class Refuge
:
	public Building
{
private:

public:


public:
	Refuge() {
	}
	virtual ~Refuge() { }

	virtual TypeId type() const {
		return TYPE_REFUGE;
	}

	virtual int outputProperties(Output& buffer, S32 time) const {
		int result = 0;
		result += Building::outputProperties(buffer, time);
		return result;
	}

	virtual void outputProperties(Output& buffer) const {
		Building::outputProperties(buffer);
	}

	virtual int output(Output& buffer, PropertyId property, S32 time) const {
		int result = 0;
		switch(property) {
		default:
			result = Building::output(buffer, property, time);
			break;
		}
		return result;
	}


	virtual void output(Output& buffer, PropertyId property) const {
		switch(property) {
		default:
			Building::output(buffer, property);
			break;
		}
	}


	virtual void input(S32 time, ObjectPool& pool, Input& buffer, PropertyId property) {
		switch(property) {
		default:
			Building::input(time, pool, buffer, property);
			break;
		}
	}


public:

private:
	Refuge(const Refuge&);
	Refuge& operator=(const Refuge&);
	bool operator==(const Refuge&) const;
};

class Edge
:
	public MotionlessObject
{
private:
	Object* m_head;
	S32 m_timeHeadUpdated;
	Object* m_tail;
	S32 m_timeTailUpdated;
	S32 m_length;
	S32 m_timeLengthUpdated;

public:
	Object* head() const { return m_head; }
	void setHead(S32 time, Object* value) {
		m_head = value; m_timeHeadUpdated = time; }
	S32 getTimeHeadUpdated() { return m_timeHeadUpdated; }
	Object* tail() const { return m_tail; }
	void setTail(S32 time, Object* value) {
		m_tail = value; m_timeTailUpdated = time; }
	S32 getTimeTailUpdated() { return m_timeTailUpdated; }
	S32 length() const { return m_length; }
	void setLength(S32 time, S32 value) {
		m_length = value; m_timeLengthUpdated = time; }
	S32 getTimeLengthUpdated() { return m_timeLengthUpdated; }


public:
	Edge() {
		m_head = 0;
		m_timeHeadUpdated = 0;
		m_tail = 0;
		m_timeTailUpdated = 0;
		m_length = 1;
		m_timeLengthUpdated = 0;
	}
	virtual ~Edge() { }


	virtual int outputProperties(Output& buffer, S32 time) const {
		int result = 0;
		result += MotionlessObject::outputProperties(buffer, time);
		result += output(buffer, PROPERTY_HEAD, time);
		result += output(buffer, PROPERTY_TAIL, time);
		result += output(buffer, PROPERTY_LENGTH, time);
		return result;
	}

	virtual void outputProperties(Output& buffer) const {
		MotionlessObject::outputProperties(buffer);
		output(buffer, PROPERTY_HEAD);
		output(buffer, PROPERTY_TAIL);
		output(buffer, PROPERTY_LENGTH);
	}

	virtual int output(Output& buffer, PropertyId property, S32 time) const {
		int result = 0;
		switch(property) {
		default:
			result = MotionlessObject::output(buffer, property, time);
			break;
		case PROPERTY_HEAD:
			if(m_timeHeadUpdated >= time) {
				buffer.put(property);
				if(head() == 0)
					buffer.put((Id)0);
				else
					buffer.put(head()->id());
				result = 1;
			}
			break;
		case PROPERTY_TAIL:
			if(m_timeTailUpdated >= time) {
				buffer.put(property);
				if(tail() == 0)
					buffer.put((Id)0);
				else
					buffer.put(tail()->id());
				result = 1;
			}
			break;
		case PROPERTY_LENGTH:
			if(m_timeLengthUpdated >= time) {
				buffer.put(property);
				buffer.put(length());
				result = 1;
			}
			break;
		}
		return result;
	}


	virtual void output(Output& buffer, PropertyId property) const {
		switch(property) {
		default:
			MotionlessObject::output(buffer, property);
			break;
		case PROPERTY_HEAD:
			{
				buffer.put(property);
				if(head() == 0)
					buffer.put((Id)0);
				else
					buffer.put(head()->id());
			}
			break;
		case PROPERTY_TAIL:
			{
				buffer.put(property);
				if(tail() == 0)
					buffer.put((Id)0);
				else
					buffer.put(tail()->id());
			}
			break;
		case PROPERTY_LENGTH:
			{
				buffer.put(property);
				buffer.put(length());
			}
			break;
		}
	}


	virtual void input(S32 time, ObjectPool& pool, Input& buffer, PropertyId property) {
		switch(property) {
		default:
			MotionlessObject::input(time, pool, buffer, property);
			break;
		case PROPERTY_HEAD:
		{
			Id id = buffer.get();
			setHead(time, pool.get(id));
		}
			break;
		case PROPERTY_TAIL:
		{
			Id id = buffer.get();
			setTail(time, pool.get(id));
		}
			break;
		case PROPERTY_LENGTH:
		{
			S32 value = buffer.get();
			setLength(time, value);
		}
			break;
		}
	}


public:
	S32 x() const {
		ASSERT(dynamic_cast<RealObject*>(head()) != 0);
		ASSERT(dynamic_cast<RealObject*>(tail()) != 0);
		S32 h = ((RealObject*)head())->x();	// ꤬ Edge λ̵¥롼
		S32 t = ((RealObject*)tail())->x();
		return (h + t) / 2;				// TODO: Сեʤ褦
	}
	S32 y() const {
		ASSERT(dynamic_cast<RealObject*>(head()) != 0);
		ASSERT(dynamic_cast<RealObject*>(tail()) != 0);
		S32 h = ((RealObject*)head())->y();	// ꤬ Edge λ̵¥롼
		S32 t = ((RealObject*)tail())->y();
		return (h + t) / 2;				// TODO: Сեʤ褦
	}
	

private:
	Edge(const Edge&);
	Edge& operator=(const Edge&);
	bool operator==(const Edge&) const;
};

class Road
:
	public Edge
{
private:
	S32 m_roadKind;
	S32 m_timeRoadKindUpdated;
	S32 m_carsPassToHead;
	S32 m_timeCarsPassToHeadUpdated;
	S32 m_carsPassToTail;
	S32 m_timeCarsPassToTailUpdated;
	S32 m_humansPassToHead;
	S32 m_timeHumansPassToHeadUpdated;
	S32 m_humansPassToTail;
	S32 m_timeHumansPassToTailUpdated;
	S32 m_width;
	S32 m_timeWidthUpdated;
	S32 m_block;
	S32 m_timeBlockUpdated;
	S32 m_repairCost;
	S32 m_timeRepairCostUpdated;
	S32 m_medianStrip;
	S32 m_timeMedianStripUpdated;
	S32 m_linesToHead;
	S32 m_timeLinesToHeadUpdated;
	S32 m_linesToTail;
	S32 m_timeLinesToTailUpdated;
	S32 m_widthForWalkers;
	S32 m_timeWidthForWalkersUpdated;

public:
	S32 roadKind() const { return m_roadKind; }
	void setRoadKind(S32 time, S32 value) {
		m_roadKind = value; m_timeRoadKindUpdated = time; }
	S32 getTimeRoadKindUpdated() { return m_timeRoadKindUpdated; }
	S32 carsPassToHead() const { return m_carsPassToHead; }
	void setCarsPassToHead(S32 time, S32 value) {
		m_carsPassToHead = value; m_timeCarsPassToHeadUpdated = time; }
	S32 getTimeCarsPassToHeadUpdated() { return m_timeCarsPassToHeadUpdated; }
	S32 carsPassToTail() const { return m_carsPassToTail; }
	void setCarsPassToTail(S32 time, S32 value) {
		m_carsPassToTail = value; m_timeCarsPassToTailUpdated = time; }
	S32 getTimeCarsPassToTailUpdated() { return m_timeCarsPassToTailUpdated; }
	S32 humansPassToHead() const { return m_humansPassToHead; }
	void setHumansPassToHead(S32 time, S32 value) {
		m_humansPassToHead = value; m_timeHumansPassToHeadUpdated = time; }
	S32 getTimeHumansPassToHeadUpdated() { return m_timeHumansPassToHeadUpdated; }
	S32 humansPassToTail() const { return m_humansPassToTail; }
	void setHumansPassToTail(S32 time, S32 value) {
		m_humansPassToTail = value; m_timeHumansPassToTailUpdated = time; }
	S32 getTimeHumansPassToTailUpdated() { return m_timeHumansPassToTailUpdated; }
	S32 width() const { return m_width; }
	void setWidth(S32 time, S32 value) {
		m_width = value; m_timeWidthUpdated = time; }
	S32 getTimeWidthUpdated() { return m_timeWidthUpdated; }
	S32 block() const { return m_block; }
	void setBlock(S32 time, S32 value) {
		m_block = value; m_timeBlockUpdated = time; }
	S32 getTimeBlockUpdated() { return m_timeBlockUpdated; }
	S32 repairCost() const { return m_repairCost; }
	void setRepairCost(S32 time, S32 value) {
		m_repairCost = value; m_timeRepairCostUpdated = time; }
	S32 getTimeRepairCostUpdated() { return m_timeRepairCostUpdated; }
	S32 medianStrip() const { return m_medianStrip; }
	void setMedianStrip(S32 time, S32 value) {
		m_medianStrip = value; m_timeMedianStripUpdated = time; }
	S32 getTimeMedianStripUpdated() { return m_timeMedianStripUpdated; }
	S32 linesToHead() const { return m_linesToHead; }
	void setLinesToHead(S32 time, S32 value) {
		m_linesToHead = value; m_timeLinesToHeadUpdated = time; }
	S32 getTimeLinesToHeadUpdated() { return m_timeLinesToHeadUpdated; }
	S32 linesToTail() const { return m_linesToTail; }
	void setLinesToTail(S32 time, S32 value) {
		m_linesToTail = value; m_timeLinesToTailUpdated = time; }
	S32 getTimeLinesToTailUpdated() { return m_timeLinesToTailUpdated; }
	S32 widthForWalkers() const { return m_widthForWalkers; }
	void setWidthForWalkers(S32 time, S32 value) {
		m_widthForWalkers = value; m_timeWidthForWalkersUpdated = time; }
	S32 getTimeWidthForWalkersUpdated() { return m_timeWidthForWalkersUpdated; }


public:
	Road() {
		m_roadKind = 0;
		m_timeRoadKindUpdated = 0;
		m_carsPassToHead = 0;
		m_timeCarsPassToHeadUpdated = 0;
		m_carsPassToTail = 0;
		m_timeCarsPassToTailUpdated = 0;
		m_humansPassToHead = 0;
		m_timeHumansPassToHeadUpdated = 0;
		m_humansPassToTail = 0;
		m_timeHumansPassToTailUpdated = 0;
		m_width = 10;
		m_timeWidthUpdated = 0;
		m_block = 0;
		m_timeBlockUpdated = 0;
		m_repairCost = 0;
		m_timeRepairCostUpdated = 0;
		m_medianStrip = 0;
		m_timeMedianStripUpdated = 0;
		m_linesToHead = 1;
		m_timeLinesToHeadUpdated = 0;
		m_linesToTail = 1;
		m_timeLinesToTailUpdated = 0;
		m_widthForWalkers = 1;
		m_timeWidthForWalkersUpdated = 0;
	}
	virtual ~Road() { }

	virtual TypeId type() const {
		return TYPE_ROAD;
	}

	virtual int outputProperties(Output& buffer, S32 time) const {
		int result = 0;
		result += Edge::outputProperties(buffer, time);
		result += output(buffer, PROPERTY_ROAD_KIND, time);
		result += output(buffer, PROPERTY_CARS_PASS_TO_HEAD, time);
		result += output(buffer, PROPERTY_CARS_PASS_TO_TAIL, time);
		result += output(buffer, PROPERTY_HUMANS_PASS_TO_HEAD, time);
		result += output(buffer, PROPERTY_HUMANS_PASS_TO_TAIL, time);
		result += output(buffer, PROPERTY_WIDTH, time);
		result += output(buffer, PROPERTY_BLOCK, time);
		result += output(buffer, PROPERTY_REPAIR_COST, time);
		result += output(buffer, PROPERTY_MEDIAN_STRIP, time);
		result += output(buffer, PROPERTY_LINES_TO_HEAD, time);
		result += output(buffer, PROPERTY_LINES_TO_TAIL, time);
		result += output(buffer, PROPERTY_WIDTH_FOR_WALKERS, time);
		return result;
	}

	virtual void outputProperties(Output& buffer) const {
		Edge::outputProperties(buffer);
		output(buffer, PROPERTY_ROAD_KIND);
		output(buffer, PROPERTY_CARS_PASS_TO_HEAD);
		output(buffer, PROPERTY_CARS_PASS_TO_TAIL);
		output(buffer, PROPERTY_HUMANS_PASS_TO_HEAD);
		output(buffer, PROPERTY_HUMANS_PASS_TO_TAIL);
		output(buffer, PROPERTY_WIDTH);
		output(buffer, PROPERTY_BLOCK);
		output(buffer, PROPERTY_REPAIR_COST);
		output(buffer, PROPERTY_MEDIAN_STRIP);
		output(buffer, PROPERTY_LINES_TO_HEAD);
		output(buffer, PROPERTY_LINES_TO_TAIL);
		output(buffer, PROPERTY_WIDTH_FOR_WALKERS);
	}

	virtual int output(Output& buffer, PropertyId property, S32 time) const {
		int result = 0;
		switch(property) {
		default:
			result = Edge::output(buffer, property, time);
			break;
		case PROPERTY_ROAD_KIND:
			if(m_timeRoadKindUpdated >= time) {
				buffer.put(property);
				buffer.put(roadKind());
				result = 1;
			}
			break;
		case PROPERTY_CARS_PASS_TO_HEAD:
			if(m_timeCarsPassToHeadUpdated >= time) {
				buffer.put(property);
				buffer.put(carsPassToHead());
				result = 1;
			}
			break;
		case PROPERTY_CARS_PASS_TO_TAIL:
			if(m_timeCarsPassToTailUpdated >= time) {
				buffer.put(property);
				buffer.put(carsPassToTail());
				result = 1;
			}
			break;
		case PROPERTY_HUMANS_PASS_TO_HEAD:
			if(m_timeHumansPassToHeadUpdated >= time) {
				buffer.put(property);
				buffer.put(humansPassToHead());
				result = 1;
			}
			break;
		case PROPERTY_HUMANS_PASS_TO_TAIL:
			if(m_timeHumansPassToTailUpdated >= time) {
				buffer.put(property);
				buffer.put(humansPassToTail());
				result = 1;
			}
			break;
		case PROPERTY_WIDTH:
			if(m_timeWidthUpdated >= time) {
				buffer.put(property);
				buffer.put(width());
				result = 1;
			}
			break;
		case PROPERTY_BLOCK:
			if(m_timeBlockUpdated >= time) {
				buffer.put(property);
				buffer.put(block());
				result = 1;
			}
			break;
		case PROPERTY_REPAIR_COST:
			if(m_timeRepairCostUpdated >= time) {
				buffer.put(property);
				buffer.put(repairCost());
				result = 1;
			}
			break;
		case PROPERTY_MEDIAN_STRIP:
			if(m_timeMedianStripUpdated >= time) {
				buffer.put(property);
				buffer.put(medianStrip());
				result = 1;
			}
			break;
		case PROPERTY_LINES_TO_HEAD:
			if(m_timeLinesToHeadUpdated >= time) {
				buffer.put(property);
				buffer.put(linesToHead());
				result = 1;
			}
			break;
		case PROPERTY_LINES_TO_TAIL:
			if(m_timeLinesToTailUpdated >= time) {
				buffer.put(property);
				buffer.put(linesToTail());
				result = 1;
			}
			break;
		case PROPERTY_WIDTH_FOR_WALKERS:
			if(m_timeWidthForWalkersUpdated >= time) {
				buffer.put(property);
				buffer.put(widthForWalkers());
				result = 1;
			}
			break;
		}
		return result;
	}


	virtual void output(Output& buffer, PropertyId property) const {
		switch(property) {
		default:
			Edge::output(buffer, property);
			break;
		case PROPERTY_ROAD_KIND:
			{
				buffer.put(property);
				buffer.put(roadKind());
			}
			break;
		case PROPERTY_CARS_PASS_TO_HEAD:
			{
				buffer.put(property);
				buffer.put(carsPassToHead());
			}
			break;
		case PROPERTY_CARS_PASS_TO_TAIL:
			{
				buffer.put(property);
				buffer.put(carsPassToTail());
			}
			break;
		case PROPERTY_HUMANS_PASS_TO_HEAD:
			{
				buffer.put(property);
				buffer.put(humansPassToHead());
			}
			break;
		case PROPERTY_HUMANS_PASS_TO_TAIL:
			{
				buffer.put(property);
				buffer.put(humansPassToTail());
			}
			break;
		case PROPERTY_WIDTH:
			{
				buffer.put(property);
				buffer.put(width());
			}
			break;
		case PROPERTY_BLOCK:
			{
				buffer.put(property);
				buffer.put(block());
			}
			break;
		case PROPERTY_REPAIR_COST:
			{
				buffer.put(property);
				buffer.put(repairCost());
			}
			break;
		case PROPERTY_MEDIAN_STRIP:
			{
				buffer.put(property);
				buffer.put(medianStrip());
			}
			break;
		case PROPERTY_LINES_TO_HEAD:
			{
				buffer.put(property);
				buffer.put(linesToHead());
			}
			break;
		case PROPERTY_LINES_TO_TAIL:
			{
				buffer.put(property);
				buffer.put(linesToTail());
			}
			break;
		case PROPERTY_WIDTH_FOR_WALKERS:
			{
				buffer.put(property);
				buffer.put(widthForWalkers());
			}
			break;
		}
	}


	virtual void input(S32 time, ObjectPool& pool, Input& buffer, PropertyId property) {
		switch(property) {
		default:
			Edge::input(time, pool, buffer, property);
			break;
		case PROPERTY_ROAD_KIND:
		{
			S32 value = buffer.get();
			setRoadKind(time, value);
		}
			break;
		case PROPERTY_CARS_PASS_TO_HEAD:
		{
			S32 value = buffer.get();
			setCarsPassToHead(time, value);
		}
			break;
		case PROPERTY_CARS_PASS_TO_TAIL:
		{
			S32 value = buffer.get();
			setCarsPassToTail(time, value);
		}
			break;
		case PROPERTY_HUMANS_PASS_TO_HEAD:
		{
			S32 value = buffer.get();
			setHumansPassToHead(time, value);
		}
			break;
		case PROPERTY_HUMANS_PASS_TO_TAIL:
		{
			S32 value = buffer.get();
			setHumansPassToTail(time, value);
		}
			break;
		case PROPERTY_WIDTH:
		{
			S32 value = buffer.get();
			setWidth(time, value);
		}
			break;
		case PROPERTY_BLOCK:
		{
			S32 value = buffer.get();
			setBlock(time, value);
		}
			break;
		case PROPERTY_REPAIR_COST:
		{
			S32 value = buffer.get();
			setRepairCost(time, value);
		}
			break;
		case PROPERTY_MEDIAN_STRIP:
		{
			S32 value = buffer.get();
			setMedianStrip(time, value);
		}
			break;
		case PROPERTY_LINES_TO_HEAD:
		{
			S32 value = buffer.get();
			setLinesToHead(time, value);
		}
			break;
		case PROPERTY_LINES_TO_TAIL:
		{
			S32 value = buffer.get();
			setLinesToTail(time, value);
		}
			break;
		case PROPERTY_WIDTH_FOR_WALKERS:
		{
			S32 value = buffer.get();
			setWidthForWalkers(time, value);
		}
			break;
		}
	}


public:

private:
	Road(const Road&);
	Road& operator=(const Road&);
	bool operator==(const Road&) const;
};

class River
:
	public Edge
{
private:

public:


public:
	River() {
	}
	virtual ~River() { }

	virtual TypeId type() const {
		return TYPE_RIVER;
	}

	virtual int outputProperties(Output& buffer, S32 time) const {
		int result = 0;
		result += Edge::outputProperties(buffer, time);
		return result;
	}

	virtual void outputProperties(Output& buffer) const {
		Edge::outputProperties(buffer);
	}

	virtual int output(Output& buffer, PropertyId property, S32 time) const {
		int result = 0;
		switch(property) {
		default:
			result = Edge::output(buffer, property, time);
			break;
		}
		return result;
	}


	virtual void output(Output& buffer, PropertyId property) const {
		switch(property) {
		default:
			Edge::output(buffer, property);
			break;
		}
	}


	virtual void input(S32 time, ObjectPool& pool, Input& buffer, PropertyId property) {
		switch(property) {
		default:
			Edge::input(time, pool, buffer, property);
			break;
		}
	}


public:

private:
	River(const River&);
	River& operator=(const River&);
	bool operator==(const River&) const;
};

class Vertex
:
	public PointObject
{
private:
	Objects m_edges;
	S32 m_timeEdgesUpdated;

public:
	const Objects& edges() const { return m_edges; }
	S32 getTimeEdgesUpdated() { return m_timeEdgesUpdated; }


public:
	Vertex() {
	}
	virtual ~Vertex() { }


	virtual int outputProperties(Output& buffer, S32 time) const {
		int result = 0;
		result += PointObject::outputProperties(buffer, time);
		result += output(buffer, PROPERTY_EDGES, time);
		return result;
	}

	virtual void outputProperties(Output& buffer) const {
		PointObject::outputProperties(buffer);
		output(buffer, PROPERTY_EDGES);
	}

	virtual int output(Output& buffer, PropertyId property, S32 time) const {
		int result = 0;
		switch(property) {
		default:
			result = PointObject::output(buffer, property, time);
			break;
		case PROPERTY_EDGES:
			if(m_timeEdgesUpdated >= time) {
				buffer.put(property);
				Objects::const_iterator it = edges().begin();
				for(; it != edges().end(); it++)
					buffer.put((*it)->id());
				buffer.put((Id)0);
				result = 1;
			}
			break;
		}
		return result;
	}


	virtual void output(Output& buffer, PropertyId property) const {
		switch(property) {
		default:
			PointObject::output(buffer, property);
			break;
		case PROPERTY_EDGES:
			{
				buffer.put(property);
				Objects::const_iterator it = edges().begin();
				for(; it != edges().end(); it++)
					buffer.put((*it)->id());
				buffer.put((Id)0);
			}
			break;
		}
	}


	virtual void input(S32 time, ObjectPool& pool, Input& buffer, PropertyId property) {
		switch(property) {
		default:
			PointObject::input(time, pool, buffer, property);
			break;
		case PROPERTY_EDGES:
		{
			Id id;
			m_edges.clear();
			while(id = buffer.get(), id != 0) {
				Object* o = pool.get(id);
				m_edges.push_back(o);
			}
			m_timeEdgesUpdated = time;
		}
			break;
		}
	}


public:
	void testConnect(S32 time, Edge* edge, bool head) {
		if(head) {
			ASSERT(edge->head() == 0);
			edge->setHead(time, this);
		} else {
			ASSERT(edge->tail() == 0);
			edge->setTail(time, this);
		}
		m_edges.push_back(edge);
		m_timeEdgesUpdated = time;
	}
	

private:
	Vertex(const Vertex&);
	Vertex& operator=(const Vertex&);
	bool operator==(const Vertex&) const;
};

class Node
:
	public Vertex
{
private:
	S32 m_signal;
	S32 m_timeSignalUpdated;
	Bytes m_shortcutToTurn;
	S32 m_timeShortcutToTurnUpdated;
	Bytes m_pocketToTurnAcross;
	S32 m_timePocketToTurnAcrossUpdated;
	Bytes m_signalTiming;
	S32 m_timeSignalTimingUpdated;

public:
	S32 signal() const { return m_signal; }
	void setSignal(S32 time, S32 value) {
		m_signal = value; m_timeSignalUpdated = time; }
	S32 getTimeSignalUpdated() { return m_timeSignalUpdated; }
	const Bytes& shortcutToTurn() const { return m_shortcutToTurn; }
	void setShortcutToTurn(S32 time, const Bytes& value) {
		m_shortcutToTurn = value; m_timeShortcutToTurnUpdated = time; }
	S32 getTimeShortcutToTurnUpdated() { return m_timeShortcutToTurnUpdated; }
	const Bytes& pocketToTurnAcross() const { return m_pocketToTurnAcross; }
	void setPocketToTurnAcross(S32 time, const Bytes& value) {
		m_pocketToTurnAcross = value; m_timePocketToTurnAcrossUpdated = time; }
	S32 getTimePocketToTurnAcrossUpdated() { return m_timePocketToTurnAcrossUpdated; }
	const Bytes& signalTiming() const { return m_signalTiming; }
	void setSignalTiming(S32 time, const Bytes& value) {
		m_signalTiming = value; m_timeSignalTimingUpdated = time; }
	S32 getTimeSignalTimingUpdated() { return m_timeSignalTimingUpdated; }


public:
	Node() {
		m_signal = 0;
		m_timeSignalUpdated = 0;
	}
	virtual ~Node() { }

	virtual TypeId type() const {
		return TYPE_NODE;
	}

	virtual int outputProperties(Output& buffer, S32 time) const {
		int result = 0;
		result += Vertex::outputProperties(buffer, time);
		result += output(buffer, PROPERTY_SIGNAL, time);
		result += output(buffer, PROPERTY_SHORTCUT_TO_TURN, time);
		result += output(buffer, PROPERTY_POCKET_TO_TURN_ACROSS, time);
		result += output(buffer, PROPERTY_SIGNAL_TIMING, time);
		return result;
	}

	virtual void outputProperties(Output& buffer) const {
		Vertex::outputProperties(buffer);
		output(buffer, PROPERTY_SIGNAL);
		output(buffer, PROPERTY_SHORTCUT_TO_TURN);
		output(buffer, PROPERTY_POCKET_TO_TURN_ACROSS);
		output(buffer, PROPERTY_SIGNAL_TIMING);
	}

	virtual int output(Output& buffer, PropertyId property, S32 time) const {
		int result = 0;
		switch(property) {
		default:
			result = Vertex::output(buffer, property, time);
			break;
		case PROPERTY_SIGNAL:
			if(m_timeSignalUpdated >= time) {
				buffer.put(property);
				buffer.put(signal());
				result = 1;
			}
			break;
		case PROPERTY_SHORTCUT_TO_TURN:
			if(m_timeShortcutToTurnUpdated >= time) {
				buffer.put(property);
				buffer.put(shortcutToTurn());
				result = 1;
			}
			break;
		case PROPERTY_POCKET_TO_TURN_ACROSS:
			if(m_timePocketToTurnAcrossUpdated >= time) {
				buffer.put(property);
				buffer.put(pocketToTurnAcross());
				result = 1;
			}
			break;
		case PROPERTY_SIGNAL_TIMING:
			if(m_timeSignalTimingUpdated >= time) {
				buffer.put(property);
				buffer.put(signalTiming());
				result = 1;
			}
			break;
		}
		return result;
	}


	virtual void output(Output& buffer, PropertyId property) const {
		switch(property) {
		default:
			Vertex::output(buffer, property);
			break;
		case PROPERTY_SIGNAL:
			{
				buffer.put(property);
				buffer.put(signal());
			}
			break;
		case PROPERTY_SHORTCUT_TO_TURN:
			{
				buffer.put(property);
				buffer.put(shortcutToTurn());
			}
			break;
		case PROPERTY_POCKET_TO_TURN_ACROSS:
			{
				buffer.put(property);
				buffer.put(pocketToTurnAcross());
			}
			break;
		case PROPERTY_SIGNAL_TIMING:
			{
				buffer.put(property);
				buffer.put(signalTiming());
			}
			break;
		}
	}


	virtual void input(S32 time, ObjectPool& pool, Input& buffer, PropertyId property) {
		switch(property) {
		default:
			Vertex::input(time, pool, buffer, property);
			break;
		case PROPERTY_SIGNAL:
		{
			S32 value = buffer.get();
			setSignal(time, value);
		}
			break;
		case PROPERTY_SHORTCUT_TO_TURN:
		{
			Bytes value;
			buffer.getBytes(value);
			setShortcutToTurn(time, value);
		}
			break;
		case PROPERTY_POCKET_TO_TURN_ACROSS:
		{
			Bytes value;
			buffer.getBytes(value);
			setPocketToTurnAcross(time, value);
		}
			break;
		case PROPERTY_SIGNAL_TIMING:
		{
			Bytes value;
			buffer.getBytes(value);
			setSignalTiming(time, value);
		}
			break;
		}
	}


public:

private:
	Node(const Node&);
	Node& operator=(const Node&);
	bool operator==(const Node&) const;
};

class RiverNode
:
	public Vertex
{
private:

public:


public:
	RiverNode() {
	}
	virtual ~RiverNode() { }

	virtual TypeId type() const {
		return TYPE_RIVER_NODE;
	}

	virtual int outputProperties(Output& buffer, S32 time) const {
		int result = 0;
		result += Vertex::outputProperties(buffer, time);
		return result;
	}

	virtual void outputProperties(Output& buffer) const {
		Vertex::outputProperties(buffer);
	}

	virtual int output(Output& buffer, PropertyId property, S32 time) const {
		int result = 0;
		switch(property) {
		default:
			result = Vertex::output(buffer, property, time);
			break;
		}
		return result;
	}


	virtual void output(Output& buffer, PropertyId property) const {
		switch(property) {
		default:
			Vertex::output(buffer, property);
			break;
		}
	}


	virtual void input(S32 time, ObjectPool& pool, Input& buffer, PropertyId property) {
		switch(property) {
		default:
			Vertex::input(time, pool, buffer, property);
			break;
		}
	}


public:

private:
	RiverNode(const RiverNode&);
	RiverNode& operator=(const RiverNode&);
	bool operator==(const RiverNode&) const;
};

	inline S32 MovingObject::x() const {
		ASSERT(dynamic_cast<RealObject*>(position()) != 0);
		Edge* edge = dynamic_cast<Edge*>(position());
		if (edge != 0) {
			S32 length = edge->length();
			if (length != 0) {
				S32 h = ((RealObject*)edge->head())->x();
				S32 t = ((RealObject*)edge->tail())->x();
				return h + (S32)((t - h) * (double)positionExtra() / edge->length());
			}
		}
		return ((RealObject*)position())->x();
	}
	inline S32 MovingObject::y() const {
		ASSERT(dynamic_cast<RealObject*>(position()) != 0);
		Edge* edge = dynamic_cast<Edge*>(position());
		if (edge != 0) {
			S32 length = edge->length();
			if (length != 0) {
				S32 h = ((RealObject*)edge->head())->y();
				S32 t = ((RealObject*)edge->tail())->y();
				return h + (S32)((t - h) * (double)positionExtra() / edge->length());
			}
		}
		return ((RealObject*)position())->y();
	}
	inline Object* ObjectPool::newObject(TypeId type) {
		Object* result;
		switch(type) {
		default:
			ASSERT(false);
			return 0;
		case TYPE_WORLD:
			result = new World();
			break;
		case TYPE_BUILDING:
			result = new Building();
			break;
		case TYPE_CIVILIAN:
			result = new Civilian();
			break;
		case TYPE_CAR:
			result = new Car();
			break;
		case TYPE_FIRE_BRIGADE:
			result = new FireBrigade();
			break;
		case TYPE_FIRE_STATION:
			result = new FireStation();
			break;
		case TYPE_AMBULANCE_TEAM:
			result = new AmbulanceTeam();
			break;
		case TYPE_AMBULANCE_CENTER:
			result = new AmbulanceCenter();
			break;
		case TYPE_POLICE_FORCE:
			result = new PoliceForce();
			break;
		case TYPE_POLICE_OFFICE:
			result = new PoliceOffice();
			break;
		case TYPE_REFUGE:
			result = new Refuge();
			break;
		case TYPE_ROAD:
			result = new Road();
			break;
		case TYPE_RIVER:
			result = new River();
			break;
		case TYPE_NODE:
			result = new Node();
			break;
		case TYPE_RIVER_NODE:
			result = new RiverNode();
			break;
		}
		return result;
	}
	inline void ObjectPool::restructure(S32 time, Input& buffer) {
		bool twice = false;
		Input::Cursor start = buffer.cursor();
		TypeId type;
		while(type = buffer.get(), type != TYPE_NULL) {
			Id id = buffer.get();
			Object* obj = get(id);
			if(obj == 0) {
				twice = true;
				obj = newObject(type);
				obj->setId(id);
				add(obj);
			}
			obj->inputAllProperty(time, *this, buffer);
		}
		if(twice) {
			buffer.setCursor(start);
			while(type = buffer.get(), type != TYPE_NULL) {
				Id id = buffer.get();
				ASSERT(id != 0);
				Object* o = get(id);
				ASSERT(o != 0);
				o->inputAllProperty(time, *this, buffer);
			}
		}
	}
