// Address.hxx
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(ADDRESS_HXX__INCLUDED) // {
#define ADDRESS_HXX__INCLUDED

#include "basic.hxx"

namespace Rescue
{
	/////////////////////////////////////////////////////////////////////////
	// Address

	/**
	* IP ɥ쥹ȥݡֹС
	*/
	class Address
	{
	private:

	protected:
		/** ͥåȥХȥ IP ɥ쥹 */
		u_long m_address;
		/** ͥåȥХȥΥݡֹ */
		u_short m_port;
		/** ͭ */
		u_short m_isValid;
		/** ͭ */
		bool isValid() const;

	public:
		bool operator== (const Address& rhs) const;
		bool operator< (const Address& rhs) const;

		virtual ~Address();
		/** ̵ʥۥ̾ */
		class IllegalHost : public std::runtime_error {
		public:	IllegalHost(const std::string& what_arg) : runtime_error(what_arg) { }
		};
		/** ̵ Address Ȥƽ */
		Address();
		/**
		* ͭ Address Ȥƽ
		* @param	address
		*				ۥ¦ΥХȥ IP ɥ쥹
		* @param	port
		*				ۥ¦ΥХȥΥݡֹ
		* @param	dummy
		*				 trueAddress(0, foo) ȥѥ餬𤹤˻ѡ
		*/
		Address(u_long address, int port, bool dummy = true);
		/**
		* ͭ Address Ȥƽ
		* @param	name
		*				Ρɤ̾"localhost"  "127.0.0.1" ʤɡ
		* @param	port
		*				ۥ¦ΥХȥΥݡֹ
		* @throws	IllegalHost
		*				host  IP ɥ쥹ѴǤʤä
		*/
		Address(const char* name, int port); //throw(IllegalHost)

		/** ۥ¦ΥХȥ IP ɥ쥹 */
		u_long address() const;
		/** ͥåȥХȥ IP ɥ쥹 */
		u_long addressAsNetworkOrder() const;
		/** ۥ¦ΥХȥΥݡֹ */
		u_short port() const;
		/** ͥåȥХȥΥݡֹ */
		u_short portAsNetworkOrder() const;
		
	private:
		/*Address(const Address& source);
		Address& operator= (const Address& rhs);
		bool operator== (const Address& rhs) const;*/
	};
	
	/////////////////////////////////////////////////////////////////////////
} // namespace Rescue

#ifdef NDEBUG
#  include "Address.inl"
#endif

#endif // } !defined(ADDRESS_HXX__INCLUDED)
