// Config.cxx
//
/////////////////////////////////////////////////////////////////////////////

#include "common.hxx"
#include "Config.hxx"

#ifndef NDEBUG
#  include "Config.inl"
#endif

namespace Rescue
{
    /////////////////////////////////////////////////////////////////////////
    // Config
    
    Config::~Config()
    {
    }
    
    Config::Config()
    {
#       define P(type_, name_, value_) m_##name_ = value_;
#       include "parameters.hxx"
#       undef P
    }
    
    bool Config::readConfigFile(const char* filename)
    {
        ASSERT(filename);
        FILE* fp = fopen(filename, "r"FOPEN_MODE_TEXT);
        if(!fp) {
            std::string message = "error: can't open file '";
            message += filename;
            message += "'";
            perror(message.c_str());
            return false;
        }
        
        const int size = 1024;
        char buffer[size];
        char name[size];
        char value[size];
        int line = 0;
        while(fgets(buffer, size, fp) != NULL) {
            line++;
            if (buffer[0] == '#' || buffer[0] == '\n')
                continue;
            
            char *p = buffer;
            while(*p != '\0') {
                if(*p == ':')
                    *p = ' ';
                p++;
            }
            int n = sscanf(buffer, "%s %s", name, value);
            bool valid = false;
            if(n == 2) {
                if(setValue(name, value))
                    valid = true;
            }
            if(!valid)
                fprintf(stderr, "warning: %s (%d) : %s\n", filename, line, buffer);
        }
        
        fclose(fp);
        
        return true;
    }
    
    bool Config::setValue(const char* name, const char* value)
    {
        ASSERT(name && value);
        enum Type {
            v_string,
                v_int,
                v_double,
                v_bool,
        };
        
        Type type;
        void* variable;
#       define P(type_, name_, value_) if(strcmp(name, #name_) == 0) { type = v_##type_; variable = &m_##name_; goto hit; }
#       include "parameters.hxx"
        { return false; }
#       undef P
hit:
        
        int scanned;
        switch(type) {
        case v_string:
            scanned = true;
            *(string*)variable = value;
            break;
        case v_int:
            scanned = sscanf(value, "%d", (int*)variable);
            if(scanned < 1 || scanned == EOF)
                return false;
            break;
        case v_double:
            scanned = sscanf(value, "%lf", (double*)variable);
            if(scanned < 1 || scanned == EOF)
                return false;
            break;
        case v_bool:
            *(bool*)variable = (value == NULL || (strcmp(value, "off") != 0 && strcmp(value, "false") != 0));
            break;
        default:
            ASSERT(false);
        }
        
        return true;
    }
    
    
    
    /////////////////////////////////////////////////////////////////////////
} // namespace Rescue
