
#include "common.hxx"
#include "basic.hxx"
#include "Config.hxx"
#include "Address.hxx"
#include "Input.hxx"
#include "Output.hxx"
#include "LongUDPSocket.hxx"
#include "ObjectPool.hxx"
#include "objects.hxx"
using namespace Rescue;

int main2(int argc, char** argv);
void commands(S32& time, Input& input, Output& output, LongUDPSocket& socket, Address& to, ObjectPool& pool);
void commands(S32& time, Header type, Input& input, ObjectPool& pool);
void move(S32& time, MovingObject* agent, Input& input, ObjectPool& pool);

int main(int argc, char** argv)
{
    try {
        return main2(argc, argv);
    } catch(std::exception& e) {
        fprintf(stderr, "%s\n", (const char*)e.what());
    } catch(...) {
        fprintf(stderr, "error...\n");
    }
    return 1;
}

#if OS_TYPE == OS_TYPE_UNIX
    bool kbhit() {
        fd_set fds;
        FD_ZERO(&fds);
        const int STDIN = 0;
        FD_SET(STDIN, &fds);
        timeval timeout = { 0 };
        int result = select(STDIN + 1, &fds, NULL, NULL, &timeout);
        ASSERT(result != SOCKET_ERROR);
        return (bool)result;
    }
#endif

int main2(int argc, char** argv)
{
    const char* host = "localhost";
    Config config;

    // 
    int i;
    for(i=1; i<argc; i++) {
        if(argv[i][0] == '-') {
            if(strcmp(argv[i], "-file") == 0) {
                if(++i < argc) {
                    config.readConfigFile(argv[i]);
                } else {
                    fprintf(stderr, "error: '-file'\n");
                }
            } else {
                if(++i < argc) {
                    if(!config.setValue(argv[i-1]+1, argv[i]))
                        fprintf(stderr, "error: '%s'\n", argv[i]);
                } else {
                    fprintf(stderr, "error: '%s'\n", argv[i-1]);
                }
            }
        } else {
            fprintf(stderr, "error: a unknown option '%s'\n", argv[i]);
        }
    }

    // åȺ
    Address address = Address(INADDR_ANY, config.port(), true);
    LongUDPSocket socket(address, config.textlogname_gis());
    Input input;
    Output output;
    output.setWait(config.send_udp_wait());
    output.resetFrameSize(config.send_udp_size());
    std::list<Address> viewerAddresses;
    Address to(host, config.port());    //

    // ե򳫤
    FILE* fp = fopen(config.logname().c_str(), "r"FOPEN_MODE_BINARY);
    if(fp == 0) {
        fprintf(stderr, "error: can't open file '%s'\n", config.logname().c_str());
        return 1;
    }
    fseek(fp, 0x20, SEEK_SET);
    output.clear();
    Byte b[4];
    fread(b, sizeof(b[0]), COUNT_OF(b), fp);    // TODO: 顼å
    S32 size = ((S32)b[0] << 24) | ((S32)b[1] << 16) | ((S32)b[2] << 8) | (S32)b[3];
    if(size % 4 != 0) {
        fprintf(stderr, "error: illegal data\n");
        return 1;
    }
    Byte* buffer = new Byte[size];
    fread(buffer, sizeof(Byte), size, fp);
    output.clear();
    for(i=0; i<size; i+=4) {
        Byte* b = buffer + i;
        S32 data = ((S32)b[0] << 24) | ((S32)b[1] << 16) | ((S32)b[2] << 8) | (S32)b[3];
        output.put(data);
    }
    delete[] buffer;



    for(;;) {
        if (viewerAddresses.empty())
            printf("Waiting connection. Start viewer.\n");
        else
            printf("push enter key to start, or connect another viewer.\n");
        
        // ³Ԥ
        bool innocence = true;
        while(innocence) {
            try {
                std::vector<const LongUDPSocket*> sockets;
                sockets.push_back(&socket);
                bool timeout = !LongUDPSocket::wait(sockets, 5 * config.step());
                if (timeout) {
                    if (!viewerAddresses.empty() && kbhit())
                        goto start;
                    continue;
                }
                socket.receive(input);
                for(;;) {
                    Header header = input.get();
                    if(header == HEADER_NULL)
                        break;
                    
                    S32 size = input.get();
                    Input::Cursor start = input.cursor();
                    switch(header) {
                    default:
                        printf("Unknown header.\n");
                        break;
                    case SK_CONNECT:
                    case VK_CONNECT:
                        printf("VK_CONNECT\n");
                        to = socket.addressRecievedFrom();
                        socket.send(output, to);
                        innocence = false;
                        break;
                    case VK_ACKNOWLEDGE:
                        break;
                    }
                    if (!innocence)
                        break;
                    
                    input.setCursor(start);
                    if(size == ~(S32)0)
                        break;
                    input.skip(size);
                }
            } catch(std::exception& e) {
                fprintf(stderr, "%s\n", (const char*)e.what());
            } catch(...) {
                fprintf(stderr, "error...\n");
            }
        }
        
        // ackԤ
        bool connected = false;
        while(!connected) {
            try {
                socket.send(output, to);
                std::vector<const LongUDPSocket*> sockets;
                sockets.push_back(&socket);
                bool timeout = !LongUDPSocket::wait(sockets, 5 * config.step());
                if(timeout) {
                    socket.send(output, to);
                } else {
                    socket.receive(input);
                    for(;;) {
                        Header header = input.get();
                        if(header == HEADER_NULL)
                            break;
                        
                        S32 size = input.get();
                        Input::Cursor start = input.cursor();
                        switch(header) {
                        default:
                            printf("Unknown header.\n");
                            break;
                        case VK_ACKNOWLEDGE:
                            printf("VK_ACKNOWLEDGE\n");
                            connected = true;
                            viewerAddresses.push_back(to);
                            break;
                        case SK_CONNECT:
                        case VK_CONNECT:
                            printf("VK_CONNECT ignored because we wait the VK_ACKNOWLEDGE.\n");
                            break;
                        }
                        
                        input.setCursor(start);
                        if(size == ~(S32)0)
                            break;
                        input.skip(size);
                    }
                }
            } catch(std::exception& e) {
                fprintf(stderr, "%s\n", (const char*)e.what());
            } catch(...) {
                fprintf(stderr, "error...\n");
            }
        }
    }
    
    
start:
    // Ū˿ʹԾ
    for(; !feof(fp); usleep(config.step() * 1000)) {
        output.clear();
        Byte b[4];
        fread(b, sizeof(b[0]), COUNT_OF(b), fp);    // TODO: 顼å
        S32 size = ((S32)b[0] << 24) | ((S32)b[1] << 16) | ((S32)b[2] << 8) | (S32)b[3];
        if(size % 4 != 0) {
            fprintf(stderr, "error: illegal data\n");
            return 1;
        }
        Byte* buffer = new Byte[size];
        fread(buffer, sizeof(Byte), size, fp);
        output.clear();
        for(int i=0; i<size; i+=4) {
            Byte* b = buffer + i;
            S32 data = ((S32)b[0] << 24) | ((S32)b[1] << 16) | ((S32)b[2] << 8) | (S32)b[3];
            output.put(data);
        }
        
        std::list<Address>::const_iterator it = viewerAddresses.begin();
        for(; it != viewerAddresses.end(); it++) {
            socket.send(output, *it);
        }
        delete[] buffer;
    }
    
    fclose(fp);

    return 0;
}
