// Input.hxx
//
/////////////////////////////////////////////////////////////////////////////

#include "LongUDPSocket.hxx"

#if !defined(INPUT_HXX__INCLUDED) // {
#define INPUT_HXX__INCLUDED

#include "basic.hxx"
//#include "Vector.hxx"

namespace Rescue
{
	/////////////////////////////////////////////////////////////////////////
	// Input

	/** ϥХåե */
	class Input
	{
	private:
		
	protected:
		typedef LongUDPSocket::Page Page;
		typedef std::vector<AutoPtr<Page> > Pages;
		Pages m_pages;
		/** ɤǡΥǥå */
		unsigned long m_index;
		/** ɤǡɤ Page ˤ뤫 */
		unsigned int m_segment;
		/** ɤǡΡPage ƬΥǥå */
		unsigned int m_offset;
		
	public:
		virtual ~Input();
		Input();
		
		void reset(const Pages& source);

		long size() const;

		class Cursor {
			friend Input;
			unsigned long m_index;
			unsigned int m_segment;
			unsigned int m_offset;
			Cursor(unsigned long index, unsigned int segment, unsigned int offset) {
				m_index = index;
				m_segment = segment;
				m_offset = offset;
			}
		public:
			unsigned long index() {
				return m_index;
			}
		};
		Cursor cursor() const;
		void setCursor(Cursor cursor);
		void skip(long size);

		/** Хåեνü򤳤ɤ߽ФȤ */
		class Overrun : public std::runtime_error {
		public:	Overrun() : runtime_error("buffer overrun") { }
		};

#if 0	// ѻߤ줿
		void get(U8& result); //throw(Overrun)
		void get(U16& result); //throw(Overrun)
		void get(U32& result); //throw(Overrun)
		U8 get8(); //throw(Overrun)
		U16 get16(); //throw(Overrun)
		U32 get32(); //throw(Overrun)
#endif
		/** 32bit ǡɤ߽Ф*/
		S32 get(); //throw(Overrun)
		void getBytes(Bytes& buffer); //throw(Overrun)
		void getString(std::string& result); //throw(Overrun)
		std::string getString(); //throw(Overrun)
		void get(int size, Byte* buffer); //throw(Overrun)

	private:
		Input(const Input& source);
		Input& operator= (const Input& rhs);
		bool operator== (const Input& rhs) const;
	};
	
	/////////////////////////////////////////////////////////////////////////
} // namespace Rescue

#ifdef NDEBUG
#  include "Input.inl"
#endif

#endif // } !defined(INPUT_HXX__INCLUDED)
