// MiscObjectPool.hxx
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(MISCOBJECTPOOL_HXX__INCLUDED) // {
#define MISCOBJECTPOOL_HXX__INCLUDED

#include "Config.hxx"
#include "ObjectPool.hxx"
#include "MISC.hxx"
#include "objects.hxx"

namespace Rescue
{
     /////////////////////////////////////////////////////////////////////////
     // MiscObjectPool

     class Input;
     class Output;
     class MiscParameter;
     class Dice;
     class Config;
     class Civilian;
     class Building;
     class Road;
     class Humanoid;

     typedef std::vector<Humanoid*> MCivils;

     /** ֥Ȥν */
     class MiscObjectPool : public ObjectPool
     {
     private:
	  MiscParameter prmt;
	  Dice dice;
	  const Config* cfg;

     protected:
#if 0
	  typedef std::map<Id, AutoPtr<Object> > Map;
	  /** Id 饪֥ȤؤΥޥå */
	  Map m_idToObjects;
	  /** ֥Ȥΰ */
	  Objects m_objects;
#endif

//////////////////////////////////////////////////////////////////////////
///////  MiscSimulator Ǥɲ
//////////////////////////////////////////////////////////////////////////
	  MCivils m_agent;
	  MCivils m_death;             // ˴
	  MCivils m_injury;           // 
	  MCivils m_treatedInRefuge;; // ǼŤ줿 Civilian

	  MCivils m_inCivils[ATTB_MAX+1][SEISMIC_MAX+1];       // : ¤ͼ, 
	  MCivils m_inCivilsBroken[ATTB_MAX+1][SEISMIC_MAX+1]; // ݲȲ: ¤ͼ, 
	  MCivils m_inCivilsFiery[ATTB_MAX+1][SEISMIC_MAX+1];  // ƲȲ: ¤ͼ, 

	  MCivils m_victimBroken[ATTB_MAX+1][SEISMIC_MAX+1][BROKEN_MAX+1]; // ݲȲ: ¤ͼ, , ݲ
	  MCivils m_indoor[ATTB_MAX];
	  MCivils m_inBuildingFiery; // ǳƤʪˤ

	  Objects m_buildingBroken; // ݲηʪ
	  Objects m_buildingFiery;  // ηʪ

	  MCivils m_onRoadBlock; // ĺɤȤƻϩˤ륨

     public:
	  virtual ~MiscObjectPool();
	  MiscObjectPool(const Config& config, S32 seed);	     
	  MiscObjectPool();

#if 0
	  /**
	   * ֥ȤϿ롣
	   * @param	newObject
	   *				Ͽ륪֥ȡΥ֥Ȥ      
	   *				ObjectPool ˤä delete 롣id ѤߤǤ뤳ȡ
	   */
	  virtual void add(Object* newObject);


	  /**  ObjectPool 뤹٤ƤΥ֥ȤΥꥹ */
	  const Objects& objects() const;	// ꤫
#endif

	  // ΥƥåפΥߥ졼ʹ
	  void step(S32 time);

	  void classifyObjects(S32 time);

	  void classifyBuilding(S32 time, Building* b);

	  // Ȥʬ
	  void classifyAgents(S32 time, Humanoid* h);
	  void classifyCivils(S32 time, Humanoid* mc);

	  //////////////////////////////////////////////////////////////
	  // Ԥ (Ȳ¤, ٤ˤ)
	  void setBuried(S32 time);
	  void setBuried(S32 time, AttBuilding ABuild, GradeSeismic SGrade);

	  //////////////////////////////////////////////////////////////
	  // ᡼ (Ƹˤ)
	  void setDamages(S32 time);

	  //////////////////////////////////////////////////////////////
	  // Ȳݲˤ᡼
	  void setDamageBroken(S32 time);

	  //////////////////////////////////////////////////////////////
	  // ȲкҤˤ᡼
	  void setDamageFiery(S32 time);

	  //////////////////////////////////////////////////////////////
	  // TODO: ϩǤμϤβȲкҤˤ᡼
	  void setDamageFieryRoad(S32 time);

	  //////////////////////////////////////////////////////////////
	  // ƻϩĺɤˤ᡼
	  void setDamageBlock(S32 time);

	  //////////////////////////////////////////////////////////////
	  // Civilian ʳΥȤΥ᡼Ψ򤫤
	  S32 magnificationDamageBroken(S32 time, Humanoid* h, S32 damage);
	  S32 magnificationDamageFiery(S32 time, Humanoid* h, S32 damage);
	  S32 magnificationDamageBlock(S32 time, Humanoid* h, S32 damage);

	  //////////////////////////////////////////////////////////////
	  // ƻϩĺɤˤ᡼
	  void mergeDamages(S32 time, Humanoid* mc);

	  //////////////////////////////////////////////////////////////
	  // ᡼οʹ
	  void progressDamages(S32 time);
	  void progressDamages(S32 time, Humanoid* mc);
	  void progressDamageBury(S32 time, Humanoid* mc);
	  void progressDamageBroken(S32 time, Humanoid* mc);
	  void progressDamageFiery(S32 time, Humanoid* mc);
	  void progressDamageBlock(S32 time, Humanoid* mc);

	  //////////////////////////////////////////////////////////////
	  // Hp ι
	  void updateHp(S32 time, Humanoid* mc);

	  //////////////////////////////////////////////////////////////
	  // ᡼μ
	  //       damage  0 ˤ
	  void treatDamage(S32, Humanoid* mc);

     private:
	  MiscObjectPool(const MiscObjectPool& source);
	  MiscObjectPool& operator= (const MiscObjectPool& rhs);
	  bool operator== (const MiscObjectPool& rhs) const;
// by TM
void MiscObjectPool::mysrand(Humanoid* h, S32 time) { srand(cfg->misc_random_seed() * h->id() * time); }
     };

     /////////////////////////////////////////////////////////////////////////
} // namespace Rescue

#if 1
#ifdef NDEBUG
#  include "MiscObjectPool.inl"
#endif
#endif

#endif // } !defined(MISCOBJECTPOOL_HXX__INCLUDED)
