// ObjectPool.hxx
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(OBJECTPOOL_HXX__INCLUDED) // {
#define OBJECTPOOL_HXX__INCLUDED

#include "basic.hxx"
#include "AutoPtr.hxx"

namespace Rescue
{
	/////////////////////////////////////////////////////////////////////////
	// ObjectPool

	class Input;
	class Output;
	/** ֥Ȥν */
	class ObjectPool
	{
	private:
		
	protected:
		typedef std::map<Id, AutoPtr<Object> > Map;
		/** Id 饪֥ȤؤΥޥå */
		Map m_idToObjects;
		/** ֥Ȥΰ */
		Objects m_objects;

	public:
		virtual ~ObjectPool();
		ObjectPool();

		/**
		* ֥ȤϿ롣
		* @param	newObject
		*				Ͽ륪֥ȡΥ֥Ȥ      
		*				ObjectPool ˤä delete 롣id ѤߤǤ뤳ȡ
		*/
		virtual void add(Object* newObject);

		/** obj->id() == id ʤ obj ֤ */
		Object* get(Id id);
		/**  ObjectPool 뤹٤ƤΥ֥ȤΥꥹ */
		const Objects& objects() const;	// ꤫

		/** type  ֥Ȥ new ֤ */
		virtual Object* newObject(TypeId type);

		/** buffer  Objects եޥåȤ˽ä֥ȾФ*this ȿǤ */
		void restructure(S32 time, Input& buffer);

		/** output ءtime ʹߤѹ줿ƤΥ֥ȤΡѹ줿ץѥƥϤ */
		void output(Output& output, S32 time);
		/** output ءƤΥ֥ȤƤΥץѥƥϤ */
		void output(Output& output);
	public:
		// ʲϥƥѡ롣
		/** ǸϿ줿֥Ȥ Id */
		Id m_lastId;
		/**
		* ֥ȤϿ롣
		* @param	newObject
		*				Ͽ륪֥ȡΥ֥Ȥ      
		*				ObjectPool ˤä delete 롣id  this Ƥ
		*/
		Id testAdd(Object* newObject);
		

	private:
		ObjectPool(const ObjectPool& source);
		ObjectPool& operator= (const ObjectPool& rhs);
		bool operator== (const ObjectPool& rhs) const;
	};
	
	/////////////////////////////////////////////////////////////////////////
} // namespace Rescue

#ifdef NDEBUG
#  include "ObjectPool.inl"
#endif

#endif // } !defined(OBJECTPOOL_HXX__INCLUDED)
