// LongUDPSocket.inl
//
/////////////////////////////////////////////////////////////////////////////

#ifdef NDEBUG
//#  include
#endif

#include "Input.hxx"
#include "Output.hxx"

#ifndef NDEBUG
#  define inline
#else
#  define inline inline
#endif

namespace Rescue
{
	/////////////////////////////////////////////////////////////////////////
	// LongUDPSocket
	
	inline LongUDPSocket::LongUDPSocket(const Address& self, const std::string& name) : m_socket(self)
	{
		// ѹ顢ѹ뤳
		m_name = name;
		m_fp = 0;
		m_sizeReceiveBuffer = 4096 + 16;	// TODO: ե뤫ɤ߽Ф
		m_counter = 0;

		if(!m_name.empty()) {
			m_fp = fopen(m_name.c_str(), "w"FOPEN_MODE_TEXT);
		}
		if(m_fp) {
			time_t t;
			time(&t);
			tm today;
			today = *localtime(&t);
			fprintf(m_fp, "\n*I/O log   %d/%d/%d %d:%d:%d\n", today.tm_year, today.tm_mon, today.tm_mday, today.tm_hour, today.tm_min, today.tm_sec);
		}
		// ѹ顢ѹ뤳
	}
	inline LongUDPSocket::LongUDPSocket(const std::string& name) : m_socket(Address(INADDR_ANY, 0, true))
	{
		// ѹ顢ѹ뤳
		m_name = name;
		m_fp = 0;
		m_sizeReceiveBuffer = 4096 + 16;	// TODO: ե뤫ɤ߽Ф
		m_counter = 0;

		if(!m_name.empty()) {
			m_fp = fopen(m_name.c_str(), "w"FOPEN_MODE_TEXT);
		}
		if(m_fp) {
			time_t t;
			time(&t);
			tm today;
			today = *localtime(&t);
			fprintf(m_fp, "\n*I/O log   %d/%d/%d %d:%d:%d\n", today.tm_year, today.tm_mon, today.tm_mday, today.tm_hour, today.tm_min, today.tm_sec);
		}
		// ѹ顢ѹ뤳
	}
	
	inline bool LongUDPSocket::send(const Output& output, const Address& to, long logedID)
	{
		if(m_fp)
			fprintf(m_fp, "*send %ld", logedID);
		bool result = output.send(m_socket, to, m_counter++, m_fp);
		if(m_fp)
			fflush(m_fp);
		return result;
	}
	inline bool LongUDPSocket::empty() const
	{
		eat(false);
		return m_booksComplete.empty();
	}
	inline bool LongUDPSocket::receive(Input& input, long logedID)
	{
		eat(m_booksComplete.empty());

		ASSERT(!m_booksComplete.empty());
		AutoPtr<Book> p = m_booksComplete.front();
		input.reset(p->pages);
		m_addressRecievedFrom = p->from;
		m_booksComplete.pop_front();

		if(m_fp) {
			fprintf(m_fp, "*receive %ld", logedID);
			Input::Cursor start = input.cursor();
			for(long index = 0; index<input.size(); index+=4) {
				if(index % 0x20 == 0)
					fprintf(m_fp, "\n%8.8lX:  ", (long)index);
				S32 data = input.get();
				fprintf(m_fp, " %8.8lX", (long)data);
			}
			fprintf(m_fp, "\n");
			fflush(m_fp);
			input.setCursor(start);
		}

		return true;
	}
	inline const Address& LongUDPSocket::addressRecievedFrom() const
	{
		return m_addressRecievedFrom;
	}
	


	/*inline LongUDPSocket::LongUDPSocket(const LongUDPSocket& source)
	{
		LongUDPSocket();
		operator= (source);
	}
	inline LongUDPSocket& LongUDPSocket::operator= (const LongUDPSocket& rhs)
	{
		if(this == &rhs)
			return *this;
		return *this;
	}
	inline bool LongUDPSocket::operator== (const LongUDPSocket& rhs) const
	{
		if(this == &rhs)
			return true;
	}*/
	
	/////////////////////////////////////////////////////////////////////////
} // namespace Rescue
#undef inline
