// Output.inl
//
/////////////////////////////////////////////////////////////////////////////

#ifdef NDEBUG
//#  include
#endif
#include "UDPSocket.hxx"

#ifndef NDEBUG
#  define inline
#else
#  define inline inline
#endif

namespace Rescue
{
	/////////////////////////////////////////////////////////////////////////
	// Output

	inline void Output::setWait(long wait)
	{
		m_wait = wait;
	}

	inline void Output::resize(unsigned long size)
	{
		while(size > m_capacity) {
			m_store.push_back(new Byte[m_frameSize + m_headerSize]);
			m_capacity += m_frameSize;
		}
		m_size = size;
	}
	
	inline Output::Output(int frameSize)
	{
		ASSERT(0 < frameSize && (frameSize & 3) == 0);
		m_wait = 1;
		m_capacity = 0;
		m_size = 0;
		m_frameSize = frameSize;
	}

	inline void Output::resetFrameSize(int frameSize)
	{
		frameSize -= m_headerSize;
		frameSize &= ~3;
		if(frameSize < 4)
			frameSize = 4;
		Store::iterator it = m_store.begin();
		for(; it != m_store.end(); it++) {
			Byte* p = *it;
			delete[] p;
		}
		m_store.clear();
		m_capacity = 0;
		m_size = 0;
		m_frameSize = frameSize;
	}

	inline long Output::size() const
	{
		return m_size;
	}
	inline void Output::resize(long size)
	{
		m_size = size;
	}

	inline void Output::clear()
	{
		m_size = 0;
	}
	
	inline Output::Cursor Output::put(S32 value)
	{
		unsigned int segment = m_size / m_frameSize;
		unsigned int offset = m_size % m_frameSize;
		Cursor result(segment, offset);
		resize(m_size + 4);
		set(result, value);
		return result;
	}
	inline void Output::putString(const char* string)
	{
		S32 size = strlen(string);
		ASSERT(size < S32_MAX-4);
		put(size);
		
		unsigned int segment = m_size / m_frameSize;
		unsigned int offset = m_size % m_frameSize;
		int size2 = ((size + 3) & ~3);
		resize(m_size + size2);
		Byte* p = m_store[segment] + m_headerSize + offset;
		const char* q = string;
		for(int i=0; i<size2; i++) {
			ASSERT(offset < m_frameSize);
			*p++ = *q;
			if(*q)
				q++;
			if(++offset >= m_frameSize) {
				segment++;
				offset -= m_frameSize;
				p = m_store[segment] + m_headerSize + offset;
			}
		}
	}
	inline void Output::put(const Bytes& buffer)
	{
#if 1
		// 餫٤
		S32 size = buffer.size();
		put(size);
		int index = 0;
		for(; size>0; size-=4) {
			S32 data = (S32)buffer[index++] << 24;
			if(size > 1) {
				data |= (S32)buffer[index++] << 16;
				if(size > 2) {
					data |= (S32)buffer[index++] << 8;
					if(size > 3)
						data |= (S32)buffer[index++];
				}
			}
			put(data);
		}
#else
		// ǥХå̤λ
		S32 size = buffer.size();
		put(size);
		S32 bounded = (size + 3) & ~(S32)3;
		
		unsigned int segment = m_size / m_frameSize;
		unsigned int offset = m_size % m_frameSize;
		Byte* p = m_store[segment] + m_headerSize + offset;
		Bytes::const_iterator q = buffer.begin();
		int i=0;
		for(; i<size; i++) {
			ASSERT(offset < m_frameSize);
			*p++ = *q++;
			if(++offset >= m_frameSize) {
				segment++;
				offset -= m_frameSize;
				p = m_store[segment] + m_headerSize + offset;
			}
		}
		for(; i<bounded; i++) {
			ASSERT(offset < m_frameSize);
			*p++ = 0;
			if(++offset >= m_frameSize) {
				segment++;
				offset -= m_frameSize;
				p = m_store[segment] + m_headerSize + offset;
			}
		}
#endif
	}
	inline void Output::put(int size, const Byte* buffer)
	{
		ASSERT((size & 3) == 0);
		unsigned int segment = m_size / m_frameSize;
		unsigned int offset = m_size % m_frameSize;
		resize(m_size + size);
		Byte* p = m_store[segment] + m_headerSize + offset;
		const Byte* q = buffer;
		for(int i=0; i<size; i++) {
			ASSERT(offset < m_frameSize);
			*p++ = *q++;
			if(++offset >= m_frameSize) {
				segment++;
				offset -= m_frameSize;
				p = m_store[segment] + m_headerSize + offset;
			}
		}
	}
	inline void Output::set(Cursor cursor, S32 value)
	{
		unsigned int segment = cursor.segment;
		unsigned int offset = cursor.offset;
		ASSERT(offset + 4 <= m_frameSize);
		
		Byte* p = m_store[segment] + m_headerSize + offset;
		unsigned long uvalue;
		// TODO: C λͥå
#if -1 == ~0	// 2ɽɤ
		uvalue = value;
#else
		if(value >= 0)
			uvalue = value;
		else
			uvalue = ~(((unsigned long)(-value)) - 1);
#endif
		// TODO: C λͥå
		//		 (Byte)(x & 0xFF) ϡ(Byte)x Ǥޤʤ
		*p++ = (Byte)((uvalue >> 24) & 0xFF);
		*p++ = (Byte)((uvalue >> 16) & 0xFF);
		*p++ = (Byte)((uvalue >> 8) & 0xFF);
		*p = (Byte)(uvalue & 0xFF);
	}
	inline void Output::setSize(Cursor cursor)
	{
		const int size_of_S32 = 4;
		unsigned int segment = m_size / m_frameSize;
		unsigned int offset = m_size % m_frameSize;
		if(segment == cursor.segment) {
			S32 data = offset - cursor.offset - size_of_S32;
			set(cursor, data);
		} else {
			S32 data = offset;
			data += m_frameSize * (segment - cursor.segment);
			data -= cursor.offset;
			data -= size_of_S32;
			set(cursor, data);
		}
	}

	inline void Output::log(FILE* logfp) const
	{
		long s = size();
		Byte b[4];
		b[0] = (Byte)((s >> 24) & 0xFF);
		b[1] = (Byte)((s >> 16) & 0xFF);
		b[2] = (Byte)((s >> 8) & 0xFF);
		b[3] = (Byte)(s & 0xFF);
		fwrite(b, sizeof(b[0]), COUNT_OF(b), logfp);
		long totalsize = m_size;
		Store::const_iterator it = m_store.begin();
		for(; it != m_store.end(); it++) {
			Byte* bytes = *it;
			bytes += m_headerSize;
			long size = m_frameSize;
			if(size > totalsize)
				size = totalsize;
			fwrite(bytes, sizeof(Byte), size, logfp);
			totalsize -= size;
		}
		fflush(logfp);
	}
	inline bool Output::send(UDPSocket& socket, const Address& to, S16 id, FILE* logfp) const
	{
		unsigned int total = (m_size + m_frameSize - 1) / m_frameSize;
		ASSERT(total <= 0xFFFF);
		if(total == 0)
			total = 1;

		unsigned int segment = 0;
		for(;;) {
			//printf("%d ", segment);
			Byte* p = m_store[segment];
			p[0] = (Byte)0;	// version
			p[1] = (Byte)m_headerSize;
			p[2] = (Byte)((id >> 8) & 0xFF);		// TODO: äݤ
			p[3] = (Byte)(id & 0xFF);
			p[4] = (Byte)((segment >> 8) & 0xFF);
			p[5] = (Byte)(segment & 0xFF);
			p[6] = (Byte)((total >> 8) & 0xFF);
			p[7] = (Byte)(total & 0xFF);
			ASSERT(m_headerSize == 8);
			unsigned int offset = m_frameSize;
			if(segment == total - 1) {
				offset = m_size % m_frameSize;
				if(m_size != 0 && offset == 0)
					offset = m_frameSize;
			}
			if(!socket.send(to, p, offset + m_headerSize))
				return false;
			if(++segment >= total)
				break;

			usleep(m_wait * 1000);
		}
		//printf("\n");

		if(logfp) {
			unsigned long index = 0;
			Store::const_iterator it = m_store.begin();
			for(; it != m_store.end(); it++) {
				Byte* bytes = *it;
				unsigned int i=0;
				for(; i<m_frameSize && index<m_size; i+=4, index+=4) {
					Byte b1 = bytes[i+m_headerSize+0];
					Byte b2 = bytes[i+m_headerSize+1];
					Byte b3 = bytes[i+m_headerSize+2];
					Byte b4 = bytes[i+m_headerSize+3];
				
					if(index % 0x20 == 0)
						fprintf(logfp, "\n%8.8lX:  ", (long)index);
					fprintf(logfp, " %2.2X%2.2X%2.2X%2.2X", b1, b2, b3, b4);
				}
			}
			fprintf(logfp, "\n");
		}

		return true;
	}


	/*inline Output::Output(const Output& source)
	{
		Output();
		operator= (source);
	}
	inline Output& Output::operator= (const Output& rhs)
	{
		if(this == &rhs)
			return *this;
		return *this;
	}
	inline bool Output::operator== (const Output& rhs) const
	{
		if(this == &rhs)
			return true;
	}*/
	
	/////////////////////////////////////////////////////////////////////////
} // namespace Rescue
#undef inline
