
package rescue;

import java.util.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.net.*;

public class Frame extends java.awt.Frame
{
	protected Viewer _viewer = new Viewer();
	protected int _width = 640;
	protected int _height = 480;

	public Frame() {
		enableEvents(AWTEvent.WINDOW_EVENT_MASK);
		
		MenuBar menuBar = new MenuBar();
		Menu menuFile = new Menu();
		MenuItem menuConnect = new MenuItem();
		MenuItem menuExit = new MenuItem();
		MenuItem menuTest = new MenuItem();
		
		this.setMenuBar(menuBar);
		menuFile.setLabel("File");
		menuConnect.setLabel("Connect");
		menuConnect.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				commandConnect(e);
			}
		});
		menuExit.setLabel("Exit");
		menuExit.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				commandClose(e);
			}
		});
		menuTest.setLabel("Test");
		menuTest.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				commandTest(e);
			}
		});
		menuBar.add(menuFile);
		//menuFile.add(menuConnect);
		menuFile.add(menuExit);
		//menuFile.add(menuTest);
		
		add(_viewer);
	}
	
	public void commandConnect(ActionEvent e) {
		new Thread() {
			public void run() {
				_viewer.loop(_host, _port);
			}
		}.start();
	}
	
	private void commandTest(ActionEvent e) {
		try {
			DataOutputStream dos = new DataOutputStream(new FileOutputStream("test.bin"));
			dos.writeBoolean(false);
			dos.writeBoolean(true);
			dos.writeByte(0x01);
			dos.writeShort(0x0123);
			dos.writeInt(0x01234567);
			dos.writeLong(0x0123456789abcdefl);
			dos.close();
		} catch(IOException ex) {
			ex.printStackTrace();
		}
	}

	protected void processWindowEvent(WindowEvent e) {
		super.processWindowEvent(e);
		if(e.getID() == WindowEvent.WINDOW_CLOSING) {
			commandClose(null);
		}
	}

	private void commandClose(ActionEvent e) {
		//dispose();
		System.exit(0);
	}

	protected InetAddress _host;
	protected int _port = 6000;
	public static void main(String[] args) {
        try {
			Frame frame = new Frame();
			frame._host = InetAddress.getLocalHost();
			for(int i=0; i<args.length; i++) {
				switch(i) {
				case 0:
					frame._host = InetAddress.getByName(args[i]);
					break;
				case 1:
					frame._port = Integer.parseInt(args[i]);
					break;
				}
			}
			
			frame.pack();
			frame.setVisible(true);
			frame.commandConnect(null);
        }
        catch(Exception e) {
            e.printStackTrace();
        }
        //try{System.in.read();}catch(Exception e){e.printStackTrace();}
    }

}
