
package rescue;

import java.util.*;
import java.io.*;

public class Pool
{
	static final int TYPE_NULL = 0;
	static final int TYPE_FIRE_STATION = 185;
	static final int TYPE_AMBULANCE_TEAM = 234;
	static final int TYPE_RIVER_NODE = 201;
	static final int TYPE_FIRE_BRIGADE = 233;
	static final int TYPE_NODE = 200;
	static final int TYPE_POLICE_FORCE = 235;
	static final int TYPE_ROAD = 168;
	static final int TYPE_WORLD = 208;
	static final int TYPE_REFUGE = 184;
	static final int TYPE_BUILDING = 176;
	static final int TYPE_CIVILIAN = 232;
	static final int TYPE_AMBULANCE_CENTER = 186;
	static final int TYPE_POLICE_OFFICE = 187;
	static final int TYPE_RIVER = 169;
	
	static final int PROPERTY_TYPE = -2;
	static final int PROPERTY_ID = -1;
	static final int PROPERTY_NULL = 0;
	static final int PROPERTY_WATER_QUANTITY = 25;
	static final int PROPERTY_CARS_PASS_TO_TAIL = 35;
	static final int PROPERTY_CARS_PASS_TO_HEAD = 34;
	static final int PROPERTY_POSITION_HISTORY = 207;
	static final int PROPERTY_POCKET_TO_TURN_ACROSS = 129;
	static final int PROPERTY_BUILDING_ATTRIBUTES = 15;
	static final int PROPERTY_WIND_FORCE = 32;
	static final int PROPERTY_START_TIME = 29;
	static final int PROPERTY_FLOORS = 14;
	static final int PROPERTY_DAMAGE = 11;
	static final int PROPERTY_DIRECTION = 27;
	static final int PROPERTY_WIDTH = 38;
	static final int PROPERTY_BUILDING_APEXES = 131;
	static final int PROPERTY_BUILDING_AREA_TOTAL = 52;
	static final int PROPERTY_LONGITUDE = 30;
	static final int PROPERTY_BROKENNESS = 17;
	static final int PROPERTY_WIND_DIRECTION = 33;
	static final int PROPERTY_SHORTCUT_TO_TURN = 128;
	static final int PROPERTY_LINES_TO_TAIL = 42;
	static final int PROPERTY_LINES_TO_HEAD = 41;
	static final int PROPERTY_TAIL = 13;
	static final int PROPERTY_HEAD = 12;
	static final int PROPERTY_POSITION = 6;
	static final int PROPERTY_LATITUDE = 31;
	static final int PROPERTY_SIGNAL_TIMING = 130;
	static final int PROPERTY_HUMANS_PASS_TO_TAIL = 37;
	static final int PROPERTY_HUMANS_PASS_TO_HEAD = 36;
	static final int PROPERTY_LENGTH = 24;
	static final int PROPERTY_IGNITION = 48;
	static final int PROPERTY_BUILDING_AREA_GROUND = 51;
	static final int PROPERTY_ROAD_KIND = 19;
	static final int PROPERTY_BURIEDNESS = 23;
	static final int PROPERTY_STRETCHED_LENGTH = 26;
	static final int PROPERTY_FIERYNESS = 16;
	static final int PROPERTY_SIGNAL = 44;
	static final int PROPERTY_WIDTH_FOR_WALKERS = 43;
	static final int PROPERTY_ENTRANCES = 235;
	static final int PROPERTY_BUILDING_CODE = 50;
	static final int PROPERTY_EDGES = 242;
	static final int PROPERTY_MEDIAN_STRIP = 40;
	static final int PROPERTY_STAMINA = 9;
	static final int PROPERTY_Y = 4;
	static final int PROPERTY_X = 3;
	static final int PROPERTY_POSITION_EXTRA = 7;
	static final int PROPERTY_REPAIR_COST = 39;
	static final int PROPERTY_HP = 10;
	static final int PROPERTY_BLOCK = 22;

	public static void error() {
		System.out.println("error!!");
		System.exit(1);
	}
	
	public static class _Object
	{
		public int id;
		public void inputAllProperty(Dictionary d, DataInputStream dis) throws IOException {
			int property = dis.readInt();
			for(; property != PROPERTY_NULL; property = dis.readInt())
				input(d, dis, property);
		}
		protected void input(Dictionary d, DataInputStream dis, int property) throws IOException {
			if(property < 0x80) {
				dis.readInt();
			} else if(property < 0xC0) {
				int size = dis.readInt();
				for(; size>0; size-=4)
					dis.readInt();
			} else {
				int v;
				do {
					v = dis.readInt();
				} while(v != 0);
			}
		}
	}
	public static class World extends _Object
	{
	}
	public static class MotionlessObject extends _Object
	{
	}
	public static class PointObject extends MotionlessObject
	{
		public int x;
		public int y;
		protected void input(Dictionary d, DataInputStream dis, int property) throws IOException {
			switch(property) {
				default:
					super.input(d, dis, property);
					break;
				case PROPERTY_X:
					x = dis.readInt();
					break;
				case PROPERTY_Y:
					y = dis.readInt();
					break;
			}
		}
	}
	public static class MovingObject extends _Object
	{
		public Integer position = new Integer(0);
		public int positionExtra;
		protected void input(Dictionary d, DataInputStream dis, int property) throws IOException {
			switch(property) {
				default:
					super.input(d, dis, property);
					break;
				case PROPERTY_POSITION:
					position = new Integer(dis.readInt());
					break;
				case PROPERTY_POSITION_EXTRA:
					positionExtra = dis.readInt();
					break;
			}
		}
	}
	public static class Humanoid extends MovingObject
	{
		public static final int hpMax = 10000;
		public int stamina = 10000;
		public int hp = hpMax;
		public int damage = 0;
		public int buriedness = 0;
		protected void input(Dictionary d, DataInputStream dis, int property) throws IOException {
			switch(property) {
				default:
					super.input(d, dis, property);
					break;
				case PROPERTY_STAMINA:
					stamina = dis.readInt();
					break;
				case PROPERTY_HP:
					hp = dis.readInt();
					break;
				case PROPERTY_DAMAGE:
					damage = dis.readInt();
					break;
				case PROPERTY_BURIEDNESS:
					buriedness = dis.readInt();
					break;
			}
		}
	}
	public static class Building extends PointObject
	{
		//U32 m_floors;
		//U32 m_buildingAttributes;
		int fieryness;
		int brokenness;
		//CPObjects m_entrances;
		int ignition;
		Integer entrance = new Integer(0);
		protected void input(Dictionary d, DataInputStream dis, int property) throws IOException {
			switch(property) {
				default:
					super.input(d, dis, property);
					break;
				case PROPERTY_FIERYNESS:
					fieryness = dis.readInt();
					break;
				case PROPERTY_BROKENNESS:
					brokenness = dis.readInt();
					break;
				case PROPERTY_IGNITION:
					ignition = dis.readInt();
					break;
				case PROPERTY_ENTRANCES:
				{
					for(;;) {
						int v = dis.readInt();
						if(v == 0)
							break;
						entrance = new Integer(v);
					}
					break;
				}
			}
		}
	}
	public static class Civilian extends Humanoid
	{
	}
	public static class FireCompany extends Humanoid
	{
	}
	public static class FireStation extends Building
	{
	}
	public static class AmbulanceTeam extends Humanoid
	{
	}
	public static class AmbulanceCenter extends Building
	{
	}
	public static class PoliceForce extends Humanoid
	{
	}
	public static class PoliceOffice extends Building
	{
	}
	public static class Refuge extends Building
	{
	}
	
	public static class Edge extends MotionlessObject
	{
		public Integer head = new Integer(0);
		public Integer tail = new Integer(0);
		public int length;
		public int width = 10;
		public int block = 0;
		protected void input(Dictionary d, DataInputStream dis, int property) throws IOException {
			switch(property) {
				default:
					super.input(d, dis, property);
					break;
				case PROPERTY_HEAD:
					head = new Integer(dis.readInt());
					break;
				case PROPERTY_TAIL:
					tail = new Integer(dis.readInt());
					break;
				case PROPERTY_LENGTH:
					length = dis.readInt();
					break;
				case PROPERTY_WIDTH:
					width = dis.readInt();
					break;
				case PROPERTY_BLOCK:
					block = dis.readInt();
					break;
			}
		}
	}
	public static class Road extends Edge
	{
	}
	public static class River extends Edge
	{
	}
	
	public static class Vertex extends PointObject
	{
	}
	public static class Node extends Vertex
	{
	}
	public static class RiverNode extends Vertex
	{
	}
	
	public final Dictionary map = new Hashtable();
	public _Object newObject(int type) {
		_Object result;
		switch(type) {
		default:
			error();
			return null;
		case TYPE_WORLD:
			result = new World();
			break;
		case TYPE_BUILDING:
			result = new Building();
			break;
		case TYPE_CIVILIAN:
			result = new Civilian();
			break;
		case TYPE_FIRE_BRIGADE:
			result = new FireCompany();
			break;
		case TYPE_FIRE_STATION:
			result = new FireStation();
			break;
		case TYPE_AMBULANCE_TEAM:
			result = new AmbulanceTeam();
			break;
		case TYPE_AMBULANCE_CENTER:
			result = new AmbulanceCenter();
			break;
		case TYPE_POLICE_FORCE:
			result = new PoliceForce();
			break;
		case TYPE_POLICE_OFFICE:
			result = new PoliceOffice();
			break;
		case TYPE_REFUGE:
			result = new Refuge();
			break;
		case TYPE_ROAD:
			result = new Road();
			break;
		case TYPE_NODE:
			result = new Node();
			break;
		case TYPE_RIVER:
			result = new River();
			break;
		case TYPE_RIVER_NODE:
			result = new RiverNode();
			break;
		}
		return result;
	}
	public final Vector motionlesses = new Vector();
	public final Vector movings = new Vector();

	public static final int LIVING = 0;
	public static final int DEAD = 1;
	public int[] humanoids = new int[2];
	public int livings() { return humanoids[LIVING]; }
	public int deads() { return humanoids[DEAD]; }
	public int getCategory(Humanoid h) {
		return (h.hp <= 0) ? DEAD : LIVING;
	}
	public static final int NONBURNED = 0;
	public static final int BURNING = 1;
	public static final int BURNEDOUT = 2;
	public static final int EXTINGUISHED = 3;
	public int[] buildings = new int[4];
	public int nonburned() { return buildings[NONBURNED]; }
	public int burning() { return buildings[BURNING]; }
	public int burnedout() { return buildings[BURNEDOUT]; }
	public int extinguished() { return buildings[EXTINGUISHED]; }
	public int getCategory(Building b) {
		switch(b.fieryness) {
		case 0:
			return NONBURNED;
		case 1:
		case 2:
		case 3:
			return BURNING;
		case 4:
		case 5:
			return EXTINGUISHED;
		default:
			return BURNEDOUT;
		}
	}

	public void restructure(DataInputStream dis) throws IOException {
		int count = 0;
		int type = dis.readInt();
		for(; type != TYPE_NULL; type = dis.readInt()) {
			//System.out.println(count++);
			Integer id = new Integer(dis.readInt());
			_Object o = (_Object)map.get(id);
			if(o == null) {
				o = newObject(type);
				o.id = id.intValue();
				map.put(id, o);

				if(o instanceof MotionlessObject)
					motionlesses.addElement(o);
				if(o instanceof MovingObject)
					movings.addElement(o);
				o.inputAllProperty(map, dis);
				if(o instanceof Humanoid)
					humanoids[getCategory((Humanoid)o)]++;
				else if(o instanceof Building)
					buildings[getCategory((Building)o)]++;
			} else if(o instanceof Humanoid) {
				Humanoid h = (Humanoid)o;
				int old = getCategory(h);
				o.inputAllProperty(map, dis);
				int hot = getCategory(h);
				if(old != hot) {
					humanoids[old]--;
					humanoids[hot]++;
				}
			} else if(o instanceof Building) {
				Building b = (Building)o;
				int old = getCategory(b);
				o.inputAllProperty(map, dis);
				int hot = getCategory(b);
				if(old != hot) {
					buildings[old]--;
					buildings[hot]++;
				}
			} else {
				o.inputAllProperty(map, dis);
			}
		}
	}
}

