
package rescue;

import rescue.Pool.*;
import java.util.*;
import java.awt.*;
import java.awt.image.*;
import java.awt.event.*;
import java.io.*;
import java.net.*;

public class Viewer extends Canvas
{
	static final int HEADER_NULL		= 0x00;
	static final int AK_CONNECT			= 0x10;
	static final int AK_ACKNOWLEDGE		= 0x11;
	static final int KA_CONNECT_OK		= 0x50;
	static final int KA_CONNECT_ERROR	= 0x51;
	static final int KA_SENSE			= 0x52;
	static final int SK_CONNECT			= 0x20;
	static final int SK_ACKNOWLEDGE		= 0x21;
	static final int SK_UPDATE			= 0x22;
	static final int KS_CONNECT_OK		= 0x60;
	static final int KS_CONNECT_ERROR	= 0x61;
	static final int KS_COMMANDS		= 0x62;
	static final int KS_UPDATE			= 0x63;
	static final int ZK_CONNECT			= 0x4F;
	static final int KZ_DATA			= 0x0F;
	static final int VK_CONNECT			= 0x38;
	static final int VK_ACKNOWLEDGE		= 0x21;
	static final int KV_CONNECT_OK		= 0x60;
	static final int KV_CONNECT_ERROR	= 0x61;
	static final int KV_UPDATE			= 0x63;

	//JDK12//protected BufferedImage _image;
	/*JDK11*/protected Image _image;
	protected int _width = 600;
	protected int _height = 600;
	protected int _xbase = 0;
	protected int _ybase = 0;
	protected double _ratio = 0.3333;
	protected int _x(int x) {
		return (int)(x * _ratio + _xbase);
	}
	protected int _y(int y) {
		return _height - (int)(y * _ratio + _ybase);
	}
	
	protected void error() {
		System.out.println("error!!");
		System.exit(1);
	}
	
	public Viewer() {
	}
	
	LongUDPSocket _socket;
	public void loop(InetAddress host, int port) {
		try {
			_socket = new LongUDPSocket();
			ByteArrayOutputStream baos = new ByteArrayOutputStream();
			DataOutputStream dos = new DataOutputStream(baos);
			dos.writeInt(VK_CONNECT);
			dos.writeInt(-1);
			dos.writeInt(0);
			dos.writeInt(HEADER_NULL);
			dos.close();
			byte[] output = baos.toByteArray();
			_socket.send(output, host, port);
			
			for(;;) {
				DataInputStream dis = new DataInputStream(_socket.receive());
				//System.out.println("receive packet");
				parse(dis, _socket.getAddress(), _socket.getPort());
				dis.close();
			}
		} catch(IOException e) {
			e.printStackTrace();
		}
	}

	int _time = -1;
	Pool _pool = new Pool();
	void parse(DataInputStream dis, InetAddress address, int port) {
		try {
			boolean updated = false;
			int header = dis.readInt();
			for(; header != HEADER_NULL; header = dis.readInt()) {
				//System.out.println("received = " + header);
				int remainderToNextHeader = dis.readInt();
				switch(header) {
				case KV_CONNECT_OK:
					{
						ByteArrayOutputStream baos = new ByteArrayOutputStream();
						DataOutputStream dos = new DataOutputStream(baos);
						dos.writeInt(VK_ACKNOWLEDGE);
						dos.writeInt(-1);
						dos.writeInt(HEADER_NULL);
						dos.close();
						byte[] output = baos.toByteArray();
						_socket.send(output, address, port);
					}
					_pool.restructure(dis);
					updated = true;
					{
						int x0 = Integer.MAX_VALUE, x1 = Integer.MIN_VALUE;
						int y0 = Integer.MAX_VALUE, y1 = Integer.MIN_VALUE;
						Enumeration e = _pool.map.elements();
						while(e.hasMoreElements()) {
							_Object o = (_Object)e.nextElement();
							if(o instanceof PointObject) {
								PointObject n = (PointObject)o;
								if(x0 > n.x)
									x0 = n.x;
								if(x1 < n.x)
									x1 = n.x;
								if(y0 > n.y)
									y0 = n.y;
								if(y1 < n.y)
									y1 = n.y;
							}
						}
						int xw = x1 - x0;
						int yw = y1 - y0;
						int gap = 100;
						double ratiox = (double)(_width - gap) / xw;
						double ratioy = (double)(_height - gap) / yw;
						_ratio = (ratiox > ratioy) ? ratioy : ratiox;
						_xbase = (int)(gap/2 - x0 * _ratio);
						_ybase = (int)(gap/2 - y0 * _ratio);
						//System.out.println(_ratio);
					}
					break;
				case KV_UPDATE:
					_time = dis.readInt();
					_pool.restructure(dis);
					updated = true;
					break;
				default:
					dis.skipBytes(remainderToNextHeader);
					break;
				}
			}
			if(updated) {
				if(_image != null) {
					_paint(_image.getGraphics());
				}
				repaint();
			}
		} catch(IOException e) {
			e.printStackTrace();
		}
	}
	private static Color _blend(Color c1, Color c2, double ratio) {
		int r1 = c1.getRed();
		int g1 = c1.getGreen();
		int b1 = c1.getBlue();
		int r2 = c2.getRed();
		int g2 = c2.getGreen();
		int b2 = c2.getBlue();

		if(ratio < 0.0)
			ratio = 0;
		else if(ratio > 1.0)
			ratio = 1.0;

		int r = (int)(r1 * ratio + r2 * (1.0 - ratio));
		int g = (int)(g1 * ratio + g2 * (1.0 - ratio));
		int b = (int)(b1 * ratio + b2 * (1.0 - ratio));
		return new Color(r, g, b);
	}
	private static final Color _ground = new Color(0, 0x50, 0);
	private void _paint(Graphics g) {
		//JDK12//Graphics2D g2 = null;
		//JDK12//if(g instanceof Graphics2D) {
			//JDK12//g2 = (Graphics2D)g;
			//JDK12//g2.setStroke(new BasicStroke());
		//JDK12//}
		g.setColor(_ground);
		g.fillRect(0, 0, _width, _height);
		
		g.setColor(Color.black);
		g.drawLine(-1000000, 0, +1000000, 0);
		g.drawLine(0, -1000000, 0, +1000000);

		Enumeration e = _pool.motionlesses.elements();
		while(e.hasMoreElements()) {
			_Object o = (_Object)e.nextElement();
			if(o instanceof Building) {
				Building b = (Building)o;
				Color color;
				if(b instanceof FireStation) {
					color = Color.blue;
				} else if(b instanceof AmbulanceCenter) {
					color = Color.white;
				} else if(b instanceof PoliceOffice) {
					color = Color.yellow;
				} else if(b instanceof Refuge) {
					color = Color.cyan;
				} else {
					color = Color.green;
				}
				Color base;
				switch(b.fieryness) {
				case 1:
					base = Color.yellow;
					break;
				case 2:
					base = Color.red;
					break;
				case 3:
					base = Color.pink;
					break;
				case 4:
					base = Color.cyan;
					break;
				case 5:
					base = Color.blue;
					break;
				default:
					base = Color.darkGray;
					break;
				case 0:
					if(b.ignition != 0)
						base = Color.yellow;
					else
						base = _blend(Color.green, Color.black, 0.5);
					break;
				}
				
				// draw entrances
				_Object node = (_Object)_pool.map.get(b.entrance);
				if(node instanceof PointObject) {
					PointObject po = (PointObject)node;
					g.setColor(Color.blue);
					g.drawLine(_x(b.x), _y(b.y), _x(po.x), _y(po.y));
				}
				// draw inner box
				g.setColor(base);
				g.fillRect(_x(b.x)-3, _y(b.y)-3, 6, 6);
				// draw outer box
				g.setColor(_blend(Color.black, color, (double)b.brokenness / 100));
				g.drawRect(_x(b.x)-3, _y(b.y)-3, 6, 6);
			} else if(o instanceof Road) {
				Road r = (Road)o;
				_Object head = (_Object)_pool.map.get(r.head);
				_Object tail = (_Object)_pool.map.get(r.tail);
				if(head instanceof PointObject && tail instanceof PointObject) {
					PointObject h = (PointObject)head;
					PointObject t = (PointObject)tail;
					g.setColor(_blend(Color.black, Color.white, (double)r.block/r.width));
					//JDK12//if(g2 != null) {
						//JDK12//g2.setStroke(new BasicStroke((float)r.width / 2000));
					//JDK12//}
					g.drawLine(_x(h.x), _y(h.y), _x(t.x), _y(t.y));
					g.setColor(Color.black);
					g.fillOval(_x(h.x), _y(h.y), 1, 1);
					g.fillOval(_x(t.x), _y(t.y), 1, 1);
					//JDK12//if(g2 != null) {
						//JDK12//g2.setStroke(new BasicStroke());
					//JDK12//}
				}
			}
		}
		e = _pool.movings.elements();
		while(e.hasMoreElements()) {
			_Object o = (_Object)e.nextElement();
			if(o instanceof Humanoid) {
				Humanoid n = (Humanoid)o;
				_Object position = (_Object)_pool.map.get(n.position);
				int x = -1;
				int y = -1;
				if(position instanceof PointObject) {
					PointObject p = (PointObject)position;
					x = p.x;
					y = p.y;
				} else if(position instanceof Edge) {
					Edge r = (Edge)position;
					_Object head = (_Object)_pool.map.get(r.head);
					_Object tail = (_Object)_pool.map.get(r.tail);
					if(head instanceof PointObject && tail instanceof PointObject) {
						PointObject h = (PointObject)head;
						PointObject t = (PointObject)tail;
						int tx = t.x - h.x;
						int ty = t.y - h.y;
						double ratio = (double)n.positionExtra / r.length;
						x = (int)(h.x + tx * ratio);
						y = (int)(h.y + ty * ratio);
					}
				}
				if(x != -1) {
					Color color;
					if(n instanceof FireCompany) {
						color = Color.cyan;
					} else if(n instanceof AmbulanceTeam) {
						color = Color.white;
					} else if(n instanceof PoliceForce) {
						color = Color.yellow;
					} else {
						color = Color.green;
					}
					Color grade = Color.black;
					if(n.hp > 0)
						grade = _blend(color, Color.red, (double)n.hp/n.hpMax);
					//grade = _blend(Color.red, grade, (double)n.damage/n.hp);
					/*g.setColor(color);
					g.fillOval(_x(x)-3, _y(y)-3, 6, 6);*/
					g.setColor(grade);
					g.fillOval(_x(x)-2, _y(y)-2, 5, 5);
					//System.out.println(x + ", " + y);
				}
			}
		}
		
		g.setColor(Color.white);
		String text = 
			"time=" + _time
			+ "    livings:" + _pool.livings() + "/deads:" + _pool.deads()
			+ "    nonburned:" + _pool.nonburned() + "/burning:" + _pool.burning()
				+ "/extinguished:" + _pool.extinguished() + "/burned-out:" + _pool.burnedout()
			+ "    " + _pool.map.size() + " objects"
			+ "    screen width = " + _width / _ratio / 1000 + " m";
		
		g.drawString(text, 0, g.getFont().getSize());
	}
	public void update(Graphics g) {
		paint(g);
	}
	public void paint(Graphics g) {
		if(_image == null) {
			//JDK12//_image = new BufferedImage(_width, _height, BufferedImage.TYPE_INT_BGR);
			/*JDK11*/_image = createImage(_width, _height);
			if(_image != null)
				_paint(_image.getGraphics());
		}
		if(_image == null)
			_paint(g);
		else
			g.drawImage(_image, 0, 0, this);
	}

	public Dimension getStandardSize() {
		return new Dimension(_width, _height);
	}
	public Dimension getMaximumSize() {
		return getStandardSize();
	}
	public Dimension getPreferredSize() {
		return getStandardSize();
	}
	public Dimension getMinimumSize() {
		return getStandardSize();
	}
}
