/* Copyright (C) 2007 HighWide. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE HIGHWIDE "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE HIGHWIDE BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * -----
 * {\tgEFA"The modified BSD license"ɏ܂B
 */
package jp.highwide.resourcechecker.builder;

import java.util.ArrayList;

import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;

/**
 * \[X`FbJ[̃lC`[NXB
 */
public class ResourceCheckerNature implements IProjectNature {
	/** lC`[ID */
	public static final String NATURE_ID = "jp.highwide.resourcechecker.resourceCheckerNature";

	private IProject project;

	/**
	 * r_[o^B
	 * @see org.eclipse.core.resources.IProjectNature#configure()
	 */
	public void configure() throws CoreException {
		IProjectDescription description = project.getDescription();
		ICommand[] commands = description.getBuildSpec();
		ArrayList<ICommand> commandList = new ArrayList<ICommand>();
		for (ICommand command : commands) {
			if (command.getBuilderName().equals(ResourceCheckerBuilder.BUILDER_ID)) {
				return;
			}
			commandList.add(command);
		}

		ICommand command = description.newCommand();
		command.setBuilderName(ResourceCheckerBuilder.BUILDER_ID);
		commandList.add(command);
		description.setBuildSpec(commandList.toArray(new ICommand[0]));
		project.setDescription(description, null);
	}

	/**
	 * r_[o^B
	 * @see org.eclipse.core.resources.IProjectNature#deconfigure()
	 */
	public void deconfigure() throws CoreException {
		IProjectDescription description = project.getDescription();
		ICommand[] commands = description.getBuildSpec();
		ArrayList<ICommand> commandList = new ArrayList<ICommand>();
		for (ICommand command : commands) {
			if (!command.getBuilderName().equals(ResourceCheckerBuilder.BUILDER_ID)) {
				commandList.add(command);
			}
		}

		description.setBuildSpec(commandList.toArray(new ICommand[0]));
		project.setDescription(description, null);
	}

	/**
	 * vWFNgԋpB
	 * @see org.eclipse.core.resources.IProjectNature#getProject()
	 */
	public IProject getProject() {
		return project;
	}

	/**
	 * vWFNgݒ肷B
	 * @see org.eclipse.core.resources.IProjectNature#setProject(org.eclipse.core.resources.IProject)
	 */
	public void setProject(IProject project) {
		this.project = project;
	}

}
