/* Copyright (C) 2007 HighWide. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE HIGHWIDE "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE HIGHWIDE BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * -----
 * {\tgEFA"The modified BSD license"ɏ܂B
 */
package jp.highwide.resourcechecker.dialog;

import java.util.regex.Pattern;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.dialogs.ResourceListSelectionDialog;
import org.eclipse.ui.ide.IDE;

/**
 * K\`Eclipse\[XInputDialogNXB
 */
public class InputResourceDialog extends InputDialog {
	private IContainer initialContainer = null;

	/**
	 * RXgN^B
	 * @param parentShell eShell
	 * @param dialogTitle _CAÕ^Cg
	 * @param dialogMessage _CAÕbZ[W
	 * @param initialValue l
	 * @param initialContainer x[XƂȂReiB̃Rei艺̓tB^B
	 */
	public InputResourceDialog(Shell parentShell,
			String dialogTitle,
			String dialogMessage,
			String initialValue,
			IContainer initialContainer) {
		super(parentShell,
				dialogTitle,
				dialogMessage,
				initialValue,
				new RegexInputValidator());
		this.initialContainer = initialContainer;
	}

	/**
	 * K\̌``FbNValidatorNXB
	 */
	static class RegexInputValidator implements IInputValidator {
		/**
		 * K\̌``FbNB
		 * @param newText `FbNΏۂ̕
		 * @return null̏ꍇ͐(=K\)Bُ̏ꍇ̓G[bZ[WԋpB
		 * @see org.eclipse.jface.dialogs.IInputValidator#isValid(java.lang.String)
		 */
		public String isValid(String newText) {
			try {
				Pattern.compile(newText);
			} catch (RuntimeException e) {
				return "[͒lsł] K\ŋLڂĂB";
			}
			return null;
		}
	}


	/**
	 * InputDialogDialogAreax[XɁAtH_ƃt@CIłc[o[쐬B
	 * @param parent eComposite
	 * @return DialogAreaComposite
	 * @see org.eclipse.jface.dialogs.Dialog#createDialogArea(org.eclipse.swt.widgets.Composite)
	 */
	@Override
	protected Control createDialogArea(Composite parent) {
		ToolBar toolbar = new ToolBar(parent, SWT.FLAT | SWT.RIGHT);
		ToolItem item = new ToolItem(toolbar, SWT.PUSH);
		Image folderImage = PlatformUI.getWorkbench().getSharedImages()
				.getImage(IDE.SharedImages.IMG_OBJ_PROJECT);
		item.setImage(folderImage);
		item.setText("tH_I");
		item.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				selectContainerAction();
			}
		});
		if (initialContainer != null) {
			item = new ToolItem(toolbar, SWT.PUSH);
			Image fileImage = PlatformUI.getWorkbench().getSharedImages()
					.getImage(ISharedImages.IMG_OBJ_FILE);
			item.setImage(fileImage);
			item.setText("t@CI");
			item.addSelectionListener(new SelectionAdapter() {
				@Override
				public void widgetSelected(SelectionEvent e) {
					selectFileAction();
				}
			});
		}
		return (Composite) super.createDialogArea(parent);
	}

	/**
	 * utH_IvsꂽƂɓ삷郁\bhB<p>
	 * ContainerSelectionDialog\AReizSĂK\͒lɐݒ肷B
	 */
	private void selectContainerAction() {
		ContainerSelectionDialog input = new ContainerSelectionDialog(getShell(),
				initialContainer,
				false,
				null);
		int code = input.open();
		if (code == InputDialog.CANCEL) {
			return;
		}
		Object[] result = input.getResult();
		String fullPath = "";
		for (Object object : result) {
			if (object instanceof IPath) {
				fullPath = ((IPath) object).toPortableString();
				break;
			}
		}
		getText().setText(fullPath + "/.*");
	}

	/**
	 * ut@CIvsꂽƂɓ삷郁\bhB<p>
	 * ResourceListSelectionDialog\Aw肳ꂽ\[X͒lɐݒ肷B
	 */
	private void selectFileAction() {
		ResourceListSelectionDialog input = new ResourceListSelectionDialog(getShell(),
				initialContainer,
				IResource.FILE);
		int code = input.open();
		if (code == InputDialog.CANCEL) {
			return;
		}
		Object[] result = input.getResult();
		String fullPath = "";
		for (Object object : result) {
			if (object instanceof IResource) {
				fullPath = ((IResource) object).getFullPath().toString();
				break;
			}
		}
		getText().setText(fullPath);
	}
}
