/*
 * Copyright 2007 Kickmogu Co. Ltd. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package com.kickmogu.event
{
	import flash.events.Event;

	public class DataUpdateEvent extends Event
	{
		public static const EVENT_TYPE:String = "dataUpdate";
		
		// enable プロパティの状態を保持するパブリック変数を定義する
		public var updateType:String;
		public var updateData:Object;

		// パブリックコンストラクタ
		public function DataUpdateEvent(type:String,
			updtType:String, updtData:Object = null) {
			// スーパークラスのコンストラクタを呼び出す
			super(type);
			// 新しいプロパティを設定する
			this.updateType = updtType;
			this.updateData = updtData;
		}
		
		// 継承した clone() メソッドをオーバーライドする
		override public function clone():Event {
			return new DataUpdateEvent(type, updateType);
		}
	}
}