/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.ridual.r2.db.bean.project;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import jp.co.nri.ridual.r2.common.uri.URIOperator;
import jp.co.nri.ridual.r2.db.bean.AbstractNodable;
import jp.co.nri.ridual.r2.db.bean.project.AbstractProjectNodable;
import jp.co.nri.ridual.r2.db.bean.project.ContentsVariationBean;
import jp.co.nri.ridual.r2.db.dao.ParameterPatternDAO;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ContentsBean
extends AbstractProjectNodable {
    public static final String HQL_QUERY_NAME_FIND_BY_URL = "contents.findByURL";
    public static final String HQL_QUERY_NAME_COUNT_RELATION_BY_HISTORY_ID = "contents.countRelationByHistoryId";
    public static final String HQL_QUERY_NAME_FIND_CONTACT = "contents.findContact";
    public static final String HQL_QUERY_NAME_COUNT_CONTACT_VALUE = "contents.countContactValue";
    public static final String LIKE_MAILTO = "mailto:%";
    public static final String HQL_QUERY_NAME_FIND_BY_RELATION_TYPE = "contents.findByRelationType";
    private static final String ELEMENT_NAME_ROOT = "CONTENTS";
    private static final String ELEMENT_NAME_URL = "URL";
    private static final String ROOT_PATH = "/";
    private Integer id;
    private Integer historyId;
    private String scheme = "";
    private String host = "";
    private int port = -1;
    private String path = "";
    private String extension = "";
    private Boolean isInner;

    public Node buildNode(Integer projectId, int mode, Document doc) {
        Element elm = doc.createElement(ELEMENT_NAME_ROOT);
        try {
            super.buildTextElement(elm, ELEMENT_NAME_URL, this.buildURLString());
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return elm;
    }

    public AbstractNodable[] loadChild(Integer projectId, int mode) throws Throwable {
        switch (mode) {
            case 17: {
                return ParameterPatternDAO.instance.findByContentsId(projectId, this.id).toArray(new AbstractNodable[0]);
            }
        }
        return null;
    }

    public URL buildURL4Auth() throws MalformedURLException {
        return URIOperator.instance.buildURL4Auth(this.emptyIsNull(this.scheme), this.emptyIsNull(this.host), this.port);
    }

    public URL buildURLNoAnchor(ContentsVariationBean variation) throws MalformedURLException, URISyntaxException {
        String scm = this.emptyIsNull(this.scheme);
        if (scm == null) {
            return null;
        }
        String wpath = this.emptyIsNull(this.path);
        if (wpath != null) {
            wpath = URIOperator.instance.toURIPath(wpath);
        }
        return new URI(scm, this.emptyIsNull(variation.getUrlUserInfo()), this.emptyIsNull(this.host), this.port, wpath, this.emptyIsNull(variation.getUrlQuery()), null).toURL();
    }

    public URL buildURLNoQuery(ContentsVariationBean variation) throws MalformedURLException, URISyntaxException {
        String scm = this.emptyIsNull(this.scheme);
        if (scm == null) {
            return null;
        }
        String wpath = this.emptyIsNull(this.path);
        if (wpath != null) {
            wpath = URIOperator.instance.toURIPath(wpath);
        }
        return new URI(scm, this.emptyIsNull(variation.getUrlUserInfo()), this.emptyIsNull(this.host), this.port, wpath, null, null).toURL();
    }

    public URL buildURL(ContentsVariationBean variation) throws MalformedURLException, URISyntaxException {
        String scm = this.emptyIsNull(this.scheme);
        if (scm == null) {
            return null;
        }
        String wpath = this.emptyIsNull(this.path);
        if (wpath != null) {
            wpath = URIOperator.instance.toURIPath(wpath);
        }
        return new URI(scm, this.emptyIsNull(variation.getUrlUserInfo()), this.emptyIsNull(this.host), this.port, wpath, this.emptyIsNull(variation.getUrlQuery()), null).toURL();
    }

    public URL buildURL() throws MalformedURLException {
        String scm = this.getScheme();
        return scm == null ? null : new URL(scm, this.getHost(), this.getPort(), this.getPath());
    }

    public String buildURLString(ContentsVariationBean variation) throws MalformedURLException, URISyntaxException {
        URL url = this.buildURL(variation);
        return url == null ? this.getPath() : url.toString();
    }

    public String buildURLString() throws MalformedURLException {
        URL url = this.buildURL();
        return url == null ? this.getPath() : url.toString();
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Integer getHistoryId() {
        return this.historyId;
    }

    public void setHistoryId(Integer historyId) {
        this.historyId = historyId;
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme == null ? "" : scheme;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host == null ? "" : host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path == null ? "" : path;
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public Boolean getIsInner() {
        return this.isInner;
    }

    public void setIsInner(Boolean isInner) {
        this.isInner = isInner;
    }

    public URL setURL(String str) {
        try {
            return this.setURL(new URL(str));
        }
        catch (Throwable t) {
            this.path = str;
            this.isInner = Boolean.FALSE;
            return null;
        }
    }

    public URL setURL(URL parent, String str) {
        try {
            return this.setURL(new URL(parent, str));
        }
        catch (Throwable t) {
            this.path = str;
            this.isInner = Boolean.FALSE;
            return null;
        }
    }

    private URL setURL(URL url) throws MalformedURLException, URISyntaxException {
        URL u = URIOperator.instance.normalize(url);
        this.scheme = u.getProtocol();
        this.host = u.getHost();
        this.port = u.getPort();
        String pathstr = u.getPath();
        this.path = pathstr == null || pathstr.length() > 0 ? pathstr : ROOT_PATH;
        this.extension = URIOperator.instance.extractExtensionFromPath(this.path);
        return u;
    }

    private String emptyIsNull(String str) {
        return str.length() > 0 ? str : null;
    }
}

