/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.ridual.r2.db.bean.project;

import jp.co.nri.ridual.r2.db.bean.AbstractNodable;
import jp.co.nri.ridual.r2.db.bean.project.AbstractProjectNodable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class HTMLExistsContainer
extends AbstractProjectNodable {
    private static final String ELEMENT_NAME_ROOT = "EXISTS";
    private static final String ELEMENT_NAME_SCRIPT = "SCRIPT";
    private static final String ELEMENT_NAME_STYLE = "STYLE";
    private static final String ELEMENT_NAME_FRAMESET = "FRAMESET";
    private static final String FILE = "FILE";
    private static final String TAG = "TAG";
    private static final String BOTH = "BOTH";
    private final boolean scriptFile;
    private final boolean scriptTag;
    private final boolean styleFile;
    private final boolean styleTag;
    private final boolean framesetTag;

    public HTMLExistsContainer(int scriptFile, int scriptTag, int styleFile, int styleTag, int framesetTag) {
        this.scriptFile = scriptFile > 0;
        this.scriptTag = scriptTag - scriptFile > 0;
        this.styleFile = styleFile > 0;
        this.styleTag = styleTag > 0;
        this.framesetTag = framesetTag > 0;
    }

    public Node buildNode(Integer projectId, int mode, Document doc) {
        switch (mode) {
            case 3: {
                Element elm = doc.createElement(ELEMENT_NAME_ROOT);
                super.buildTextElement(elm, ELEMENT_NAME_SCRIPT, this.getValue(this.scriptFile, this.scriptTag));
                super.buildTextElement(elm, ELEMENT_NAME_STYLE, this.getValue(this.styleFile, this.styleTag));
                if (this.framesetTag) {
                    super.buildTextElement(elm, ELEMENT_NAME_FRAMESET, TAG);
                }
                return elm;
            }
        }
        return null;
    }

    public AbstractNodable[] loadChild(Integer projectId, int mode) throws Throwable {
        return null;
    }

    private String getValue(boolean file, boolean tag) {
        if (file) {
            return tag ? BOTH : FILE;
        }
        return tag ? TAG : null;
    }
}

