/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.ridual.r2.db.dao;

import java.util.List;
import jp.co.nri.ridual.r2.db.bean.project.ContentsSupplementBean;
import jp.co.nri.ridual.r2.db.dao.DefaultProjectDAO;
import jp.co.nri.ridual.r2.db.dao.RetryOverException;
import jp.co.nri.ridual.r2.db.dao.RidualServerLogDAO;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;

public class ContentsSupplementDAO
extends DefaultProjectDAO {
    public static final ContentsSupplementDAO instance = new ContentsSupplementDAO();

    private ContentsSupplementDAO() {
        super(0);
    }

    public void save(Integer projectId, Integer contentsId, Integer variationId, String category, String name, String value) throws Throwable {
        ContentsSupplementBean supplement = new ContentsSupplementBean();
        supplement.setContentsId(contentsId);
        supplement.setVariationId(variationId);
        supplement.setCategory(category);
        supplement.setName(name);
        supplement.setValue(value);
        this.save(projectId, supplement);
    }

    public void save(Integer projectId, Integer contentsId, Integer variationId, String category, String name, Integer value) throws Throwable {
        ContentsSupplementBean supplement = new ContentsSupplementBean();
        supplement.setContentsId(contentsId);
        supplement.setVariationId(variationId);
        supplement.setCategory(category);
        supplement.setName(name);
        supplement.setInteger(value);
        this.save(projectId, supplement);
    }

    private void save(Integer projectId, ContentsSupplementBean supplement) throws Throwable {
        try {
            super.save(projectId, supplement);
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.Contents.Supplement", e);
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveOrUpdateByName(Integer projectId, Integer contentsId, Integer variationId, String category, String name, Integer value) throws Throwable {
        try {
            SessionFactory factory = super.getSessionFactory(projectId);
            RetryOverException roe = new RetryOverException(factory);
            Session session = factory.openSession();
            while (true) {
                try {
                    try {
                        Transaction transaction = session.beginTransaction();
                        try {
                            ContentsSupplementBean bean = (ContentsSupplementBean)super.findUniqueByName(projectId, "contentsSupplement.findByName", new Object[]{variationId, name});
                            if (bean == null) {
                                bean = new ContentsSupplementBean();
                                bean.setContentsId(contentsId);
                                bean.setVariationId(variationId);
                                bean.setCategory(category);
                                bean.setName(name);
                                bean.setInteger(value);
                                session.save((Object)bean);
                            } else {
                                bean.setInteger(value);
                                session.update((Object)bean);
                            }
                            transaction.commit();
                            Object var12_15 = null;
                        }
                        catch (Throwable e) {
                            transaction.rollback();
                            throw e;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var12_16 = null;
                        session.close();
                        throw throwable;
                    }
                    session.close();
                    return;
                }
                catch (Throwable t) {
                    session = roe.retry(t);
                    continue;
                }
                break;
            }
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.Contents.Supplement", e);
            throw e;
        }
    }

    public List findForReportPages(Integer projectId, Integer variationId) throws Throwable {
        try {
            return super.findByName(projectId, "contentsSupplement.findForReportPages", variationId);
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.Contents.Supplement", e);
            throw e;
        }
    }

    public List findByName(Integer projectId, Integer variationId, String name) throws Throwable {
        try {
            return super.findByName(projectId, "contentsSupplement.findByName", new Object[]{variationId, name});
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.Contents.Supplement", e);
            throw e;
        }
    }

    public ContentsSupplementBean findUniqueByName(Integer projectId, Integer variationId, String name) throws Throwable {
        try {
            return (ContentsSupplementBean)super.findUniqueByName(projectId, "contentsSupplement.findByName", new Object[]{variationId, name});
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.Contents.Supplement", e);
            throw e;
        }
    }

    public List findLikeName(Integer projectId, Integer variationId, String likeName) throws Throwable {
        try {
            return super.findByName(projectId, "contentsSupplement.findLikeName", new Object[]{variationId, likeName});
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.Contents.Supplement", e);
            throw e;
        }
    }

    public List findByVariationId(Integer projectId, Integer variationId) throws Throwable {
        try {
            return super.findByName(projectId, "contentsSupplement.findByVariationId", variationId);
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.Contents.Supplement", e);
            throw e;
        }
    }

    public void deleteByVariationId(Integer projectId, Integer variationId) throws Throwable {
        try {
            super.updateByName(projectId, "contentsSupplement.deleteByVariationId", variationId);
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.Contents.Supplement", e);
            throw e;
        }
    }
}

