/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.ridual.r2.db.dao;

import java.util.Vector;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.exception.GenericJDBCException;

class RetryOverException
extends Exception {
    private static int RETRY_COUNT = 16;
    private final SessionFactory factory;
    private int count = 0;
    private Vector throwables = null;

    public RetryOverException(SessionFactory factory) {
        this.factory = factory;
    }

    public Session retry(Throwable t) throws Throwable {
        String state;
        if (this.throwables == null) {
            this.throwables = new Vector();
        }
        this.throwables.add(t);
        ++this.count;
        if (RETRY_COUNT <= this.count) {
            throw this;
        }
        if (t instanceof GenericJDBCException && (state = ((GenericJDBCException)t).getSQLState()) != null) {
            if (state.equals("40001") || state.equals("HY000")) {
                return this.factory.openSession();
            }
            if (state.equals("08S01") || state.equals("40003")) {
                return this.factory.openSession();
            }
        }
        throw t;
    }
}

