/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.ridual.r2.db.dao;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import jp.co.nri.ridual.r2.common.messageformat.MessageFormatter;
import jp.co.nri.ridual.r2.common.pattern.Patterns;
import jp.co.nri.ridual.r2.db.bean.common.log.RidualServerLogBean;
import jp.co.nri.ridual.r2.db.bean.common.log.RidualServerLogSupplementBean;
import jp.co.nri.ridual.r2.db.dao.DefaultCommonDAO;
import jp.co.nri.ridual.r2.systemlog.SystemLog;

public class RidualServerLogDAO
extends DefaultCommonDAO {
    public static final String METHOD_QUEUE = "QUEUE";
    public static final String METHOD_DB_PROJECT = "DB.Project";
    public static final String METHOD_DB_ROBOTS = "DB.Robots";
    public static final String METHOD_DB_SITE = "DB.Site";
    public static final String METHOD_DB_HISTORY = "DB.History";
    public static final String METHOD_DB_PROJECT_LOG = "DB.ProjectLog";
    public static final String METHOD_DB_PROJECT_LOG_SUPPLEMENT = "DB.ProjectLog.Supplement";
    public static final String METHOD_DB_DIRECTORY_MAP = "DB.DirectoryMap";
    public static final String METHOD_DB_LOCAL_HISTORY = "DB.LocalHistory";
    public static final String METHOD_DB_LOCAL_FILE = "DB.LocalFile";
    public static final String METHOD_DB_CONTENTS = "DB.Contents";
    public static final String METHOD_DB_CONTENTS_SUPPLEMENT = "DB.Contents.Supplement";
    public static final String METHOD_DB_CONTENTS_AND_VARIATION = "DB.Contents&Variation";
    public static final String METHOD_DB_CONTENTS_RELATION = "DB.Contents.Relation";
    public static final String METHOD_WEB_CAPTURE_QUEUE = "DB.WebCaptureQueue";
    public static final String METHOD_DB_CONTENTS_VARIATION = "DB.Contents.Variation";
    public static final String METHOD_DB_RIDUAL_SERVER_CONFIG = "DB.RidualServerConfig";
    private static final String METHOD_DB_RIDUAL_SERVER_LOG = "DB.RidualServerLog";
    private static final String METHOD_DB_RIDUAL_SERVER_LOG_SUPPLEMENT = "DB.RidualServerLog.Supplement";
    public static final String METHOD_DB_HTML_TAG = "DB.HTML-nodes";
    public static final String METHOD_DB_CSS_NODES = "DB.CSS-nodes";
    public static final String METHOD_DB_CSS_NODE_SUPPLEMENT = "DB.CSS-node.Supplement";
    public static final String METHOD_DB_CSS_SELECTOR = "DB.CSS-selector";
    public static final String METHOD_DB_CSS_CONDITION = "DB.CSS-condition";
    public static final String METHOD_DB_IMAGE = "DB.Image";
    public static final String METHOD_DB_RATING = "DB.Rating";
    public static final String METHOD_DB_RATING_PROFILE = "DB.RatingProfile";
    public static final String METHOD_DB_RATING_PROFILE_ITEMS = "DB.RatingProfileItems";
    public static final String METHOD_DB_PARAMETER_PATTERN = "DB.ParameterPattern";
    public static final String METHOD_ROBO = "Robo.*";
    public static final String METHOD_ANALYZEROBO = "Robo.AnalyzeRobo";
    public static final String METHOD_SENDMAILROBO = "Robo.SendMailRobo";
    public static final String METHOD_AFTERANALYZEROBO = "Robo.AfterAnalyzeRobo";
    public static final String METHOD_TRANSFORMROBO = "Robo.TransformRobo";
    public static final String METHOD_MULTITRANSFORMROBO = "Robo.MultiTransformRobo";
    public static final String METHOD_SENDMAILROBO_STANDBY = "Robo.SendMailRobo.Standby";
    public static final String METHOD_MAP_TRANSFORMROBO = "Robo.MapTransformRobo";
    public static final String METHOD_STANDALONE_TRANSFORMROBO = "Robo.StandaloneTransformRobo";
    public static final String METHOD_ANALYZEQUEUE_RECOVERROBO = "Robo.AnalyzeQueueRecoverRobo";
    public static final String METHOD_DROP_HISTORY_SCHEMA_ROBO = "Robo.DropHistorySchemaRobo";
    public static final String METHOD_BUILDREPORT_RECOVERROBO = "Robo.BuildReportRecoverRobo";
    public static final String METHOD_RECHECK_OUTLINK_RECOVERROBO = "Robo.RecheckOutLinkRecoverRobo";
    public static final String METHOD_REFRESH_THUMBNAIL_RECOVERROBO = "Robo.RefreshThumbnailRecoverRobo";
    public static final String METHOD_RECKECK_OUTLINK_ROBO = "Robo.RecheckOutLinkRobo";
    public static final String METHOD_REFRESH_THUMBNAIL_ROBO = "Robo.RefreshThumbnailRobo";
    public static final String METHOD_ANALYZEROBO_CONTROLLER = "AnalyzeRoboController";
    public static final String METHOD_RECOVERROBO_CONTROLLER = "RecoverRoboController";
    public static final String METHOD_WEBCAPTUREROBO = "WebCaptureRobo";
    public static final String METHOD_FILELISTMAKER = "Lister";
    public static final String METHOD_QUEUE_FACTORY = "QueueFactory";
    public static final String METHOD_SERVLET_RIDUAL_SERVER_CONFIG = "Servlet.RidualServerConfig";
    public static final String METHOD_SERVLET_SAVE_RIDUAL_SERVER_CONFIG = "Servlet.SaveRidualServerConfig";
    public static final String METHOD_SERVLET_RIDUAL_SERVER_LOG = "Servlet.RidualServerLog";
    public static final String METHOD_SERVLET_ANALYZE = "Servlet.Analyze";
    public static final String METHOD_SERVLET_ANALYZE_STARTUP = "Servlet.AnalyzeStartup";
    public static final String METHOD_SERVLET_EXPORT_COMMON_SCHEMA = "Servlet.ExportCommonSchema";
    public static final String METHOD_SERVLET_ANALYZE_SITE_VIEW = "Servlet.AnalyzeSiteView";
    public static final String METHOD_SERVLET_ANALYZE_REPORT = "Servlet.AnalyzeReport";
    public static final String METHOD_SERVLET_ANALYZE_REPORT_PAGES = "Servlet.AnalyzeReportPages";
    public static final String METHOD_SERVLET_ANALYZE_REPORT_LOST = "Servlet.AnalyzeReportLost";
    public static final String METHOD_SERVLET_ANALYZE_REPORT_OUTER = "Servlet.AnalyzeReportOuter";
    public static final String METHOD_SERVLET_ANALYZE_REPORT_RESOURCE = "Servlet.AnalyzeReportResource";
    public static final String METHOD_SERVLET_ANALYZE_REPORT_ACCESSIBILITY = "Servlet.AnalyzeReportAccessibility";
    public static final String METHOD_SERVLET_ANALYZE_REPORT_STYLE_CSS_DETAIL = "Servlet.AnalyzeReportStyle.CSS.Detail";
    public static final String METHOD_SERVLET_ANALYZE_REPORT_STYLE_CSS_SELECTOR = "Servlet.AnalyzeReportStyle.CSS.Selector";
    public static final String METHOD_SERVLET_REANALYZE = "Servlet.Reanalyze";
    public static final String METHOD_SERVLET_DELETE_HISTORY = "Servlet.DeleteHistory";
    public static final String METHOD_SERVLET_DELETE_SITE_CONFIG = "Servlet.DeleteSiteConfig";
    public static final String METHOD_SERVLET_DELETE_RATING_PROFILE = "Servlet.DeleteRatingProfile";
    public static final String METHOD_SERVLET_VISUAL_MAP = "Servlet.VisualMap";
    public static final String METHOD_SERVLET_ANALYZE_REPORT_PROJECT_LOG = "Servlet.AnalyzeReportProjectLog";
    public static final String METHOD_SERVLET_THUMBNAIL = "Servlet.Thumbnail";
    public static final String METHOD_SERVLET_REFRESH_THUMBNAIL = "Servlet.RefreshThumbnail";
    public static final String METHOD_SERVLET_ANALYZE_REPORT_DETAIL = "Servlet.AnalyzeReportDetail";
    public static final String METHOD_SERVLET_SET_ROBO_COUNT = "Servlet.SetRoboCount";
    public static final String METHOD_SERVLET_REBUILD_HTML = "Servlet.RebuildHTML";
    public static final String METHOD_SERVLET_LOCAL_MAPPING = "Servlet.LocalMapping";
    public static final String METHOD_SERVLET_SET_LOCAL = "Servlet.SetLocal";
    public static final String METHOD_SERVLET_LOCAL_OVERVIEW = "Servlet.LocalOverview";
    public static final String METHOD_SERVLET_LOCAL_PAGES = "Servlet.LocalPages";
    public static final String METHOD_SERVLET_LOCAL_RESOURCES = "Servlet.LocalResources";
    public static final String METHOD_SERVLET_LOCAL_DIFFERENCE = "Servlet.LocalDifference";
    public static final String METHOD_SERVLET_DELETE_LOCAL_HISTORY = "Servlet.DeleteLocalHistory";
    public static final String METHOD_SERVLET_DIALOG_DELETE = "Servlet.Dialog.Delete";
    public static final String METHOD_SERVLET_DIALOG_REBUILD = "Servlet.Dialog.Rebuild";
    public static final String METHOD_SERVLET_DIALOG_DELETE_SITE = "Servlet.Dialog.Delete.Site";
    public static final String METHOD_SERVLET_RATING_PROFILE_CONFIG = "Servlet.RatingProfileConfig";
    public static final String METHOD_SERVLET_RATING_PROFILE_NEW = "Servlet.RatingProfileNew";
    public static final String METHOD_SERVLET_RATING_PROFILE_EDIT = "Servlet.RatingProfileEdit";
    public static final String METHOD_SERVLET_SAVE_RATING_PROFILE = "Servlet.SaveRatingProfile";
    public static final String METHOD_SERVLET_RECHECK = "Servlet.Recheck";
    public static final String METHOD_PROPERTIES_RIDUAL_SERVER_CONFIG = "Properties.RidualServerConfig";
    public static final String METHOD_SERVLET_RELOAD_RESTRICT = "Servlet.ReloadRestrict";
    public static final String METHOD_XSLTVIEW_TRANSFORMERMAP = "XSLTView.TransformerMap";
    public static final String METHOD_RATING_RATINGINFO = "Rating.RatingInfo";
    public static final String METHOD_RESTRICT_RESTRICTCHECKER = "Restrict.RestrictChecker";
    public static final String METHOD_RATING_PRESET_PROFILE = "Rating.PresetProfile";
    private static final RidualServerLogDAO instance = new RidualServerLogDAO();
    private static final String LF = "\n";

    private RidualServerLogDAO() {
        super(0);
    }

    public static RidualServerLogDAO getInstance() {
        return instance;
    }

    public void record(String method, Throwable t) {
        RidualServerLogBean bean = new RidualServerLogBean();
        bean.setMethod(method);
        bean.setCode("none");
        try {
            super.save(bean);
            Integer logId = bean.getId();
            ArrayList<RidualServerLogSupplementBean> supplements = new ArrayList<RidualServerLogSupplementBean>();
            supplements.add(this.buildSupplement(logId, "LocalizedMessage", t.getLocalizedMessage()));
            supplements.add(this.buildSupplement(logId, "Message", t.getMessage()));
            supplements.add(this.buildSupplement(logId, "Class", t.getClass().getName()));
            StringWriter strwriter = new StringWriter();
            t.printStackTrace(new PrintWriter((Writer)strwriter, true));
            supplements.add(this.buildSupplement(logId, "StackTrace", strwriter.toString()));
            super.save(supplements.toArray());
        }
        catch (Throwable e) {
            SystemLog.getInstance().record(e);
            SystemLog.getInstance().record(".... Ridual Server Log");
            SystemLog.getInstance().record(t);
        }
    }

    public void record(String method, String code, Object[] param, Throwable t) {
        RidualServerLogBean bean = new RidualServerLogBean();
        bean.setMethod(method);
        bean.setCode(code);
        bean.setMessage(MessageFormatter.instance.formatRidualServerLogMessage(code, param));
        try {
            super.save(bean);
            if (t != null) {
                Integer logId = bean.getId();
                ArrayList<RidualServerLogSupplementBean> supplements = new ArrayList<RidualServerLogSupplementBean>();
                supplements.add(this.buildSupplement(logId, "LocalizedMessage", t.getLocalizedMessage()));
                supplements.add(this.buildSupplement(logId, "Message", t.getMessage()));
                supplements.add(this.buildSupplement(logId, "Class", t.getClass().getName()));
                StringWriter strwriter = new StringWriter();
                t.printStackTrace(new PrintWriter((Writer)strwriter, true));
                supplements.add(this.buildSupplement(logId, "StackTrace", strwriter.toString()));
                super.save(supplements.toArray());
            }
        }
        catch (Throwable e) {
            SystemLog.getInstance().record(e);
            SystemLog.getInstance().record(".... Ridual Server Log");
            SystemLog.getInstance().record(t);
        }
    }

    private RidualServerLogSupplementBean buildSupplement(Integer logId, String name, String value) {
        RidualServerLogSupplementBean supplement = new RidualServerLogSupplementBean();
        supplement.setLogId(logId);
        supplement.setName(name);
        supplement.setValue(value == null ? null : Patterns.CRLF_PATTERN.matcher(value).replaceAll(LF));
        return supplement;
    }

    public RidualServerLogBean[] findAll() throws Throwable {
        try {
            List list = super.findByName("ridualserverlog.findAll");
            return list == null ? null : list.toArray(new RidualServerLogBean[0]);
        }
        catch (Throwable e) {
            this.record(METHOD_DB_RIDUAL_SERVER_LOG, e);
            throw e;
        }
    }

    public List findSupplementByLogId(Integer id) throws Throwable {
        try {
            return super.findByName("ridualserverlog.supplement.findByLogId", id);
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record(METHOD_DB_RIDUAL_SERVER_LOG_SUPPLEMENT, e);
            throw e;
        }
    }

    public void debug(String str) {
        RidualServerLogBean bean = new RidualServerLogBean();
        bean.setMethod("debug");
        bean.setCode("none");
        try {
            super.save(bean);
            Integer logId = bean.getId();
            ArrayList<RidualServerLogSupplementBean> supplements = new ArrayList<RidualServerLogSupplementBean>();
            supplements.add(this.buildSupplement(logId, "debug", str));
            super.save(supplements.toArray());
        }
        catch (Throwable e) {
            SystemLog.getInstance().record(e);
        }
    }
}

