/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.ridual.r2.filelistmaker;

import java.awt.event.ActionEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.JOptionPane;
import jp.co.nri.ridual.r2.db.bean.common.AnalyzeSiteConfigBean;
import jp.co.nri.ridual.r2.db.bean.common.LocalHistoryBean;
import jp.co.nri.ridual.r2.db.bean.project.DirectoryMapBean;
import jp.co.nri.ridual.r2.db.dao.DirectoryMapDAO;
import jp.co.nri.ridual.r2.db.dao.LocalHistoryDAO;
import jp.co.nri.ridual.r2.filelistmaker.AbstractFileListMakerAction;
import jp.co.nri.ridual.r2.filelistmaker.DirTraceRobo;
import jp.co.nri.ridual.r2.filelistmaker.DirTraceRoboWatchDog;
import jp.co.nri.ridual.r2.filelistmaker.FileListMaker;
import jp.co.nri.ridual.r2.filelistmaker.MappingItem;

class EntryAction
extends AbstractFileListMakerAction {
    public EntryAction(FileListMaker flm) {
        super("3. upload", flm);
    }

    public void actionPerformed(ActionEvent arg0) {
        try {
            AnalyzeSiteConfigBean siteBean = (AnalyzeSiteConfigBean)this.flm.siteModel.getSelectedItem();
            if (siteBean == null) {
                JOptionPane.showMessageDialog(this.flm, "site\u304c\u9078\u629e\u3055\u308c\u3066\u3044\u307e\u305b\u3093.site\u3092\u9078\u629e\u3057\u3066\u304b\u3089\u3084\u308a\u76f4\u3057\u3066\u304f\u3060\u3055\u3044.", "site\u672a\u9078\u629e.", 1);
                return;
            }
            MappingItem[] items = this.check(this.flm.mappingModel.toArray());
            this.update(siteBean, items);
        }
        catch (Throwable t) {
            StringWriter swriter = new StringWriter();
            t.printStackTrace(new PrintWriter(swriter));
            JOptionPane.showMessageDialog(this.flm, swriter.toString(), "\u554f\u984c\u304c\u767a\u751f\u3057\u307e\u3057\u305f.", 0);
        }
    }

    private MappingItem[] check(MappingItem[] items) {
        ArrayList<MappingItem> list = new ArrayList<MappingItem>();
        int len = items.length;
        int i = 0;
        while (i < len) {
            MappingItem item = items[i];
            if (!item.isEmpty()) {
                if (item.urlIsEmpty()) {
                    this.flm.mappingModel.setStatus(i, " URL\u304c\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093.\u3053\u306e\u884c\u306f\u30b9\u30ad\u30c3\u30d7\u3057\u307e\u3059.");
                } else if (item.dirIsEmpty()) {
                    this.flm.mappingModel.setStatus(i, " local directory\u304c\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093.\u3053\u306e\u884c\u306f\u30b9\u30ad\u30c3\u30d7\u3057\u307e\u3059.");
                } else {
                    list.add(item);
                }
            }
            ++i;
        }
        return list.toArray(new MappingItem[0]);
    }

    private void update(AnalyzeSiteConfigBean siteBean, MappingItem[] items) throws Throwable {
        int len = items.length;
        if (len <= 0) {
            return;
        }
        Integer projectId = siteBean.getProjectId();
        Integer siteId = siteBean.getId();
        LocalHistoryBean lhistory = new LocalHistoryBean();
        lhistory.setSiteId(siteId);
        lhistory.setTimestamp(new Date());
        LocalHistoryDAO.instance.save(lhistory);
        Integer lhistoryId = lhistory.getId();
        ArrayList<DirTraceRobo> robolist = new ArrayList<DirTraceRobo>();
        int i = 0;
        while (i < len) {
            MappingItem item = items[i];
            DirectoryMapBean dirmap = new DirectoryMapBean();
            dirmap.setLocalHistoryId(lhistoryId);
            dirmap.setURL(item.url);
            dirmap.setDir(item.dir.getAbsolutePath());
            DirectoryMapDAO.instance.save(projectId, dirmap);
            DirTraceRobo robo = new DirTraceRobo(projectId, lhistoryId, dirmap.getId(), item.dir, this.flm.mappingModel, i);
            robo.start();
            robolist.add(robo);
            ++i;
        }
        new DirTraceRoboWatchDog(siteId, lhistoryId, this.flm, robolist.toArray(new DirTraceRobo[0])).start();
    }
}

