/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.ridual.r2.analyzerobo;

import java.net.PasswordAuthentication;
import java.util.List;
import jp.co.nri.ridual.r2.analyzerobo.protocol.RecheckUnit;
import jp.co.nri.ridual.r2.analyzerobo.protocol.RecheckUnitMap;
import jp.co.nri.ridual.r2.common.authmap.PasswordAuthenticationMap;
import jp.co.nri.ridual.r2.db.bean.common.AnalyzeHistoryBean;
import jp.co.nri.ridual.r2.db.bean.common.AnalyzeSiteConfigBean;
import jp.co.nri.ridual.r2.db.bean.project.ContentsAndVariationContainer;
import jp.co.nri.ridual.r2.db.dao.AnalyzeHistoryDAO;
import jp.co.nri.ridual.r2.db.dao.AnalyzeSiteConfigDAO;
import jp.co.nri.ridual.r2.db.dao.ContentsAndVariationDAO;
import jp.co.nri.ridual.r2.db.dao.ProjectLogDAO;
import jp.co.nri.ridual.r2.db.dao.RidualServerLogDAO;
import jp.co.nri.ridual.r2.robots.AbstractRidualRobo;
import jp.co.nri.ridual.r2.robots.buildreportrobo.BuildReportRoboController;

class RecheckOutLinkRobo
extends AbstractRidualRobo {
    private final Integer historyId;
    private final AnalyzeHistoryBean history;

    public RecheckOutLinkRobo(Integer historyId) throws Throwable {
        super("recheckOutLink");
        this.historyId = historyId;
        this.history = null;
    }

    public RecheckOutLinkRobo(AnalyzeHistoryBean bean) throws Throwable {
        super("recheckOutLink");
        this.historyId = null;
        this.history = bean;
    }

    protected void play() {
        try {
            Integer hid = this.historyId == null ? this.history.getId() : this.historyId;
            AnalyzeHistoryBean historyBean = null;
            AnalyzeSiteConfigBean site = AnalyzeSiteConfigDAO.instance.findByHistoryId(hid);
            if (site == null) {
                RidualServerLogDAO.getInstance().debug("\u4e0d\u6b63\u30a2\u30af\u30bb\u30b9?");
                return;
            }
            Integer projectId = site.getProjectId();
            if (this.historyId == null) {
                historyBean = this.history;
                if (historyBean.getDeleted() || !historyBean.getReady()) {
                    ProjectLogDAO.instance.recordIssueHistory(projectId, "recheck.outLinkRobo", "RecheckOutLinkRobo.notReady", hid, null, null);
                    return;
                }
            } else {
                historyBean = AnalyzeHistoryDAO.instance.updateRecheck(hid, super.getServerName());
                if (historyBean == null) {
                    ProjectLogDAO.instance.recordIssueHistory(projectId, "recheck.outLinkRobo", "RecheckOutLinkRobo.notReady", hid, null, null);
                    return;
                }
            }
            List list = ContentsAndVariationDAO.instance.findByIsInner(projectId, hid, false);
            ContentsAndVariationContainer[] beans = list.toArray(new ContentsAndVariationContainer[0]);
            PasswordAuthentication pa = PasswordAuthenticationMap.buildPasswordAuthentication(site.getLoginUser(), site.getDecodedLoginPassword());
            RecheckUnitMap map = new RecheckUnitMap();
            int len = beans.length;
            int i = 0;
            while (i < len) {
                ContentsAndVariationContainer bean = beans[i];
                RecheckUnit unit = map.getRecheckUnit(bean.contents.getScheme());
                if (unit != null) {
                    unit.recheck(projectId, bean, pa);
                }
                ++i;
            }
            BuildReportRoboController.instance.startBuildReportRoboRecheck(site, historyBean);
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("Robo.RecheckOutLinkRobo", e);
        }
    }
}

