/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.ridual.r2.analyzerobo.content.css;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import jp.co.nri.ridual.r2.analyzerobo.content.ContentProcessingUnitCommon;
import jp.co.nri.ridual.r2.analyzerobo.content.css.CSSHandler;
import jp.co.nri.ridual.r2.db.bean.project.ContentsBean;
import jp.co.nri.ridual.r2.db.bean.project.ContentsVariationBean;
import jp.co.nri.ridual.r2.db.dao.ProjectLogDAO;
import jp.co.nri.ridual.r2.resource.RidualResource;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.Parser;
import org.w3c.css.sac.helpers.ParserFactory;

public class CSSContentProcessingUnit
extends ContentProcessingUnitCommon {
    public CSSContentProcessingUnit() {
        String parser = RidualResource.ANALYZEROBO_PROPERTIES.getString("org.w3c.css.sac.parser");
        System.setProperty("org.w3c.css.sac.parser", parser);
    }

    public String[] getKeys() {
        return new String[]{"text/css"};
    }

    public void processing(Integer projectId, ContentsBean content, ContentsVariationBean variation, int depth, int filesLimit, int analyzeOptionFlags, byte[] b) {
        variation.setType(1057);
        try {
            InputStreamReader reader = new InputStreamReader((InputStream)new ByteArrayInputStream(b), this.charsetname);
            InputSource source = new InputSource((Reader)reader);
            Parser parser = new ParserFactory().makeParser();
            parser.setDocumentHandler((DocumentHandler)new CSSHandler(projectId, content, variation, depth, filesLimit, analyzeOptionFlags, false, null));
            try {
                parser.parseStyleSheet(source);
            }
            catch (Throwable t) {
                ProjectLogDAO.instance.recordIssueVariation(projectId, "analyze.css", "AnalyzeRobo.CSS.parse", content.getHistoryId(), content.getId(), variation.getId(), new Object[]{t.getMessage()}, t);
            }
        }
        catch (Throwable t) {
            ProjectLogDAO.instance.recordIssueVariation(projectId, "analyze.css", "AnalyzeRobo.CSS", content.getHistoryId(), content.getId(), variation.getId(), null, t);
        }
    }
}

