/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.ridual.r2.analyzerobo.content.html;

import jp.co.nri.ridual.r2.analyzerobo.content.html.AbstractHtmlElementUnit;
import jp.co.nri.ridual.r2.analyzerobo.content.html.HtmlAnaConfig;
import jp.co.nri.ridual.r2.analyzerobo.content.html.HtmlAnaData;
import jp.co.nri.ridual.r2.analyzerobo.content.html.HtmlContentProcessingUnit;
import jp.co.nri.ridual.r2.analyzerobo.content.html.HtmlNodeAnaData;
import jp.co.nri.ridual.r2.db.dao.ProjectLogDAO;
import org.w3c.dom.Element;

public class FormHtmlElementUnit
extends AbstractHtmlElementUnit {
    public String[] getKeys() {
        return new String[]{"form"};
    }

    public void play(Element elm, HtmlContentProcessingUnit hcpu, HtmlAnaConfig config, HtmlAnaData htmlAnaData, HtmlNodeAnaData nodeAnaData) {
        nodeAnaData.stacking = 1;
        this.checkNest(config, htmlAnaData);
        boolean isPost = this.isPost(elm, config);
        String action = this.getAndCheckAction(elm, config);
        if (!config.isInnerAndDepthAndTraceLink) {
            return;
        }
        if (action != null) {
            nodeAnaData.relationType = "html.form";
            nodeAnaData.relationURL = action;
            nodeAnaData.isPost = isPost;
            nodeAnaData.relationAttribute = "action";
        }
    }

    private void checkNest(HtmlAnaConfig config, HtmlAnaData htmlAnaData) {
        if (!htmlAnaData.formNodeAnaDataStack.empty()) {
            ProjectLogDAO.instance.recordIssueVariation(config.projectId, "analyze.html", "AnalyzeRobo.HTML.form.nest", config.historyId, config.contentsId, config.variationId, null, null);
        }
    }

    private boolean isPost(Element elm, HtmlAnaConfig config) {
        String method = elm.getAttribute("method");
        if (method == null || method.length() <= 0) {
            return false;
        }
        if (method.equalsIgnoreCase("post")) {
            return true;
        }
        if (method.equalsIgnoreCase("get")) {
            return false;
        }
        ProjectLogDAO.instance.recordIssueVariation(config.projectId, "analyze.html", "AnalyzeRobo.HTML.form.method", config.historyId, config.contentsId, config.variationId, new Object[]{method}, null);
        return false;
    }

    private String getAndCheckAction(Element elm, HtmlAnaConfig config) {
        String action = elm.getAttribute("action");
        if (action == null) {
            ProjectLogDAO.instance.recordIssueVariation(config.projectId, "analyze.html", "AnalyzeRobo.HTML.form.action.none", config.historyId, config.contentsId, config.variationId, null, null);
            return null;
        }
        if (action.trim().length() <= 0) {
            ProjectLogDAO.instance.recordIssueVariation(config.projectId, "analyze.html", "AnalyzeRobo.HTML.form.action.empty", config.historyId, config.contentsId, config.variationId, null, null);
            return null;
        }
        return action;
    }
}

